/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.GrayU8;
import georegression.struct.shapes.RectangleLength2D_I32;

public class LikelihoodHistCoupled_SB_U8
implements PixelLikelihood<GrayU8> {
    GrayU8 image;
    int maxPixelValue;
    int numBins;
    float[] hist = new float[0];

    public LikelihoodHistCoupled_SB_U8(int maxPixelValue, int numBins) {
        this.maxPixelValue = maxPixelValue + 1;
        this.numBins = numBins;
    }

    public void setImage(GrayU8 image) {
        this.image = image;
        if (this.hist.length != this.numBins) {
            this.hist = new float[this.numBins];
        }
    }

    public boolean isInBounds(int x, int y) {
        return this.image.isInBounds(x, y);
    }

    @Override
    public void createModel(RectangleLength2D_I32 target) {
        for (int y = 0; y < target.height; ++y) {
            int index = this.image.startIndex + (y + target.y0) * this.image.stride + target.x0;
            int x = 0;
            while (x < target.width) {
                int bin;
                int value = this.image.data[index] & 0xFF;
                int n = bin = this.numBins * value / this.maxPixelValue;
                this.hist[n] = this.hist[n] + 1.0f;
                ++x;
                ++index;
            }
        }
        float total = target.width * target.height;
        int i = 0;
        while (i < this.hist.length) {
            int n = i++;
            this.hist[n] = this.hist[n] / total;
        }
    }

    public float compute(int x, int y) {
        int index = this.image.startIndex + y * this.image.stride + x;
        int value = this.image.data[index] & 0xFF;
        int bin = this.numBins * value / this.maxPixelValue;
        return this.hist[bin];
    }
}

