/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.drawing.FiducialImageEngine;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeGenerator;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class QrCodeGeneratorImage
extends QrCodeGenerator {
    int pixelsPerModule;
    int borderModule = 2;
    FiducialImageEngine renderer = new FiducialImageEngine();

    public QrCodeGeneratorImage(int pixelsPerModule) {
        this.pixelsPerModule = pixelsPerModule;
        this.setRender(this.renderer);
    }

    @Override
    public QrCodeGeneratorImage render(QrCode qr) {
        super.render(qr);
        int borderPixels = this.renderer.getBorderPixels();
        this.adjustSize(borderPixels, qr.ppRight);
        this.adjustSize(borderPixels, qr.ppCorner);
        this.adjustSize(borderPixels, qr.ppDown);
        this.adjustSize(borderPixels, qr.bounds);
        for (int i = 0; i < qr.alignment.size(); ++i) {
            QrCode.Alignment a = (QrCode.Alignment)qr.alignment.get(i);
            a.pixel.x += (double)borderPixels;
            a.pixel.y += (double)borderPixels;
            a.threshold = 125.0;
        }
        qr.threshRight = 125.0;
        qr.threshCorner = 125.0;
        qr.threshDown = 125.0;
        return this;
    }

    @Override
    protected void initialize(QrCode qr) {
        this.markerWidth = this.pixelsPerModule * QrCode.totalModules(qr.version);
        super.initialize(qr);
        this.renderer.configure(this.borderModule * this.pixelsPerModule, this.pixelsPerModule * this.numModules);
        this.renderer.init();
    }

    private void adjustSize(int borderPixels, Polygon2D_F64 poly) {
        for (int i = 0; i < poly.size(); ++i) {
            Point2D_F64 p = poly.get(i);
            p.x += (double)borderPixels;
            p.y += (double)borderPixels;
        }
    }

    public int getBorderModule() {
        return this.borderModule;
    }

    public void setBorderModule(int borderModule) {
        this.borderModule = borderModule;
    }

    public FiducialImageEngine getRenderer() {
        return this.renderer;
    }

    public GrayU8 getGray() {
        return this.renderer.getGray();
    }

    public GrayF32 getGrayF32() {
        return this.renderer.getGrayF32();
    }
}

