/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareNode;
import java.util.ArrayList;
import java.util.List;

public class SquareGrid {
    public List<SquareNode> nodes = new ArrayList<SquareNode>();
    public int columns;
    public int rows;

    public void reset() {
        this.nodes.clear();
        this.columns = -1;
        this.rows = -1;
    }

    public SquareNode get(int row, int col) {
        return this.nodes.get(this.indexOf(row, col));
    }

    public void set(int row, int col, SquareNode node) {
        this.nodes.set(this.indexOf(row, col), node);
    }

    public int indexOf(int row, int col) {
        if (row < 0) {
            row = this.rows + row;
        }
        if (col < 0) {
            col = this.columns + col;
        }
        return row * this.columns + col;
    }

    public SquareNode getCornerByIndex(int index) {
        switch (index) {
            case 0: {
                return this.get(0, 0);
            }
            case 1: {
                return this.get(0, -1);
            }
            case 2: {
                return this.get(-1, -1);
            }
            case 3: {
                return this.get(-1, 0);
            }
        }
        throw new RuntimeException("BUG!");
    }

    public int getCornerIndex(SquareNode node) {
        int index = this.nodes.indexOf(node);
        int x = index % this.columns;
        int y = index / this.columns;
        if (x <= 0 && y <= 0) {
            return 0;
        }
        if (x > 0 && y <= 0) {
            return 1;
        }
        if (x > 0 && y > 0) {
            return 2;
        }
        if (x <= 0 && y > 0) {
            return 3;
        }
        throw new RuntimeException("Not corner!");
    }
}

