/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.UtilAngle;
import georegression.struct.curve.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;

public class EllipseClustersIntoHexagonalGrid
extends EllipseClustersIntoGrid {
    @Override
    public void process(List<EllipseRotated_F64> ellipses, List<List<EllipsesIntoClusters.Node>> clusters) {
        this.foundGrids.reset();
        if (clusters.size() == 0) {
            return;
        }
        for (int i = 0; i < clusters.size(); ++i) {
            boolean error;
            ArrayList<List<EllipseClustersIntoGrid.NodeInfo>> grid;
            block8: {
                int expected;
                List<EllipsesIntoClusters.Node> cluster = clusters.get(i);
                int clusterSize = cluster.size();
                if (clusterSize < 6) continue;
                this.computeNodeInfo(ellipses, cluster);
                if (!this.findContour(true)) {
                    if (!this.verbose) continue;
                    System.out.println("Contour find failed");
                    continue;
                }
                EllipseClustersIntoGrid.NodeInfo corner = this.selectSeedCorner();
                if (corner == null) {
                    if (!this.verbose) continue;
                    System.out.println("No corner found!");
                    continue;
                }
                grid = new ArrayList<List<EllipseClustersIntoGrid.NodeInfo>>();
                EllipseClustersIntoGrid.NodeInfo next = corner.left;
                next.marked = true;
                ArrayList<EllipseClustersIntoGrid.NodeInfo> column0 = new ArrayList<EllipseClustersIntoGrid.NodeInfo>();
                ArrayList<EllipseClustersIntoGrid.NodeInfo> column1 = new ArrayList<EllipseClustersIntoGrid.NodeInfo>();
                EllipseClustersIntoHexagonalGrid.bottomTwoColumns(corner, next, column0, column1);
                if (column0.size() < 2 || column1.size() < 2) {
                    if (!this.verbose) continue;
                    System.out.println("First two columns to small! " + column0.size() + " " + column1.size());
                    continue;
                }
                grid.add(column0);
                grid.add(column1);
                error = false;
                boolean even = true;
                do {
                    expected = column0.size();
                    column1 = new ArrayList();
                    column0 = column1;
                    if (!this.addRemainingColumns(column1, column0, even)) break block8;
                    even = !even;
                    grid.add(column1);
                } while (expected == column1.size());
                error = true;
                if (this.verbose) {
                    System.out.println("Unexpected column length! " + expected + " " + column1.size());
                }
            }
            if (error || grid.size() < 2) continue;
            if (this.checkDuplicates(grid)) {
                if (!this.verbose) continue;
                System.out.println("contains duplicates");
                continue;
            }
            this.saveResults(grid);
        }
    }

    @Override
    EllipseClustersIntoGrid.NodeInfo selectSeedCorner() {
        EllipseClustersIntoGrid.NodeInfo best = null;
        double bestScore = 0.0;
        double minAngle = 3.241592653589793;
        for (int i = 0; i < this.contour.size; ++i) {
            double r;
            double difference;
            double score;
            EllipseClustersIntoGrid.Edge middleL;
            EllipseClustersIntoGrid.Edge middleR;
            EllipseClustersIntoGrid.NodeInfo info = (EllipseClustersIntoGrid.NodeInfo)this.contour.get(i);
            if (info.angleBetween < minAngle || (middleR = EllipseClustersIntoHexagonalGrid.selectClosest(info.right, info, true)) == null || (middleL = EllipseClustersIntoHexagonalGrid.selectClosest(info, info.left, true)) == null || middleL.target != middleR.target || !((score = info.angleBetween - (difference = UtilAngle.dist((double)(r = UtilAngle.bound((double)(middleR.angle + Math.PI))), (double)middleL.angle))) > bestScore)) continue;
            best = info;
            bestScore = score;
        }
        if (best != null) {
            best.marked = true;
        }
        return best;
    }

    private boolean addRemainingColumns(List<EllipseClustersIntoGrid.NodeInfo> column1, List<EllipseClustersIntoGrid.NodeInfo> column0, boolean even) {
        int start = 0;
        if (even) {
            EllipseClustersIntoGrid.NodeInfo second = EllipseClustersIntoHexagonalGrid.selectClosestN(column0.get(0), column0.get(1));
            if (second == null) {
                return false;
            }
            second.marked = true;
            EllipseClustersIntoGrid.NodeInfo first = EllipseClustersIntoHexagonalGrid.selectClosestN(column0.get(0), second);
            if (first == null) {
                return false;
            }
            first.marked = true;
            column1.add(first);
            column1.add(second);
            start = 1;
        }
        for (int i = start; i < column0.size() - 1; ++i) {
            EllipseClustersIntoGrid.NodeInfo n = EllipseClustersIntoHexagonalGrid.selectClosestN(column0.get(i), column0.get(i + 1));
            if (n == null) {
                return false;
            }
            n.marked = true;
            column1.add(n);
        }
        EllipseClustersIntoGrid.NodeInfo n = EllipseClustersIntoHexagonalGrid.selectClosestN(column1.get(column1.size() - 1), column0.get(column0.size() - 1));
        if (n == null) {
            return true;
        }
        n.marked = true;
        column1.add(n);
        return true;
    }

    static void bottomTwoColumns(EllipseClustersIntoGrid.NodeInfo first, EllipseClustersIntoGrid.NodeInfo second, List<EllipseClustersIntoGrid.NodeInfo> column0, List<EllipseClustersIntoGrid.NodeInfo> column1) {
        EllipseClustersIntoGrid.NodeInfo t;
        column0.add(first);
        column0.add(second);
        EllipseClustersIntoGrid.NodeInfo a = EllipseClustersIntoHexagonalGrid.selectClosestN(first, second);
        if (a == null) {
            return;
        }
        a.marked = true;
        column1.add(a);
        EllipseClustersIntoGrid.NodeInfo b = second;
        while ((t = EllipseClustersIntoHexagonalGrid.selectClosestN(a, b)) != null) {
            t.marked = true;
            column1.add(t);
            a = t;
            t = EllipseClustersIntoHexagonalGrid.selectClosestN(a, b);
            if (t == null) break;
            t.marked = true;
            column0.add(t);
            b = t;
        }
    }

    static EllipseClustersIntoGrid.Edge selectClosest(EllipseClustersIntoGrid.NodeInfo a, EllipseClustersIntoGrid.NodeInfo b, boolean checkSide) {
        double bestScore = Double.MAX_VALUE;
        EllipseClustersIntoGrid.Edge bestEdgeA = null;
        EllipseClustersIntoGrid.Edge edgeAB = a.findEdge(b);
        double distAB = a.distance(b);
        if (edgeAB == null) {
            return null;
        }
        block0: for (int i = 0; i < a.edges.size; ++i) {
            EllipseClustersIntoGrid.Edge edgeA = (EllipseClustersIntoGrid.Edge)a.edges.get(i);
            EllipseClustersIntoGrid.NodeInfo aa = ((EllipseClustersIntoGrid.Edge)a.edges.get((int)i)).target;
            if (aa.marked) continue;
            for (int j = 0; j < b.edges.size; ++j) {
                double angle;
                EllipseClustersIntoGrid.Edge edgeB = (EllipseClustersIntoGrid.Edge)b.edges.get(j);
                EllipseClustersIntoGrid.NodeInfo bb = ((EllipseClustersIntoGrid.Edge)b.edges.get((int)j)).target;
                if (bb.marked || aa != bb || checkSide && UtilAngle.distanceCW((double)edgeAB.angle, (double)edgeA.angle) > 2.356194490192345 || (angle = UtilAngle.dist((double)edgeA.angle, (double)edgeB.angle)) < 0.3) continue;
                double da = EllipsesIntoClusters.axisAdjustedDistanceSq(a.ellipse, aa.ellipse);
                double db = EllipsesIntoClusters.axisAdjustedDistanceSq(b.ellipse, aa.ellipse);
                double diffRatio = Math.abs((da = Math.sqrt(da)) - (db = Math.sqrt(db))) / Math.max(da, db);
                if (diffRatio > 0.3) continue;
                double d = (da + db) / distAB + 0.1 * angle;
                if (!(d < bestScore)) continue block0;
                bestScore = d;
                bestEdgeA = (EllipseClustersIntoGrid.Edge)a.edges.get(i);
                continue block0;
            }
        }
        return bestEdgeA;
    }

    static EllipseClustersIntoGrid.NodeInfo selectClosestN(EllipseClustersIntoGrid.NodeInfo a, EllipseClustersIntoGrid.NodeInfo b) {
        EllipseClustersIntoGrid.Edge e = EllipseClustersIntoHexagonalGrid.selectClosest(a, b, true);
        if (e == null) {
            return null;
        }
        return e.target;
    }

    static EllipseClustersIntoGrid.NodeInfo selectClosestSide(EllipseClustersIntoGrid.NodeInfo a, EllipseClustersIntoGrid.NodeInfo b) {
        double ratio = 1.7321;
        EllipseClustersIntoGrid.NodeInfo best = null;
        double bestDistance = Double.MAX_VALUE;
        EllipseClustersIntoGrid.Edge bestEdgeA = null;
        EllipseClustersIntoGrid.Edge bestEdgeB = null;
        block0: for (int i = 0; i < a.edges.size; ++i) {
            EllipseClustersIntoGrid.NodeInfo aa = ((EllipseClustersIntoGrid.Edge)a.edges.get((int)i)).target;
            if (aa.marked) continue;
            for (int j = 0; j < b.edges.size; ++j) {
                double min;
                double max;
                EllipseClustersIntoGrid.NodeInfo bb = ((EllipseClustersIntoGrid.Edge)b.edges.get((int)j)).target;
                if (bb.marked || aa != bb) continue;
                double da = EllipsesIntoClusters.axisAdjustedDistanceSq(a.ellipse, aa.ellipse);
                double db = EllipsesIntoClusters.axisAdjustedDistanceSq(b.ellipse, aa.ellipse);
                if ((da = Math.sqrt(da)) > (db = Math.sqrt(db))) {
                    max = da;
                    min = db;
                } else {
                    max = db;
                    min = da;
                }
                double diffRatio = Math.abs(max - min * ratio) / max;
                if (diffRatio > 0.25) continue;
                double d = da + db;
                if (!(d < bestDistance)) continue block0;
                bestDistance = d;
                best = aa;
                bestEdgeA = (EllipseClustersIntoGrid.Edge)a.edges.get(i);
                bestEdgeB = (EllipseClustersIntoGrid.Edge)b.edges.get(j);
                continue block0;
            }
        }
        if (best != null) {
            double angleA = UtilAngle.distanceCW((double)bestEdgeA.angle, (double)bestEdgeB.angle);
            if (angleA < 0.7853981633974483) {
                return best;
            }
            return null;
        }
        return null;
    }

    void saveResults(List<List<EllipseClustersIntoGrid.NodeInfo>> graph) {
        EllipseClustersIntoGrid.Grid g = (EllipseClustersIntoGrid.Grid)this.foundGrids.grow();
        g.reset();
        g.columns = graph.get(0).size() + graph.get(1).size();
        g.rows = graph.size();
        for (int row = 0; row < g.rows; ++row) {
            List<EllipseClustersIntoGrid.NodeInfo> list = graph.get(row);
            for (int i = 0; i < g.columns; ++i) {
                if (i % 2 == row % 2) {
                    g.ellipses.add(list.get((int)(i / 2)).ellipse);
                    continue;
                }
                g.ellipses.add(null);
            }
        }
    }
}

