/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.core.graph.FeatureGraph2D;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class ChessboardCornerGraph {
    public DogArray<Node> corners = new DogArray(Node::new);

    public void convert(FeatureGraph2D graph) {
        Node c;
        int i;
        graph.nodes.resize(this.corners.size);
        graph.reset();
        for (i = 0; i < this.corners.size; ++i) {
            c = (Node)((Object)this.corners.get(i));
            FeatureGraph2D.Node n = (FeatureGraph2D.Node)graph.nodes.grow();
            n.reset();
            n.setTo(c.x, c.y);
            n.index = c.index;
        }
        for (i = 0; i < this.corners.size; ++i) {
            c = (Node)((Object)this.corners.get(i));
            for (int j = 0; j < 4; ++j) {
                if (c.edges[j] == null) continue;
                graph.connect(c.index, c.edges[j].index);
            }
        }
    }

    public Node growCorner() {
        Node n = (Node)((Object)this.corners.grow());
        n.reset();
        n.index = this.corners.size - 1;
        return n;
    }

    public Node findClosest(double x, double y) {
        double distance = Double.MAX_VALUE;
        Node closest = null;
        for (int i = 0; i < this.corners.size; ++i) {
            Node n = (Node)((Object)this.corners.get(i));
            double d = n.distance2(x, y);
            if (!(d < distance)) continue;
            distance = d;
            closest = n;
        }
        return closest;
    }

    public void print() {
        for (int cornerIdx = 0; cornerIdx < this.corners.size; ++cornerIdx) {
            Node n = (Node)((Object)this.corners.get(cornerIdx));
            System.out.printf("[%3d] {%3.0f, %3.0f} -> ", n.index, n.x, n.y);
            for (int i = 0; i < 4; ++i) {
                if (n.edges[i] == null) {
                    System.out.print("[    ] ");
                    continue;
                }
                System.out.printf("[ %2d ] ", n.edges[i].index);
            }
            System.out.println();
        }
    }

    public void reset() {
        this.corners.reset();
    }

    public static class Node
    extends Point2D_F64 {
        public int index;
        public double orientation;
        public final Node[] edges = new Node[4];

        public void set(ChessboardCorner c) {
            super.setTo((Point2D_F64)c);
            this.orientation = c.orientation;
        }

        public void putEdgesIntoList(List<Node> found) {
            found.clear();
            for (int i = 0; i < 4; ++i) {
                if (this.edges[i] == null) continue;
                found.add(this.edges[i]);
            }
        }

        public void rotateEdgesDown() {
            Node tmp = this.edges[0];
            for (int i = 1; i < 4; ++i) {
                this.edges[i - 1] = this.edges[i];
            }
            this.edges[3] = tmp;
        }

        public void reset() {
            this.y = -1.0;
            this.x = -1.0;
            this.index = -1;
            this.orientation = Double.NaN;
            for (int i = 0; i < 4; ++i) {
                this.edges[i] = null;
            }
        }

        public int countEdges() {
            int total = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.edges[i] == null) continue;
                ++total;
            }
            return total;
        }
    }
}

