/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.factory.transform.wavelet.FactoryWaveletCoiflet;
import boofcv.factory.transform.wavelet.FactoryWaveletDaub;
import boofcv.factory.transform.wavelet.FactoryWaveletHaar;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;

public class GFactoryWavelet {
    public static <C extends WlCoef, T extends ImageGray> WaveletDescription<C> haar(Class<T> imageType) {
        if (imageType == GrayF32.class) {
            return FactoryWaveletHaar.generate(false, 32);
        }
        if (GrayI.class.isAssignableFrom(imageType)) {
            return FactoryWaveletHaar.generate(true, 32);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageGray> WaveletDescription<C> daubJ(Class<T> imageType, int J) {
        if (imageType == GrayF32.class) {
            return FactoryWaveletDaub.daubJ_F32(J);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageGray> WaveletDescription<C> biorthogoal(Class<T> imageType, int J, BorderType borderType) {
        if (imageType == GrayF32.class) {
            return FactoryWaveletDaub.biorthogonal_F32(J, borderType);
        }
        if (GrayI.class.isAssignableFrom(imageType)) {
            return FactoryWaveletDaub.biorthogonal_I32(J, borderType);
        }
        return null;
    }

    public static <C extends WlCoef, T extends ImageGray> WaveletDescription<C> coiflet(Class<T> imageType, int J) {
        if (imageType == GrayF32.class) {
            return FactoryWaveletCoiflet.generate_F32(J);
        }
        return null;
    }
}

