/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ImplConvertYuyv_MT {
    public static void yuyvToPlanarRgb_U8(byte[] dataYV, Planar<GrayU8> output) {
        GrayU8 R = (GrayU8)output.getBand(0);
        GrayU8 G = (GrayU8)output.getBand(1);
        GrayU8 B = (GrayU8)output.getBand(2);
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexU = indexY + 1;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + 2] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = (byte)r;
                G.data[indexOut] = (byte)g;
                B.data[indexOut] = (byte)b;
                indexU += 4 * (col & 1);
                ++col;
                indexY += 2;
                ++indexOut;
            }
        });
    }

    public static void yuyvToPlanarRgb_F32(byte[] dataYV, Planar<GrayF32> output) {
        GrayF32 R = (GrayF32)output.getBand(0);
        GrayF32 G = (GrayF32)output.getBand(1);
        GrayF32 B = (GrayF32)output.getBand(2);
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexU = indexY + 1;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + 2] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = r;
                G.data[indexOut] = g;
                B.data[indexOut] = b;
                indexU += 4 * (col & 1);
                ++col;
                indexY += 2;
                ++indexOut;
            }
        });
    }

    public static void yuyvToInterleaved(byte[] dataYV, InterleavedU8 output) {
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexU = indexY + 1;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + 2] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = (byte)r;
                output.data[indexOut++] = (byte)g;
                output.data[indexOut++] = (byte)b;
                indexU += 4 * (col & 1);
                ++col;
                indexY += 2;
            }
        });
    }

    public static void yuyvToInterleaved(byte[] dataYV, InterleavedF32 output) {
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexU = indexY + 1;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataYV[indexY] & 0xFF) - 16);
                int cb = (dataYV[indexU] & 0xFF) - 128;
                int cr = (dataYV[indexU + 2] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = r;
                output.data[indexOut++] = g;
                output.data[indexOut++] = b;
                indexU += 4 * (col & 1);
                ++col;
                indexY += 2;
            }
        });
    }

    public static void yuyvToGray(byte[] dataYV, GrayU8 output) {
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                output.data[indexOut++] = dataYV[indexY];
                ++col;
                indexY += 2;
            }
        });
    }

    public static void yuyvToGray(byte[] dataYV, GrayF32 output) {
        int yStride = output.width * 2;
        BoofConcurrency.loopFor((int)0, (int)output.height, row -> {
            int indexY = row * yStride;
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                output.data[indexOut++] = dataYV[indexY] & 0xFF;
                ++col;
                indexY += 2;
            }
        });
    }
}

