/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.ii.impl;

import boofcv.alg.transform.ii.SparseIntegralGradient_NoBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.sparse.GradientValue_F32;

public class SparseIntegralHaar_NoBorder_F32
extends SparseIntegralGradient_NoBorder<GrayF32, GradientValue_F32> {
    private GradientValue_F32 ret = new GradientValue_F32();

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.w = 2 * this.r;
        this.x0 = this.y0 = -this.r;
        this.x1 = this.y1 = this.r;
    }

    public GradientValue_F32 compute(int x, int y) {
        int horizontalOffset = x - this.r;
        int indexSrc1 = ((GrayF32)this.input).startIndex + (y - this.r) * ((GrayF32)this.input).stride + horizontalOffset;
        int indexSrc2 = ((GrayF32)this.input).startIndex + y * ((GrayF32)this.input).stride + horizontalOffset;
        int indexSrc3 = ((GrayF32)this.input).startIndex + (y + this.r) * ((GrayF32)this.input).stride + horizontalOffset;
        float p0 = ((GrayF32)this.input).data[indexSrc1];
        float p1 = ((GrayF32)this.input).data[indexSrc1 + this.r];
        float p2 = ((GrayF32)this.input).data[indexSrc1 + this.w];
        float p3 = ((GrayF32)this.input).data[indexSrc2];
        float p5 = ((GrayF32)this.input).data[indexSrc2 + this.w];
        float p6 = ((GrayF32)this.input).data[indexSrc3];
        float p7 = ((GrayF32)this.input).data[indexSrc3 + this.r];
        float p8 = ((GrayF32)this.input).data[indexSrc3 + this.w];
        float left = p7 - p1 - p6 + p0;
        float right = p8 - p2 - p7 + p1;
        float top = p5 - p2 - p3 + p0;
        float bottom = p8 - p5 - p6 + p3;
        this.ret.x = right - left;
        this.ret.y = bottom - top;
        return this.ret;
    }

    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }
}

