/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.fft;

import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.alg.transform.fft.GeneralPurposeFFT_F64_1D;

public class GeneralPurposeFFT_F64_2D {
    private int rows;
    private int columns;
    private double[] t;
    private GeneralPurposeFFT_F64_1D fftColumns;
    private GeneralPurposeFFT_F64_1D fftRows;
    private boolean isPowerOfTwo = false;
    private double[] temp;
    private double[][] temp2;

    public GeneralPurposeFFT_F64_2D(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 0");
        }
        this.rows = rows;
        this.columns = columns;
        if (DiscreteFourierTransformOps.isPowerOf2(rows) && DiscreteFourierTransformOps.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            int oldNthreads = 1;
            int nt = 8 * oldNthreads * rows;
            if (2 * columns == 4 * oldNthreads) {
                nt >>= 1;
            } else if (2 * columns < 4 * oldNthreads) {
                nt >>= 2;
            }
            this.t = new double[nt];
        }
        this.fftRows = new GeneralPurposeFFT_F64_1D(rows);
        this.fftColumns = rows == columns ? this.fftRows : new GeneralPurposeFFT_F64_1D(columns);
        this.temp = new double[2 * rows];
    }

    public void complexForward(double[] a) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.complexForward(a);
            } else {
                this.fftColumns.complexForward(a);
            }
            return;
        }
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexForward(a, r * this.columns);
            }
            this.cdft2d_sub(-1, a, true);
            this.columns = oldn2;
        } else {
            int rowStride = 2 * this.columns;
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexForward(a, r * rowStride);
            }
            for (int c = 0; c < this.columns; ++c) {
                int idx2;
                int idx1;
                int r;
                int idx0 = 2 * c;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    idx2 = r * rowStride + idx0;
                    this.temp[idx1] = a[idx2];
                    this.temp[idx1 + 1] = a[idx2 + 1];
                }
                this.fftRows.complexForward(this.temp);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = 2 * r;
                    idx2 = r * rowStride + idx0;
                    a[idx2] = this.temp[idx1];
                    a[idx2 + 1] = this.temp[idx1 + 1];
                }
            }
        }
    }

    public void complexInverse(double[] a, boolean scale) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.complexInverse(a, scale);
            } else {
                this.fftColumns.complexInverse(a, scale);
            }
            return;
        }
        if (this.isPowerOfTwo) {
            int oldn2 = this.columns;
            this.columns = 2 * this.columns;
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexInverse(a, r * this.columns, scale);
            }
            this.cdft2d_sub(1, a, scale);
            this.columns = oldn2;
        } else {
            int rowspan = 2 * this.columns;
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.complexInverse(a, r * rowspan, scale);
            }
            for (int c = 0; c < this.columns; ++c) {
                int idx3;
                int idx2;
                int r;
                int idx1 = 2 * c;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = r * rowspan + idx1;
                    this.temp[idx2] = a[idx3];
                    this.temp[idx2 + 1] = a[idx3 + 1];
                }
                this.fftRows.complexInverse(this.temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = r * rowspan + idx1;
                    a[idx3] = this.temp[idx2];
                    a[idx3 + 1] = this.temp[idx2 + 1];
                }
            }
        }
    }

    public void realForward(double[] a) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.realForward(a);
            } else {
                this.fftColumns.realForward(a);
            }
            return;
        }
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        for (int r = 0; r < this.rows; ++r) {
            this.fftColumns.realForward(a, r * this.columns);
        }
        this.cdft2d_sub(-1, a, true);
        this.rdft2d_sub(1, a);
    }

    public void realForwardFull(double[] a) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.realForwardFull(a);
            } else {
                this.fftColumns.realForwardFull(a);
            }
            return;
        }
        if (this.isPowerOfTwo) {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realForward(a, r * this.columns);
            }
            this.cdft2d_sub(-1, a, true);
            this.rdft2d_sub(1, a);
            this.fillSymmetric(a);
        } else {
            this.declareRadixRealData();
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(double[] a, boolean scale) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.realInverse(a, scale);
            } else {
                this.fftColumns.realInverse(a, scale);
            }
            return;
        }
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("rows and columns must be power of two numbers");
        }
        this.rdft2d_sub(-1, a);
        this.cdft2d_sub(1, a, scale);
        for (int r = 0; r < this.rows; ++r) {
            this.fftColumns.realInverse(a, r * this.columns, scale);
        }
    }

    public void realInverseFull(double[] a, boolean scale) {
        if (this.rows == 1 || this.columns == 1) {
            if (this.rows > 1) {
                this.fftRows.realInverseFull(a, scale);
            } else {
                this.fftColumns.realInverseFull(a, scale);
            }
            return;
        }
        if (this.isPowerOfTwo) {
            for (int r = 0; r < this.rows; ++r) {
                this.fftColumns.realInverse2(a, r * this.columns, scale);
            }
            this.cdft2d_sub(1, a, scale);
            this.rdft2d_sub(1, a);
            this.fillSymmetric(a);
        } else {
            this.declareRadixRealData();
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void declareRadixRealData() {
        if (this.temp2 == null) {
            int n2d2 = this.columns / 2 + 1;
            this.temp2 = new double[n2d2][2 * this.rows];
        }
    }

    private void mixedRadixRealForwardFull(double[] a) {
        int idx1;
        int idx2;
        int r;
        int rowStride = 2 * this.columns;
        int n2d2 = this.columns / 2 + 1;
        double[][] temp = this.temp2;
        for (r = 0; r < this.rows; ++r) {
            this.fftColumns.realForward(a, r * this.columns);
        }
        for (r = 0; r < this.rows; ++r) {
            temp[0][r] = a[r * this.columns];
        }
        this.fftRows.realForwardFull(temp[0]);
        for (int c = 1; c < n2d2 - 1; ++c) {
            int idx0 = 2 * c;
            for (int r2 = 0; r2 < this.rows; ++r2) {
                int idx12 = 2 * r2;
                idx2 = r2 * this.columns + idx0;
                temp[c][idx12] = a[idx2];
                temp[c][idx12 + 1] = a[idx2 + 1];
            }
            this.fftRows.complexForward(temp[c]);
        }
        if (this.columns % 2 == 0) {
            for (r = 0; r < this.rows; ++r) {
                temp[n2d2 - 1][r] = a[r * this.columns + 1];
            }
            this.fftRows.realForwardFull(temp[n2d2 - 1]);
        } else {
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                int idx22 = r * this.columns;
                int idx3 = n2d2 - 1;
                temp[idx3][idx1] = a[idx22 + 2 * idx3];
                temp[idx3][idx1 + 1] = a[idx22 + 1];
            }
            this.fftRows.complexForward(temp[n2d2 - 1]);
        }
        for (r = 0; r < this.rows; ++r) {
            idx1 = 2 * r;
            for (int c = 0; c < n2d2; ++c) {
                int idx0 = 2 * c;
                idx2 = r * rowStride + idx0;
                a[idx2] = temp[c][idx1];
                a[idx2 + 1] = temp[c][idx1 + 1];
            }
        }
        for (r = 1; r < this.rows; ++r) {
            int idx5 = r * rowStride;
            int idx6 = (this.rows - r + 1) * rowStride;
            for (int c = n2d2; c < this.columns; ++c) {
                int idx13 = 2 * c;
                int idx23 = 2 * (this.columns - c);
                a[idx13] = a[idx23];
                a[idx13 + 1] = -a[idx23 + 1];
                int idx3 = idx5 + idx13;
                int idx4 = idx6 - idx13;
                a[idx3] = a[idx4];
                a[idx3 + 1] = -a[idx4 + 1];
            }
        }
    }

    private void mixedRadixRealInverseFull(double[] a, boolean scale) {
        int idx1;
        int idx2;
        int r;
        int rowStride = 2 * this.columns;
        int n2d2 = this.columns / 2 + 1;
        double[][] temp = this.temp2;
        for (r = 0; r < this.rows; ++r) {
            this.fftColumns.realInverse2(a, r * this.columns, scale);
        }
        for (r = 0; r < this.rows; ++r) {
            temp[0][r] = a[r * this.columns];
        }
        this.fftRows.realInverseFull(temp[0], scale);
        for (int c = 1; c < n2d2 - 1; ++c) {
            int idx0 = 2 * c;
            for (int r2 = 0; r2 < this.rows; ++r2) {
                int idx12 = 2 * r2;
                idx2 = r2 * this.columns + idx0;
                temp[c][idx12] = a[idx2];
                temp[c][idx12 + 1] = a[idx2 + 1];
            }
            this.fftRows.complexInverse(temp[c], scale);
        }
        if (this.columns % 2 == 0) {
            for (r = 0; r < this.rows; ++r) {
                temp[n2d2 - 1][r] = a[r * this.columns + 1];
            }
            this.fftRows.realInverseFull(temp[n2d2 - 1], scale);
        } else {
            for (r = 0; r < this.rows; ++r) {
                idx1 = 2 * r;
                int idx22 = r * this.columns;
                int idx3 = n2d2 - 1;
                temp[idx3][idx1] = a[idx22 + 2 * idx3];
                temp[idx3][idx1 + 1] = a[idx22 + 1];
            }
            this.fftRows.complexInverse(temp[n2d2 - 1], scale);
        }
        for (r = 0; r < this.rows; ++r) {
            idx1 = 2 * r;
            for (int c = 0; c < n2d2; ++c) {
                int idx0 = 2 * c;
                idx2 = r * rowStride + idx0;
                a[idx2] = temp[c][idx1];
                a[idx2 + 1] = temp[c][idx1 + 1];
            }
        }
        for (r = 1; r < this.rows; ++r) {
            int idx5 = r * rowStride;
            int idx6 = (this.rows - r + 1) * rowStride;
            for (int c = n2d2; c < this.columns; ++c) {
                int idx13 = 2 * c;
                int idx23 = 2 * (this.columns - c);
                a[idx13] = a[idx23];
                a[idx13 + 1] = -a[idx23 + 1];
                int idx3 = idx5 + idx13;
                int idx4 = idx6 - idx13;
                a[idx3] = a[idx4];
                a[idx3 + 1] = -a[idx4 + 1];
            }
        }
    }

    private void rdft2d_sub(int isgn, double[] a) {
        int n1h = this.rows >> 1;
        if (isgn < 0) {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                int idx1 = i * this.columns;
                int idx2 = j * this.columns;
                double xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n2 = idx1 + 1;
                a[n2] = a[n2] + a[idx2 + 1];
                a[idx2 + 1] = xi;
            }
        } else {
            for (int i = 1; i < n1h; ++i) {
                int j = this.rows - i;
                int idx1 = i * this.columns;
                int idx2 = j * this.columns;
                a[idx2] = 0.5 * (a[idx1] - a[idx2]);
                int n = idx1;
                a[n] = a[n] - a[idx2];
                a[idx2 + 1] = 0.5 * (a[idx1 + 1] + a[idx2 + 1]);
                int n3 = idx1 + 1;
                a[n3] = a[n3] - a[idx2 + 1];
            }
        }
    }

    private void cdft2d_sub(int isgn, double[] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                int idx1;
                int r;
                block22: {
                    int idx3;
                    int idx22;
                    int idx12;
                    int r2;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int c = 0; c < this.columns; c += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int idx13;
                            int r3;
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx13 = r3 * this.columns + c;
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[idx13];
                                this.t[idx23 + 1] = a[idx13 + 1];
                                this.t[idx32] = a[idx13 + 2];
                                this.t[idx32 + 1] = a[idx13 + 3];
                                this.t[idx4] = a[idx13 + 4];
                                this.t[idx4 + 1] = a[idx13 + 5];
                                this.t[idx5] = a[idx13 + 6];
                                this.t[idx5 + 1] = a[idx13 + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx13 = r3 * this.columns + c;
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[idx13] = this.t[idx23];
                                a[idx13 + 1] = this.t[idx23 + 1];
                                a[idx13 + 2] = this.t[idx32];
                                a[idx13 + 3] = this.t[idx32 + 1];
                                a[idx13 + 4] = this.t[idx4];
                                a[idx13 + 5] = this.t[idx4 + 1];
                                a[idx13 + 6] = this.t[idx5];
                                a[idx13 + 7] = this.t[idx5 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx12 = r2 * this.columns;
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        this.t[idx22] = a[idx12];
                        this.t[idx22 + 1] = a[idx12 + 1];
                        this.t[idx3] = a[idx12 + 2];
                        this.t[idx3 + 1] = a[idx12 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx12 = r2 * this.columns;
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a[idx12] = this.t[idx22];
                        a[idx12 + 1] = this.t[idx22 + 1];
                        a[idx12 + 2] = this.t[idx3];
                        a[idx12 + 3] = this.t[idx3 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int c = 0; c < this.columns; c += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int idx1;
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                        this.t[idx4] = a[idx1 + 4];
                        this.t[idx4 + 1] = a[idx1 + 5];
                        this.t[idx5] = a[idx1 + 6];
                        this.t[idx5 + 1] = a[idx1 + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = r * this.columns + c;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                        a[idx1 + 4] = this.t[idx4];
                        a[idx1 + 5] = this.t[idx4 + 1];
                        a[idx1 + 6] = this.t[idx5];
                        a[idx1 + 7] = this.t[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                    this.t[idx3] = a[idx1 + 2];
                    this.t[idx3 + 1] = a[idx1 + 3];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                    a[idx1 + 2] = this.t[idx3];
                    a[idx1 + 3] = this.t[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int idx1;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = r * this.columns;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void cdft2d_sub(int isgn, double[][] a, boolean scale) {
        block21: {
            block19: {
                int idx2;
                int r;
                block22: {
                    int idx3;
                    int idx22;
                    int r2;
                    block20: {
                        if (isgn != -1) break block19;
                        if (this.columns <= 4) break block20;
                        for (int c = 0; c < this.columns; c += 8) {
                            int idx5;
                            int idx4;
                            int idx32;
                            int idx23;
                            int r3;
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                this.t[idx23] = a[r3][c];
                                this.t[idx23 + 1] = a[r3][c + 1];
                                this.t[idx32] = a[r3][c + 2];
                                this.t[idx32 + 1] = a[r3][c + 3];
                                this.t[idx4] = a[r3][c + 4];
                                this.t[idx4 + 1] = a[r3][c + 5];
                                this.t[idx5] = a[r3][c + 6];
                                this.t[idx5 + 1] = a[r3][c + 7];
                            }
                            this.fftRows.complexForward(this.t, 0);
                            this.fftRows.complexForward(this.t, 2 * this.rows);
                            this.fftRows.complexForward(this.t, 4 * this.rows);
                            this.fftRows.complexForward(this.t, 6 * this.rows);
                            for (r3 = 0; r3 < this.rows; ++r3) {
                                idx23 = 2 * r3;
                                idx32 = 2 * this.rows + 2 * r3;
                                idx4 = idx32 + 2 * this.rows;
                                idx5 = idx4 + 2 * this.rows;
                                a[r3][c] = this.t[idx23];
                                a[r3][c + 1] = this.t[idx23 + 1];
                                a[r3][c + 2] = this.t[idx32];
                                a[r3][c + 3] = this.t[idx32 + 1];
                                a[r3][c + 4] = this.t[idx4];
                                a[r3][c + 5] = this.t[idx4 + 1];
                                a[r3][c + 6] = this.t[idx5];
                                a[r3][c + 7] = this.t[idx5 + 1];
                            }
                        }
                        break block21;
                    }
                    if (this.columns != 4) break block22;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        this.t[idx22] = a[r2][0];
                        this.t[idx22 + 1] = a[r2][1];
                        this.t[idx3] = a[r2][2];
                        this.t[idx3 + 1] = a[r2][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx22 = 2 * r2;
                        idx3 = 2 * this.rows + 2 * r2;
                        a[r2][0] = this.t[idx22];
                        a[r2][1] = this.t[idx22 + 1];
                        a[r2][2] = this.t[idx3];
                        a[r2][3] = this.t[idx3 + 1];
                    }
                    break block21;
                }
                if (this.columns != 2) break block21;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                }
                break block21;
            }
            if (this.columns > 4) {
                for (int c = 0; c < this.columns; c += 8) {
                    int idx5;
                    int idx4;
                    int idx3;
                    int idx2;
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        this.t[idx2] = a[r][c];
                        this.t[idx2 + 1] = a[r][c + 1];
                        this.t[idx3] = a[r][c + 2];
                        this.t[idx3 + 1] = a[r][c + 3];
                        this.t[idx4] = a[r][c + 4];
                        this.t[idx4 + 1] = a[r][c + 5];
                        this.t[idx5] = a[r][c + 6];
                        this.t[idx5 + 1] = a[r][c + 7];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                    this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        idx4 = idx3 + 2 * this.rows;
                        idx5 = idx4 + 2 * this.rows;
                        a[r][c] = this.t[idx2];
                        a[r][c + 1] = this.t[idx2 + 1];
                        a[r][c + 2] = this.t[idx3];
                        a[r][c + 3] = this.t[idx3 + 1];
                        a[r][c + 4] = this.t[idx4];
                        a[r][c + 5] = this.t[idx4 + 1];
                        a[r][c + 6] = this.t[idx5];
                        a[r][c + 7] = this.t[idx5 + 1];
                    }
                }
            } else if (this.columns == 4) {
                int idx3;
                int idx2;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                    this.t[idx3] = a[r][2];
                    this.t[idx3 + 1] = a[r][3];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    idx3 = 2 * this.rows + 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                    a[r][2] = this.t[idx3];
                    a[r][3] = this.t[idx3 + 1];
                }
            } else if (this.columns == 2) {
                int idx2;
                int r;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[r][0];
                    this.t[idx2 + 1] = a[r][1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[r][0] = this.t[idx2];
                    a[r][1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void fillSymmetric(double[] a) {
        int idx3;
        int c;
        int idx2;
        int idx1;
        int r;
        int twon2 = 2 * this.columns;
        int n1d2 = this.rows / 2;
        for (r = this.rows - 1; r >= 1; --r) {
            idx1 = r * this.columns;
            idx2 = 2 * idx1;
            for (c = 0; c < this.columns; c += 2) {
                a[idx2 + c] = a[idx1 + c];
                a[idx1 + c] = 0.0;
                a[idx2 + c + 1] = a[idx1 + c + 1];
                a[idx1 + c + 1] = 0.0;
            }
        }
        for (r = 1; r < n1d2; ++r) {
            idx2 = r * twon2;
            idx3 = (this.rows - r) * twon2;
            a[idx2 + this.columns] = a[idx3 + 1];
            a[idx2 + this.columns + 1] = -a[idx3];
        }
        for (r = 1; r < n1d2; ++r) {
            idx2 = r * twon2;
            idx3 = (this.rows - r + 1) * twon2;
            for (c = this.columns + 2; c < twon2; c += 2) {
                a[idx2 + c] = a[idx3 - c];
                a[idx2 + c + 1] = -a[idx3 - c + 1];
            }
        }
        for (r = 0; r <= this.rows / 2; ++r) {
            idx1 = r * twon2;
            int idx4 = (this.rows - r) % this.rows * twon2;
            for (c = 0; c < twon2; c += 2) {
                idx2 = idx1 + c;
                idx3 = idx4 + (twon2 - c) % twon2;
                a[idx3] = a[idx2];
                a[idx3 + 1] = -a[idx2 + 1];
            }
        }
        a[this.columns] = -a[1];
        a[1] = 0.0;
        idx1 = n1d2 * twon2;
        a[idx1 + this.columns] = -a[idx1 + 1];
        a[idx1 + 1] = 0.0;
        a[idx1 + this.columns + 1] = 0.0;
    }
}

