/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;

public abstract class NearestNeighborPixelMB<T extends ImageMultiBand<T>>
implements InterpolatePixelMB<T> {
    protected ImageBorder<T> border;
    protected T orig;
    protected int stride;
    protected int width;
    protected int height;

    @Override
    public void setBorder(ImageBorder<T> border) {
        this.border = border;
    }

    @Override
    public void setImage(T image) {
        if (this.border != null) {
            this.border.setImage(image);
        }
        this.orig = image;
        this.stride = this.orig.getStride();
        this.width = this.orig.getWidth();
        this.height = this.orig.getHeight();
    }

    @Override
    public T getImage() {
        return this.orig;
    }

    @Override
    public boolean isInFastBounds(float x, float y) {
        return x >= 0.0f && y >= 0.0f && x <= (float)(this.width - 1) && y <= (float)(this.height - 1);
    }

    @Override
    public int getFastBorderX() {
        return 0;
    }

    @Override
    public int getFastBorderY() {
        return 0;
    }

    @Override
    public ImageBorder<T> getBorder() {
        return this.border;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.orig.getImageType();
    }
}

