/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.down;

import boofcv.alg.filter.convolve.down.UtilDownConvolve;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class ConvolveDownNoBorderStandard {
    public static void horizontal(Kernel1D_F32 kernel, GrayF32 input, GrayF32 output, int skip) {
        if (kernel.offset != kernel.width / 2 || kernel.width % 2 != 1) {
            throw new IllegalArgumentException("Non symmetric odd kernels not supported");
        }
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, kernelWidth - offset - 1);
        int height = input.height;
        int offsetX = UtilDownConvolve.computeOffset(skip, offset);
        for (int i = 0; i < height; ++i) {
            int indexDst = output.startIndex + i * output.stride + offsetX / skip;
            int j = input.startIndex + i * input.stride - offset;
            int jEnd = j + widthEnd;
            j += offsetX;
            while (j <= jEnd) {
                float total = 0.0f;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = total;
                j += skip;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, GrayF32 input, GrayF32 output, int skip) {
        int offsetY;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width;
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offsetY = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int i;
            int indexDst = output.startIndex + y / skip * output.stride;
            int iEnd = i + width;
            for (i = input.startIndex + (y - radius) * input.stride; i < iEnd; ++i) {
                float total = 0.0f;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, GrayF32 input, GrayF32 output, int skip) {
        int offset;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKernel = kernel.data;
        int radius = kernel.getRadius();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius);
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offset = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x <= widthEnd; x += skip) {
                float total = 0.0f;
                int indexKer = 0;
                for (int ki = -radius; ki <= radius; ++ki) {
                    int indexSrc = input.startIndex + (y + ki) * input.stride + x;
                    for (int kj = -radius; kj <= radius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 input, GrayI16 output, int skip) {
        byte[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, kernelWidth - offset - 1);
        int height = input.height;
        int offsetX = UtilDownConvolve.computeOffset(skip, offset);
        for (int i = 0; i < height; ++i) {
            int indexDst = output.startIndex + i * output.stride + offsetX / skip;
            int j = input.startIndex + i * input.stride - offset;
            int jEnd = j + widthEnd;
            j += offsetX;
            while (j <= jEnd) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
                j += skip;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 input, GrayI16 output, int skip) {
        int offsetY;
        byte[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width;
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offsetY = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int i;
            int indexDst = output.startIndex + y / skip * output.stride;
            int iEnd = i + width;
            for (i = input.startIndex + (y - radius) * input.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 input, GrayI16 output, int skip) {
        int offset;
        byte[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKernel = kernel.data;
        int radius = kernel.getRadius();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius);
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offset = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x <= widthEnd; x += skip) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -radius; ki <= radius; ++ki) {
                    int indexSrc = input.startIndex + (y + ki) * input.stride + x;
                    for (int kj = -radius; kj <= radius; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 input, GrayI16 output, int skip) {
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, kernelWidth - offset - 1);
        int height = input.height;
        int offsetX = UtilDownConvolve.computeOffset(skip, offset);
        for (int i = 0; i < height; ++i) {
            int indexDst = output.startIndex + i * output.stride + offsetX / skip;
            int j = input.startIndex + i * input.stride - offset;
            int jEnd = j + widthEnd;
            j += offsetX;
            while (j <= jEnd) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)total;
                j += skip;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 input, GrayI16 output, int skip) {
        int offsetY;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.width;
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offsetY = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int i;
            int indexDst = output.startIndex + y / skip * output.stride;
            int iEnd = i + width;
            for (i = input.startIndex + (y - radius) * input.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 input, GrayI16 output, int skip) {
        int offset;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKernel = kernel.data;
        int radius = kernel.getRadius();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius);
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offset = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x <= widthEnd; x += skip) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -radius; ki <= radius; ++ki) {
                    int indexSrc = input.startIndex + (y + ki) * input.stride + x;
                    for (int kj = -radius; kj <= radius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)total;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 input, GrayI8 output, int skip, int divisor) {
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, kernelWidth - offset - 1);
        int height = input.height;
        int offsetX = UtilDownConvolve.computeOffset(skip, offset);
        for (int i = 0; i < height; ++i) {
            int indexDst = output.startIndex + i * output.stride + offsetX / skip;
            int j = input.startIndex + i * input.stride - offset;
            int jEnd = j + widthEnd;
            j += offsetX;
            while (j <= jEnd) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc++] & 0xFF) * dataKer[k];
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
                j += skip;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 input, GrayI8 output, int skip, int divisor) {
        int offsetY;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = input.width;
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offsetY = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int i;
            int indexDst = output.startIndex + y / skip * output.stride;
            int iEnd = i + width;
            for (i = input.startIndex + (y - radius) * input.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 input, GrayI8 output, int skip, int divisor) {
        int offset;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKernel = kernel.data;
        int radius = kernel.getRadius();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius);
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        int halfDivisor = divisor / 2;
        for (int y = offset = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x <= widthEnd; x += skip) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -radius; ki <= radius; ++ki) {
                    int indexSrc = input.startIndex + (y + ki) * input.stride + x;
                    for (int kj = -radius; kj <= radius; ++kj) {
                        total += (dataSrc[indexSrc + kj] & 0xFF) * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (byte)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 input, GrayI16 output, int skip, int divisor) {
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, kernelWidth - offset - 1);
        int height = input.height;
        int offsetX = UtilDownConvolve.computeOffset(skip, offset);
        for (int i = 0; i < height; ++i) {
            int indexDst = output.startIndex + i * output.stride + offsetX / skip;
            int j = input.startIndex + i * input.stride - offset;
            int jEnd = j + widthEnd;
            j += offsetX;
            while (j <= jEnd) {
                int total = 0;
                int indexSrc = j;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc++] * dataKer[k];
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
                j += skip;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 input, GrayI16 output, int skip, int divisor) {
        int offsetY;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int halfDivisor = divisor / 2;
        int width = input.width;
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        for (int y = offsetY = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int i;
            int indexDst = output.startIndex + y / skip * output.stride;
            int iEnd = i + width;
            for (i = input.startIndex + (y - radius) * input.stride; i < iEnd; ++i) {
                int total = 0;
                int indexSrc = i;
                for (int k = 0; k < kernelWidth; ++k) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 input, GrayI16 output, int skip, int divisor) {
        int offset;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKernel = kernel.data;
        int radius = kernel.getRadius();
        int widthEnd = UtilDownConvolve.computeMaxSide(input.width, skip, radius);
        int heightEnd = UtilDownConvolve.computeMaxSide(input.height, skip, radius);
        int halfDivisor = divisor / 2;
        for (int y = offset = UtilDownConvolve.computeOffset(skip, radius); y <= heightEnd; y += skip) {
            int indexDst = output.startIndex + y / skip * output.stride + offset / skip;
            for (int x = offset; x <= widthEnd; x += skip) {
                int total = 0;
                int indexKer = 0;
                for (int ki = -radius; ki <= radius; ++ki) {
                    int indexSrc = input.startIndex + (y + ki) * input.stride + x;
                    for (int kj = -radius; kj <= radius; ++kj) {
                        total += dataSrc[indexSrc + kj] * dataKernel[indexKer++];
                    }
                }
                dataDst[indexDst++] = (short)((total + halfDivisor) / divisor);
            }
        }
    }
}

