/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class ImplMedianSortNaive {
    public static void process(GrayI input, GrayI output, int radiusX, int radiusY, @Nullable GrowArray<DogArray_I32> workArrays) {
        int w = 2 * radiusX + 1;
        int h = 2 * radiusY + 1;
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I32::new);
        DogArray_I32 workspace = (DogArray_I32)workArrays.grow();
        boolean y0 = false;
        int y1 = input.height;
        int[] workArray = BoofMiscOps.checkDeclare((DogArray_I32)workspace, (int)(w * h), (boolean)false);
        for (int y = 0; y < y1; ++y) {
            int minI = y - radiusY;
            int maxI = y + radiusY + 1;
            if (minI < 0) {
                minI = 0;
            }
            if (maxI > input.height) {
                maxI = input.height;
            }
            for (int x = 0; x < input.width; ++x) {
                int minJ = x - radiusX;
                int maxJ = x + radiusX + 1;
                if (minJ < 0) {
                    minJ = 0;
                }
                if (maxJ > input.width) {
                    maxJ = input.width;
                }
                int index = 0;
                for (int i = minI; i < maxI; ++i) {
                    for (int j = minJ; j < maxJ; ++j) {
                        workArray[index++] = input.unsafe_get(j, i);
                    }
                }
                int median = QuickSelect.select((int[])workArray, (int)(index / 2), (int)index);
                output.set(x, y, median);
            }
        }
    }

    public static void process(GrayF32 input, GrayF32 output, int radiusX, int radiusY, @Nullable GrowArray<DogArray_F32> workArrays) {
        int w = 2 * radiusX + 1;
        int h = 2 * radiusY + 1;
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_F32::new);
        DogArray_F32 workspace = (DogArray_F32)workArrays.grow();
        boolean y0 = false;
        int y1 = input.height;
        float[] workArray = BoofMiscOps.checkDeclare((DogArray_F32)workspace, (int)(w * h), (boolean)false);
        for (int y = 0; y < y1; ++y) {
            int minI = y - radiusY;
            int maxI = y + radiusY + 1;
            if (minI < 0) {
                minI = 0;
            }
            if (maxI > input.height) {
                maxI = input.height;
            }
            for (int x = 0; x < input.width; ++x) {
                int minJ = x - radiusX;
                int maxJ = x + radiusX + 1;
                if (minJ < 0) {
                    minJ = 0;
                }
                if (maxJ > input.width) {
                    maxJ = input.width;
                }
                int index = 0;
                for (int i = minI; i < maxI; ++i) {
                    for (int j = minJ; j < maxJ; ++j) {
                        workArray[index++] = input.unsafe_get(j, i);
                    }
                }
                float median = QuickSelect.select((float[])workArray, (int)(index / 2), (int)index);
                output.set(x, y, median);
            }
        }
    }

    public static void process(ImageGray input, ImageGray output, int radiusX, int radiusY, @Nullable GrowArray workspace) {
        if (input.getDataType().isInteger()) {
            ImplMedianSortNaive.process((GrayI)input, (GrayI)output, radiusX, radiusY, (GrowArray<DogArray_I32>)workspace);
        } else {
            ImplMedianSortNaive.process((GrayF32)input, (GrayF32)output, radiusX, radiusY, (GrowArray<DogArray_F32>)workspace);
        }
    }

    public static void process(Planar input, Planar output, int radiusX, int radiusY, @Nullable GrowArray workspace) {
        for (int i = 0; i < input.getNumBands(); ++i) {
            ImplMedianSortNaive.process(input.getBand(i), output.getBand(i), radiusX, radiusY, workspace);
        }
    }
}

