/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AssignPixelValue_MB;
import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageInterleaved;
import georegression.struct.point.Point2D_F32;

public class ImageDistortBasic_IL<Input extends ImageInterleaved<Input>, Output extends ImageInterleaved<Output>>
extends ImageDistortBasic<Input, Output, InterpolatePixelMB<Input>> {
    AssignPixelValue_MB<Output> assigner;
    float[] values = new float[0];
    Point2D_F32 distorted = new Point2D_F32();

    public ImageDistortBasic_IL(AssignPixelValue_MB<Output> assigner, InterpolatePixelMB<Input> interp) {
        super(interp);
        this.assigner = assigner;
    }

    @Override
    protected void init(Input srcImg, Output dstImg) {
        super.init(srcImg, dstImg);
        if (this.values.length != srcImg.getNumBands()) {
            this.values = new float[srcImg.getNumBands()];
        }
        this.assigner.setImage(dstImg);
    }

    @Override
    protected void applyAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                ((InterpolatePixelMB)this.interp).get(this.distorted.x, this.distorted.y, this.values);
                this.assigner.assign(indexDst, this.values);
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
            }
        }
    }

    @Override
    protected void applyAll(GrayU8 mask) {
        float maxWidth = ((ImageInterleaved)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageInterleaved)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                ((InterpolatePixelMB)this.interp).get(this.distorted.x, this.distorted.y, this.values);
                this.assigner.assign(indexDst, this.values);
                mask.data[indexMsk] = this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight ? (byte)1 : 0;
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
                ++indexMsk;
            }
        }
    }

    @Override
    protected void applyOnlyInside() {
        float maxWidth = ((ImageInterleaved)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageInterleaved)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                    ((InterpolatePixelMB)this.interp).get(this.distorted.x, this.distorted.y, this.values);
                    this.assigner.assign(indexDst, this.values);
                }
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
            }
        }
    }

    @Override
    protected void applyOnlyInside(GrayU8 mask) {
        float maxWidth = ((ImageInterleaved)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageInterleaved)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageInterleaved)this.dstImg).startIndex + ((ImageInterleaved)this.dstImg).stride * y + this.x0 * ((ImageInterleaved)this.dstImg).numBands;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                    ((InterpolatePixelMB)this.interp).get(this.distorted.x, this.distorted.y, this.values);
                    this.assigner.assign(indexDst, this.values);
                    mask.data[indexMsk] = 1;
                } else {
                    mask.data[indexMsk] = 0;
                }
                ++x;
                indexDst += ((ImageInterleaved)this.dstImg).numBands;
                ++indexMsk;
            }
        }
    }
}

