/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS32;

public interface AssignPixelValue_MB<T extends ImageMultiBand<T>> {
    public void setImage(T var1);

    public void assign(int var1, float[] var2);

    public static class S32
    implements AssignPixelValue_MB<InterleavedS32> {
        InterleavedS32 image;

        @Override
        public void setImage(InterleavedS32 image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float[] value) {
            for (int i = 0; i < this.image.numBands; ++i) {
                this.image.data[indexDst + i] = (int)value[i];
            }
        }
    }

    public static class I16<T extends InterleavedI16<T>>
    implements AssignPixelValue_MB<T> {
        T image;

        @Override
        public void setImage(T image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float[] value) {
            for (int i = 0; i < ((InterleavedI16)this.image).numBands; ++i) {
                ((InterleavedI16)this.image).data[indexDst + i] = (short)value[i];
            }
        }
    }

    public static class I8<T extends InterleavedI8<T>>
    implements AssignPixelValue_MB<T> {
        T image;

        @Override
        public void setImage(T image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float[] value) {
            for (int i = 0; i < ((InterleavedI8)this.image).numBands; ++i) {
                ((InterleavedI8)this.image).data[indexDst + i] = (byte)value[i];
            }
        }
    }

    public static class F32
    implements AssignPixelValue_MB<InterleavedF32> {
        InterleavedF32 image;

        @Override
        public void setImage(InterleavedF32 image) {
            this.image = image;
        }

        @Override
        public void assign(int indexDst, float[] value) {
            for (int i = 0; i < this.image.numBands; ++i) {
                this.image.data[indexDst + i] = value[i];
            }
        }
    }
}

