/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.distort.pinhole.PixelTransformPinholeNorm_F64;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.alg.mvs.impl.ImplMultiViewStereoOps;
import boofcv.misc.BoofLambdas;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class MultiViewStereoOps {
    public static void maskOutPointsInCloud(List<Point3D_F64> cloud, GrayF32 disparity, DisparityParameters parameters, Se3_F64 cloud_to_stereo, Point2Transform2_F64 rectNorm_to_dispPixel, double tolerance, GrayU8 mask) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)mask);
        parameters.checkValidity();
        double baselineFocal = parameters.baseline * parameters.pinhole.fx;
        Point3D_F64 cameraPt = new Point3D_F64();
        Point3D_F64 rectPt = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int cloudIdx = 0; cloudIdx < cloud.size(); ++cloudIdx) {
            double projD;
            double imagD;
            Point3D_F64 cloudPt = cloud.get(cloudIdx);
            SePointOps_F64.transform((Se3_F64)cloud_to_stereo, (Point3D_F64)cloudPt, (Point3D_F64)cameraPt);
            if (cameraPt.z <= 0.0) continue;
            GeometryMath_F64.mult((DMatrixRMaj)parameters.rotateToRectified, (GeoTuple3D_F64)cameraPt, (GeoTuple3D_F64)rectPt);
            rectNorm_to_dispPixel.compute(rectPt.x / rectPt.z, rectPt.y / rectPt.z, pixel);
            int px = (int)(pixel.x + 0.5);
            int py = (int)(pixel.y + 0.5);
            if (pixel.x < -0.5 || pixel.y < -0.5 || px >= disparity.width || py >= disparity.height || mask.unsafe_get(px, py) != 0 || (imagD = (double)disparity.unsafe_get(px, py)) >= (double)parameters.disparityRange || (projD = baselineFocal / rectPt.z - (double)parameters.disparityMin) < 0.0 || projD > (double)parameters.disparityRange || Math.abs(imagD - projD) > tolerance) continue;
            mask.unsafe_set(px, py, 1);
        }
    }

    public static void disparityToCloud(GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, BoofLambdas.PixXyzConsumer_F64 consumer) {
        ImplMultiViewStereoOps.disparityToCloud(disparity, mask, parameters, consumer);
    }

    public static void disparityToCloud(ImageGray<?> disparity, DisparityParameters parameters, @Nullable PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        if (pixelToNorm == null) {
            pixelToNorm = new PixelTransformPinholeNorm_F64().fset(parameters.pinhole);
        }
        if (disparity instanceof GrayF32) {
            ImplMultiViewStereoOps.disparityToCloud((GrayF32)disparity, parameters, (PixelTransform<Point2D_F64>)pixelToNorm, consumer);
        } else if (disparity instanceof GrayU8) {
            ImplMultiViewStereoOps.disparityToCloud((GrayU8)disparity, parameters, (PixelTransform<Point2D_F64>)pixelToNorm, consumer);
        } else {
            throw new IllegalArgumentException("Unknown image type. " + disparity.getClass().getSimpleName());
        }
    }
}

