/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.ops.DConvertMatrixStruct;

public class MultiBaselineDisparityMedian {
    final CameraPinhole fusedIntrinsic = new CameraPinhole();
    final int fusedDisparityMin = 0;
    final int fusedDisparityRange = 100;
    double fusedBaseline;
    PixelTransform<Point2D_F64> pixelOrig_to_Undist;
    final DogArray<DisparityImage> images = new DogArray(DisparityImage::new, DisparityImage::reset);
    final FusedImage fused = new FusedImage();
    private final Homography2D_F64 rect = new Homography2D_F64();

    public void initialize(CameraPinhole intrinsic, PixelTransform<Point2D_F64> pixelDist_to_Undist) {
        this.fusedIntrinsic.setTo(intrinsic);
        this.images.reset();
        this.fused.resize(intrinsic.width, intrinsic.height);
        this.pixelOrig_to_Undist = pixelDist_to_Undist;
    }

    public void addDisparity(GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, DMatrixRMaj undist_to_rect_px) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)mask);
        parameters.checkValidity();
        DisparityImage d = (DisparityImage)this.images.grow();
        d.disparity.setTo((ImageGray)disparity);
        d.mask.setTo((ImageGray)mask);
        d.undist_to_rect_px.set((DMatrixD1)undist_to_rect_px);
        d.parameters.setTo(parameters);
    }

    public boolean process(GrayF32 disparity) {
        int i;
        BoofMiscOps.checkTrue((!this.images.isEmpty() ? 1 : 0) != 0, (String)"No images have been added");
        disparity.reshape(this.fused.width, this.fused.height);
        this.fusedBaseline = 0.0;
        for (i = 0; i < this.images.size; ++i) {
            this.fusedBaseline = Math.max(this.fusedBaseline, ((DisparityImage)this.images.get((int)i)).parameters.baseline);
        }
        for (i = 0; i < this.images.size; ++i) {
            if (this.addToFusedImage((DisparityImage)this.images.get(i))) continue;
            return false;
        }
        this.computeFused(disparity);
        this.computeDynamicParameters(disparity);
        return true;
    }

    boolean addToFusedImage(DisparityImage image) {
        GrayF32 disparity = image.disparity;
        GrayU8 mask = image.mask;
        DisparityParameters imageParam = image.parameters;
        float imageRange = imageParam.disparityRange;
        float imageMin = imageParam.disparityMin;
        double imageFocalX = imageParam.pinhole.fx;
        double imageBaseline = imageParam.baseline;
        CameraPinhole imagePinhole = imageParam.pinhole;
        DConvertMatrixStruct.convert((DMatrixRMaj)image.undist_to_rect_px, (DMatrix3x3)this.rect);
        Point2D_F64 undistPix = new Point2D_F64();
        Point2D_F64 rectPix = new Point2D_F64();
        for (int origPixY = 0; origPixY < this.fused.height; ++origPixY) {
            for (int origPixX = 0; origPixX < this.fused.width; ++origPixX) {
                float imageDisp;
                this.pixelOrig_to_Undist.compute(origPixX, origPixY, (Object)undistPix);
                HomographyPointOps_F64.transform((Homography2D_F64)this.rect, (double)undistPix.x, (double)undistPix.y, (Point2D_F64)rectPix);
                if (rectPix.x < 0.0 || rectPix.y < 0.0) continue;
                int rectPixX = (int)(rectPix.x + 0.5);
                int rectPixY = (int)(rectPix.y + 0.5);
                if (rectPixX >= mask.width || rectPixY >= mask.height || mask.unsafe_get(rectPixX, rectPixY) == 0 || (imageDisp = disparity.unsafe_get(rectPixX, rectPixY)) >= imageRange) continue;
                if (imageDisp + imageMin != 0.0f) {
                    double rectZ = imageBaseline * imageFocalX / (double)(imageDisp + imageMin);
                    double rectX = rectZ * ((double)rectPixX - imagePinhole.cx) / imagePinhole.fx;
                    double rectY = rectZ * ((double)rectPixY - imagePinhole.cy) / imagePinhole.fy;
                    double worldZ = this.dotRightCol(imageParam.rotateToRectified, rectX, rectY, rectZ);
                    float fusedDisp = (float)(this.fusedBaseline * this.fusedIntrinsic.fx / worldZ);
                    this.fused.get(origPixX, origPixY).add(fusedDisp);
                    continue;
                }
                this.fused.get(origPixX, origPixY).add(0.0f);
            }
        }
        return true;
    }

    double dotRightCol(DMatrixRMaj R, double x, double y, double z) {
        return R.data[2] * x + R.data[5] * y + R.data[8] * z;
    }

    void computeFused(GrayF32 disparity) {
        for (int y = 0; y < this.fused.height; ++y) {
            int indexOut = disparity.startIndex + y * disparity.stride;
            for (int x = 0; x < this.fused.width; ++x) {
                DogArray_F32 values = this.fused.get(x, y);
                float outputValue = values.size == 0 ? Float.MAX_VALUE : (values.size == 1 ? values.data[0] : (values.size == 2 ? 0.5f * (values.data[0] + values.data[1]) : QuickSelect.select((float[])values.data, (int)(values.size / 2), (int)values.size)));
                disparity.data[indexOut++] = outputValue;
            }
        }
    }

    void computeDynamicParameters(GrayF32 disparity) {
        float dispMax = 0.0f;
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + y * disparity.stride;
            for (int x = 0; x < disparity.width; ++x) {
                float d;
                if ((d = disparity.data[index++]) == Float.MAX_VALUE) continue;
                dispMax = Math.max(dispMax, d);
            }
        }
        float scale = (float)((double)(this.fusedDisparityRange - 1) / Math.ceil(dispMax));
        this.fusedBaseline *= (double)scale;
        float fRange = 100.0f;
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + y * disparity.stride;
            int x = 0;
            while (x < disparity.width) {
                float d = disparity.data[index];
                disparity.data[index] = d == Float.MAX_VALUE ? 100.0f : disparity.data[index] * scale;
                ++x;
                ++index;
            }
        }
    }

    public CameraPinhole getFusedIntrinsic() {
        return this.fusedIntrinsic;
    }

    public int getFusedDisparityMin() {
        return this.fusedDisparityMin;
    }

    public int getFusedDisparityRange() {
        return this.fusedDisparityRange;
    }

    public double getFusedBaseline() {
        return this.fusedBaseline;
    }

    public DogArray<DisparityImage> getImages() {
        return this.images;
    }

    public FusedImage getFused() {
        return this.fused;
    }

    static class FusedImage {
        public final DogArray<DogArray_F32> pixels = new DogArray(DogArray_F32::new, DogArray_F32::reset);
        public int width;
        public int height;

        FusedImage() {
        }

        public DogArray_F32 get(int x, int y) {
            return (DogArray_F32)this.pixels.get(y * this.width + x);
        }

        public void resize(int width, int height) {
            this.pixels.reset();
            this.pixels.resize(width * height);
            this.width = width;
            this.height = height;
        }
    }

    static class DisparityImage {
        public final GrayF32 disparity = new GrayF32(1, 1);
        public final GrayU8 mask = new GrayU8(1, 1);
        public final DMatrixRMaj undist_to_rect_px = new DMatrixRMaj(3, 3);
        public final DisparityParameters parameters = new DisparityParameters();

        DisparityImage() {
        }

        public void reset() {
            this.disparity.reshape(1, 1);
            this.mask.reshape(1, 1);
            CommonOps_DDRM.fill((DMatrixD1)this.undist_to_rect_px, (double)0.0);
            this.parameters.reset();
        }
    }
}

