/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.image.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.io.image.ConvertRaster;
import boofcv.io.image.impl.ImplConvertRaster;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;

public class ImplConvertRaster_MT {
    public static void bufferedToGray(DataBufferUShort buffer, WritableRaster src, GrayI16 dst) {
        short[] srcData = buffer.getData();
        int numBands = src.getNumBands();
        int size = dst.getWidth() * dst.getHeight();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int srcStrideDiff = srcStride - src.getNumDataElements() * dst.width;
        if (numBands == 1) {
            if (dst.startIndex == 0 && dst.width == dst.stride && srcStrideDiff == 0 && srcOffset == 0) {
                System.arraycopy(srcData, 0, dst.data, 0, size);
            } else {
                BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                    int indexDst = dst.startIndex + dst.stride * y;
                    int indexSrc = srcOffset + srcStride * y;
                    System.arraycopy(srcData, indexSrc, dst.data, indexDst, dst.width);
                });
            }
        } else {
            throw new RuntimeException("Only single band images are currently support for 16bit");
        }
    }

    public static void from_4BU8_to_U8(byte[] srcData, int srcStride, int srcOffset, GrayU8 dst) {
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                int n = ++indexSrc;
                int r = srcData[n] & 0xFF;
                int n2 = ++indexSrc;
                int g = srcData[n2] & 0xFF;
                int n3 = ++indexSrc;
                ++indexSrc;
                int b = srcData[n3] & 0xFF;
                int ave = (r + g + b) / 3;
                dst.data[indexDst] = (byte)ave;
            }
        });
    }

    public static void from_1BU8_to_U8(byte[] srcData, int size, int srcStride, int srcOffset, int srcStrideDiff, GrayU8 dst) {
        if (dst.startIndex == 0 && dst.width == dst.stride && srcStrideDiff == 0 && srcOffset == 0) {
            System.arraycopy(srcData, 0, dst.data, 0, size);
        } else {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexDst = dst.startIndex + dst.stride * y;
                int indexSrc = srcOffset + srcStride * y;
                System.arraycopy(srcData, indexSrc, dst.data, indexDst, dst.width);
            });
        }
    }

    public static void from_3BU8_to_U8(byte[] srcData, int srcStride, int srcOffset, GrayU8 dst) {
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + dst.stride * y;
            int indexDstEnd = indexDst + dst.width;
            while (indexDst < indexDstEnd) {
                int r = srcData[indexSrc++] & 0xFF;
                int g = srcData[indexSrc++] & 0xFF;
                int b = srcData[indexSrc++] & 0xFF;
                int ave = (r + g + b) / 3;
                dst.data[indexDst++] = (byte)ave;
            }
        });
    }

    public static void from_4BU8_to_F32(byte[] srcData, int srcStride, int srcOffset, GrayF32 dst) {
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + dst.stride * y;
            int indexDstEnd = indexDst + dst.width;
            while (indexDst < indexDstEnd) {
                int n = ++indexSrc;
                int r = srcData[n] & 0xFF;
                int n2 = ++indexSrc;
                int g = srcData[n2] & 0xFF;
                int n3 = ++indexSrc;
                ++indexSrc;
                int b = srcData[n3] & 0xFF;
                float ave = (float)(r + g + b) / 3.0f;
                dst.data[indexDst++] = ave;
            }
        });
    }

    public static void from_1BU8_to_F32(byte[] srcData, int srcStride, int srcOffset, GrayF32 dst) {
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst = dst.startIndex + dst.stride * y;
            int indexDstEnd = indexDst + dst.width;
            int indexSrc = srcOffset + srcStride * y;
            while (indexDst < indexDstEnd) {
                dst.data[indexDst++] = srcData[indexSrc++] & 0xFF;
            }
        });
    }

    public static void from_3BU8_to_F32(byte[] srcData, int srcStride, int srcOffset, GrayF32 dst) {
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + dst.stride * y;
            int indexDstEnd = indexDst + dst.width;
            while (indexDst < indexDstEnd) {
                int r = srcData[indexSrc++] & 0xFF;
                int g = srcData[indexSrc++] & 0xFF;
                int b = srcData[indexSrc++] & 0xFF;
                float ave = (float)(r + g + b) / 3.0f;
                dst.data[indexDst++] = ave;
            }
        });
    }

    public static void bufferedToInterleaved(DataBufferByte buffer, WritableRaster src, InterleavedF32 dst) {
        byte[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int length = dst.width * dst.numBands;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + dst.stride * y;
            int indexDstEnd = indexDst + length;
            while (indexDst < indexDstEnd) {
                dst.data[indexDst++] = srcData[indexSrc++] & 0xFF;
            }
        });
    }

    public static void bufferedToInterleaved(DataBufferByte buffer, WritableRaster src, InterleavedU8 dst) {
        byte[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int length = dst.width * dst.numBands;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst = dst.startIndex + y * dst.stride;
            int indexSrc = srcOffset + y * srcStride;
            System.arraycopy(srcData, indexSrc, dst.data, indexDst, length);
        });
    }

    public static void from_4BU8_to_PLF32(byte[] srcData, int srcStride, int srcOffset, Planar<GrayF32> dst) {
        float[] band1 = ((GrayF32)dst.getBand((int)0)).data;
        float[] band2 = ((GrayF32)dst.getBand((int)1)).data;
        float[] band3 = ((GrayF32)dst.getBand((int)2)).data;
        float[] band4 = ((GrayF32)dst.getBand((int)3)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                band1[indexDst] = srcData[indexSrc++] & 0xFF;
                band2[indexDst] = srcData[indexSrc++] & 0xFF;
                band3[indexDst] = srcData[indexSrc++] & 0xFF;
                band4[indexDst] = srcData[indexSrc++] & 0xFF;
            }
        });
    }

    public static void from_1BU8_to_PLF32(byte[] srcData, int srcStride, int srcOffset, Planar<GrayF32> dst) {
        float[] data = ((GrayF32)dst.getBand((int)0)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                data[indexDst] = srcData[indexSrc++] & 0xFF;
            }
        });
    }

    public static void from_3BU8_to_PLF32(byte[] srcData, int srcStride, int srcOffset, Planar<GrayF32> dst) {
        float[] band1 = ((GrayF32)dst.getBand((int)0)).data;
        float[] band2 = ((GrayF32)dst.getBand((int)1)).data;
        float[] band3 = ((GrayF32)dst.getBand((int)2)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                band1[indexDst] = srcData[indexSrc++] & 0xFF;
                band2[indexDst] = srcData[indexSrc++] & 0xFF;
                band3[indexDst] = srcData[indexSrc++] & 0xFF;
            }
        });
    }

    public static void from_4BU8_to_PLU8(byte[] srcData, int srcStride, int srcOffset, Planar<GrayU8> dst) {
        byte[] band1 = ((GrayU8)dst.getBand((int)0)).data;
        byte[] band2 = ((GrayU8)dst.getBand((int)1)).data;
        byte[] band3 = ((GrayU8)dst.getBand((int)2)).data;
        byte[] band4 = ((GrayU8)dst.getBand((int)3)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                band1[indexDst] = srcData[indexSrc++];
                band2[indexDst] = srcData[indexSrc++];
                band3[indexDst] = srcData[indexSrc++];
                band4[indexDst] = srcData[indexSrc++];
            }
        });
    }

    public static void from_1BU8_to_PLU8(byte[] srcData, int srcStride, int srcOffset, Planar<GrayU8> dst) {
        byte[] dstData = ((GrayU8)dst.getBand((int)0)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + dst.stride * y;
            System.arraycopy(srcData, indexSrc, dstData, indexDst, dst.width);
        });
    }

    public static void from_3BU8_to_PLU8(byte[] srcData, int srcStride, int srcOffset, Planar<GrayU8> dst) {
        byte[] band1 = ((GrayU8)dst.getBand((int)0)).data;
        byte[] band2 = ((GrayU8)dst.getBand((int)1)).data;
        byte[] band3 = ((GrayU8)dst.getBand((int)2)).data;
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexDst;
            int indexSrc = srcOffset + y * srcStride;
            int indexDstEnd = indexDst + dst.width;
            for (indexDst = dst.startIndex + dst.stride * y; indexDst < indexDstEnd; ++indexDst) {
                band1[indexDst] = srcData[indexSrc++];
                band2[indexDst] = srcData[indexSrc++];
                band3[indexDst] = srcData[indexSrc++];
            }
        });
    }

    public static void bufferedToGray(DataBufferInt buffer, WritableRaster src, GrayU8 dst) {
        int[] srcData = buffer.getData();
        byte[] data = dst.data;
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + y * dst.stride;
            for (int x = 0; x < dst.width; ++x) {
                int rgb = srcData[indexSrc++];
                int r = rgb >>> 16 & 0xFF;
                int g = rgb >>> 8 & 0xFF;
                int b = rgb & 0xFF;
                int ave = (r + g + b) / 3;
                data[indexDst++] = (byte)ave;
            }
        });
    }

    public static void bufferedToGray(DataBufferInt buffer, WritableRaster src, GrayF32 dst) {
        int[] srcData = buffer.getData();
        float[] data = dst.data;
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
            int indexSrc = srcOffset + y * srcStride;
            int indexDst = dst.startIndex + y * dst.stride;
            for (int x = 0; x < dst.width; ++x) {
                int rgb = srcData[indexSrc++];
                int r = rgb >>> 16 & 0xFF;
                int g = rgb >>> 8 & 0xFF;
                int b = rgb & 0xFF;
                float ave = (float)(r + g + b) / 3.0f;
                data[indexDst++] = ave;
            }
        });
    }

    public static void bufferedToPlanar_U8(DataBufferInt buffer, WritableRaster src, Planar<GrayU8> dst) {
        int[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int numBands = src.getNumBands();
        byte[] data1 = ((GrayU8)dst.getBand((int)0)).data;
        byte[] data2 = ((GrayU8)dst.getBand((int)1)).data;
        byte[] data3 = ((GrayU8)dst.getBand((int)2)).data;
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < dst.width) {
                    int rgb = srcData[indexSrc++];
                    data1[indexDst] = (byte)(rgb >>> 16);
                    data2[indexDst] = (byte)(rgb >>> 8);
                    data3[indexDst] = (byte)rgb;
                    ++x;
                    ++indexDst;
                }
            });
        } else if (numBands == 4) {
            byte[] data4 = ((GrayU8)dst.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < dst.width) {
                    int rgb = srcData[indexSrc++];
                    data1[indexDst] = (byte)(rgb >>> 24);
                    data2[indexDst] = (byte)(rgb >>> 16);
                    data3[indexDst] = (byte)(rgb >>> 8);
                    data4[indexDst] = (byte)rgb;
                    ++x;
                    ++indexDst;
                }
            });
        }
    }

    public static void bufferedToPlanar_F32(DataBufferInt buffer, WritableRaster src, Planar<GrayF32> dst) {
        int[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        float[] data1 = ((GrayF32)dst.getBand((int)0)).data;
        float[] data2 = ((GrayF32)dst.getBand((int)1)).data;
        float[] data3 = ((GrayF32)dst.getBand((int)2)).data;
        int numBands = src.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < dst.width) {
                    int rgb = srcData[indexSrc++];
                    data1[indexDst] = rgb >>> 16 & 0xFF;
                    data2[indexDst] = rgb >>> 8 & 0xFF;
                    data3[indexDst] = rgb & 0xFF;
                    ++x;
                    ++indexDst;
                }
            });
        } else if (numBands == 4) {
            float[] data4 = ((GrayF32)dst.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < dst.width) {
                    int rgb = srcData[indexSrc++];
                    data1[indexDst] = rgb >>> 24 & 0xFF;
                    data2[indexDst] = rgb >>> 16 & 0xFF;
                    data3[indexDst] = rgb >>> 8 & 0xFF;
                    data4[indexDst] = rgb & 0xFF;
                    ++x;
                    ++indexDst;
                }
            });
        }
    }

    public static void bufferedToInterleaved(DataBufferInt buffer, WritableRaster src, InterleavedU8 dst) {
        int[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int numBands = src.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < dst.width; ++x) {
                    int rgb = srcData[indexSrc++];
                    dst.data[indexDst++] = (byte)(rgb >>> 16);
                    dst.data[indexDst++] = (byte)(rgb >>> 8);
                    dst.data[indexDst++] = (byte)rgb;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < dst.width; ++x) {
                    int rgb = srcData[indexSrc++];
                    dst.data[indexDst++] = (byte)(rgb >>> 24);
                    dst.data[indexDst++] = (byte)(rgb >>> 16);
                    dst.data[indexDst++] = (byte)(rgb >>> 8);
                    dst.data[indexDst++] = (byte)rgb;
                }
            });
        }
    }

    public static void bufferedToInterleaved(DataBufferInt buffer, WritableRaster src, InterleavedF32 dst) {
        int[] srcData = buffer.getData();
        int srcStride = ConvertRaster.stride(src);
        int srcOffset = ConvertRaster.getOffset(src);
        int numBands = src.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < dst.width; ++x) {
                    int rgb = srcData[indexSrc++];
                    dst.data[indexDst++] = rgb >>> 16 & 0xFF;
                    dst.data[indexDst++] = rgb >>> 8 & 0xFF;
                    dst.data[indexDst++] = rgb & 0xFF;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)dst.height, y -> {
                int indexSrc = srcOffset + y * srcStride;
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < dst.width; ++x) {
                    int rgb = srcData[indexSrc++];
                    dst.data[indexDst++] = rgb >>> 24 & 0xFF;
                    dst.data[indexDst++] = rgb >>> 16 & 0xFF;
                    dst.data[indexDst++] = rgb >>> 8 & 0xFF;
                    dst.data[indexDst++] = rgb & 0xFF;
                }
            });
        }
    }

    public static void bufferedToGray(BufferedImage src, byte[] dstData, int dstStartIndex, int dstStride) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (src.getType() == 10) {
            WritableRaster raster = src.getRaster();
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int[] hack = new int[1];
                int index = dstStartIndex + y * dstStride;
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, hack);
                    dstData[index++] = (byte)hack[0];
                }
            });
        } else {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dstStartIndex + y * dstStride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    dstData[index++] = (byte)(((argb >>> 16 & 0xFF) + (argb >>> 8 & 0xFF) + (argb & 0xFF)) / 3);
                }
            });
        }
    }

    public static void bufferedToGray(BufferedImage src, GrayI16 dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] data = dst.data;
        if (src.getType() == 10 || src.getType() == 11) {
            WritableRaster raster = src.getRaster();
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int[] hack = new int[1];
                int index = dst.startIndex + y * dst.stride;
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, hack);
                    data[index++] = (short)hack[0];
                }
            });
        } else {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dst.startIndex + y * dst.stride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    data[index++] = (short)(((argb >>> 16 & 0xFF) + (argb >>> 8 & 0xFF) + (argb & 0xFF)) / 3);
                }
            });
        }
    }

    public static void bufferedToGray(BufferedImage src, float[] data, int dstStartIndex, int dstStride) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (src.getType() == 10) {
            WritableRaster raster = src.getRaster();
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int[] hack = new int[1];
                int index = dstStartIndex + y * dstStride;
                for (int x = 0; x < width; ++x) {
                    raster.getPixel(x, y, hack);
                    data[index++] = hack[0];
                }
            });
        } else {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dstStartIndex + y * dstStride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    int r = argb >>> 16 & 0xFF;
                    int g = argb >>> 8 & 0xFF;
                    int b = argb & 0xFF;
                    float ave = (float)(r + g + b) / 3.0f;
                    data[index++] = ave;
                }
            });
        }
    }

    public static void bufferedToPlanar_U8(BufferedImage src, Planar<GrayU8> dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst.getNumBands() == 3) {
            byte[] band1 = ((GrayU8)dst.getBand((int)0)).data;
            byte[] band2 = ((GrayU8)dst.getBand((int)1)).data;
            byte[] band3 = ((GrayU8)dst.getBand((int)2)).data;
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < width) {
                    int argb = src.getRGB(x, y);
                    band1[index] = (byte)(argb >>> 16);
                    band2[index] = (byte)(argb >>> 8);
                    band3[index] = (byte)argb;
                    ++x;
                    ++index;
                }
            });
        } else {
            ImplConvertRaster_MT.bufferedToGray(src, ((GrayU8)dst.getBand((int)0)).data, dst.startIndex, dst.stride);
            GrayU8 band1 = (GrayU8)dst.getBand(0);
            for (int i = 1; i < dst.getNumBands(); ++i) {
                ((GrayU8)dst.getBand(i)).setTo((ImageGray)band1);
            }
        }
    }

    public static void bufferedToPlanar_F32(BufferedImage src, Planar<GrayF32> dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst.getNumBands() == 3) {
            float[] band1 = ((GrayF32)dst.getBand((int)0)).data;
            float[] band2 = ((GrayF32)dst.getBand((int)1)).data;
            float[] band3 = ((GrayF32)dst.getBand((int)2)).data;
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < width) {
                    int argb = src.getRGB(x, y);
                    band1[index] = argb >>> 16 & 0xFF;
                    band2[index] = argb >>> 8 & 0xFF;
                    band3[index] = argb & 0xFF;
                    ++x;
                    ++index;
                }
            });
        } else if (dst.getNumBands() == 4) {
            float[] band1 = ((GrayF32)dst.getBand((int)0)).data;
            float[] band2 = ((GrayF32)dst.getBand((int)1)).data;
            float[] band3 = ((GrayF32)dst.getBand((int)2)).data;
            float[] band4 = ((GrayF32)dst.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = dst.startIndex + y * dst.stride;
                int x = 0;
                while (x < width) {
                    int argb = src.getRGB(x, y);
                    band1[index] = argb >>> 24 & 0xFF;
                    band2[index] = argb >>> 16 & 0xFF;
                    band3[index] = argb >>> 8 & 0xFF;
                    band4[index] = argb & 0xFF;
                    ++x;
                    ++index;
                }
            });
        } else if (dst.getNumBands() == 1) {
            ImplConvertRaster_MT.bufferedToGray(src, ((GrayF32)dst.getBand((int)0)).data, dst.startIndex, dst.stride);
        } else {
            throw new IllegalArgumentException("Unsupported number of input bands");
        }
    }

    public static void bufferedToInterleaved(BufferedImage src, InterleavedF32 dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst.getNumBands() == 3) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    dst.data[indexDst++] = argb >>> 16 & 0xFF;
                    dst.data[indexDst++] = argb >>> 8 & 0xFF;
                    dst.data[indexDst++] = argb & 0xFF;
                }
            });
        } else if (dst.getNumBands() == 4) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    dst.data[indexDst++] = argb >>> 24 & 0xFF;
                    dst.data[indexDst++] = argb >>> 16 & 0xFF;
                    dst.data[indexDst++] = argb >>> 8 & 0xFF;
                    dst.data[indexDst++] = argb & 0xFF;
                }
            });
        } else if (dst.getNumBands() == 1) {
            ImplConvertRaster_MT.bufferedToGray(src, dst.data, dst.startIndex, dst.stride);
        } else {
            throw new IllegalArgumentException("Unsupported number of input bands");
        }
    }

    public static void bufferedToInterleaved(BufferedImage src, InterleavedU8 dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst.getNumBands() == 3) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int indexDst = dst.startIndex + y * dst.stride;
                for (int x = 0; x < width; ++x) {
                    int argb = src.getRGB(x, y);
                    dst.data[indexDst++] = (byte)(argb >>> 16);
                    dst.data[indexDst++] = (byte)(argb >>> 8);
                    dst.data[indexDst++] = (byte)argb;
                }
            });
        } else if (dst.getNumBands() == 1) {
            ImplConvertRaster.bufferedToGray(src, dst.data, dst.startIndex, dst.stride);
        } else {
            throw new IllegalArgumentException("Unsupported number of input bands");
        }
    }

    public static void grayToBuffered(GrayU8 src, DataBufferByte buffer, WritableRaster dst) {
        byte[] srcData = src.data;
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        int size = src.getWidth() * src.getHeight();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = srcData[indexSrc];
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                }
            });
        } else if (numBands == 1) {
            if (src.startIndex == 0 && src.width == src.stride) {
                System.arraycopy(srcData, 0, dstData, 0, size);
            } else {
                BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                    int indexSrc = src.startIndex + src.stride * y;
                    int indexDst = src.width * y;
                    System.arraycopy(srcData, indexSrc, dstData, indexDst, src.width);
                });
            }
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = srcData[indexSrc];
                    int n = ++indexDst;
                    dstData[n] = val;
                    int n2 = ++indexDst;
                    dstData[n2] = val;
                    int n3 = ++indexDst;
                    ++indexDst;
                    dstData[n3] = val;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferByte buffer, WritableRaster dst) {
        short[] srcData = src.data;
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = (byte)srcData[indexSrc];
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                }
            });
        } else if (numBands == 1) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = (byte)srcData[indexSrc];
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = (byte)srcData[indexSrc];
                    int n = ++indexDst;
                    dstData[n] = val;
                    int n2 = ++indexDst;
                    dstData[n2] = val;
                    int n3 = ++indexDst;
                    ++indexDst;
                    dstData[n3] = val;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayF32 src, DataBufferByte buffer, WritableRaster dst) {
        float[] srcData = src.data;
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = (byte)srcData[indexSrc];
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                }
            });
        } else if (numBands == 1) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = (byte)srcData[indexSrc];
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    byte val = (byte)srcData[indexSrc];
                    int n = ++indexDst;
                    dstData[n] = val;
                    int n2 = ++indexDst;
                    dstData[n2] = val;
                    int n3 = ++indexDst;
                    ++indexDst;
                    dstData[n3] = val;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferUShort buffer, WritableRaster dst) {
        short[] srcData = src.data;
        short[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    short val = srcData[indexSrc];
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                    dstData[indexDst++] = val;
                }
            });
        } else if (numBands == 1) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = srcData[indexSrc];
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    short val = srcData[indexSrc];
                    int n = ++indexDst;
                    dstData[n] = val;
                    int n2 = ++indexDst;
                    dstData[n2] = val;
                    int n3 = ++indexDst;
                    ++indexDst;
                    dstData[n3] = val;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, DataBufferByte buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            byte[] band1 = ((GrayU8)src.getBand((int)0)).data;
            byte[] band2 = ((GrayU8)src.getBand((int)1)).data;
            byte[] band3 = ((GrayU8)src.getBand((int)2)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = band1[indexSrc];
                    dstData[indexDst++] = band2[indexSrc];
                    dstData[indexDst++] = band3[indexSrc];
                }
            });
        } else if (numBands == 4) {
            byte[] band1 = ((GrayU8)src.getBand((int)0)).data;
            byte[] band2 = ((GrayU8)src.getBand((int)1)).data;
            byte[] band3 = ((GrayU8)src.getBand((int)2)).data;
            byte[] band4 = ((GrayU8)src.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = band1[indexSrc];
                    dstData[indexDst++] = band2[indexSrc];
                    dstData[indexDst++] = band3[indexSrc];
                    dstData[indexDst++] = band4[indexSrc];
                }
            });
        } else {
            byte[][] bands = new byte[numBands][];
            for (int i = 0; i < numBands; ++i) {
                bands[i] = ((GrayU8)src.getBand((int)i)).data;
            }
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    for (int i = 0; i < numBands; ++i) {
                        dstData[indexDst++] = bands[i][indexSrc];
                    }
                }
            });
        }
    }

    public static void planarToBuffered_F32(Planar<GrayF32> src, DataBufferByte buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            float[] band1 = ((GrayF32)src.getBand((int)0)).data;
            float[] band2 = ((GrayF32)src.getBand((int)1)).data;
            float[] band3 = ((GrayF32)src.getBand((int)2)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = (byte)band1[indexSrc];
                    dstData[indexDst++] = (byte)band2[indexSrc];
                    dstData[indexDst++] = (byte)band3[indexSrc];
                }
            });
        } else if (numBands == 4) {
            float[] band1 = ((GrayF32)src.getBand((int)0)).data;
            float[] band2 = ((GrayF32)src.getBand((int)1)).data;
            float[] band3 = ((GrayF32)src.getBand((int)2)).data;
            float[] band4 = ((GrayF32)src.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    dstData[indexDst++] = (byte)band1[indexSrc];
                    dstData[indexDst++] = (byte)band2[indexSrc];
                    dstData[indexDst++] = (byte)band3[indexSrc];
                    dstData[indexDst++] = (byte)band4[indexSrc];
                }
            });
        } else {
            float[][] bands = new float[numBands][];
            for (int i = 0; i < numBands; ++i) {
                bands[i] = ((GrayF32)src.getBand((int)i)).data;
            }
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc;
                int indexSrcEnd = indexSrc + src.width;
                int indexDst = y * src.width * numBands;
                for (indexSrc = src.startIndex + src.stride * y; indexSrc < indexSrcEnd; ++indexSrc) {
                    for (int i = 0; i < numBands; ++i) {
                        dstData[indexDst++] = (byte)bands[i][indexSrc];
                    }
                }
            });
        }
    }

    public static void grayToBuffered(GrayU8 src, DataBufferInt buffer, WritableRaster dst) {
        byte[] srcData = src.data;
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    int v = srcData[indexSrc++] & 0xFF;
                    dstData[indexDst++] = v << 16 | v << 8 | v;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    int v = srcData[indexSrc++] & 0xFF;
                    dstData[indexDst++] = 0xFF000000 | v << 16 | v << 8 | v;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayI16 src, DataBufferInt buffer, WritableRaster dst) {
        short[] srcData = src.data;
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    short v = srcData[indexSrc++];
                    dstData[indexDst++] = v << 16 | v << 8 | v;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    short v = srcData[indexSrc++];
                    dstData[indexDst++] = 0xFF000000 | v << 16 | v << 8 | v;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayF32 src, DataBufferInt buffer, WritableRaster dst) {
        float[] srcData = src.data;
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    int v = (int)srcData[indexSrc++];
                    dstData[indexDst++] = v << 16 | v << 8 | v;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                for (int x = 0; x < src.width; ++x) {
                    int v = (int)srcData[indexSrc++];
                    dstData[indexDst++] = 0xFF000000 | v << 16 | v << 8 | v;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, DataBufferInt buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        byte[] band1 = ((GrayU8)src.getBand((int)0)).data;
        byte[] band2 = ((GrayU8)src.getBand((int)1)).data;
        byte[] band3 = ((GrayU8)src.getBand((int)2)).data;
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                int x = 0;
                while (x < src.width) {
                    int c1 = band1[indexSrc] & 0xFF;
                    int c2 = band2[indexSrc] & 0xFF;
                    int c3 = band3[indexSrc] & 0xFF;
                    dstData[indexDst++] = c1 << 16 | c2 << 8 | c3;
                    ++x;
                    ++indexSrc;
                }
            });
        } else if (numBands == 4) {
            byte[] band4 = ((GrayU8)src.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                int x = 0;
                while (x < src.width) {
                    int c1 = band1[indexSrc] & 0xFF;
                    int c2 = band2[indexSrc] & 0xFF;
                    int c3 = band3[indexSrc] & 0xFF;
                    int c4 = band4[indexSrc] & 0xFF;
                    dstData[indexDst++] = c1 << 24 | c2 << 16 | c3 << 8 | c4;
                    ++x;
                    ++indexSrc;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void planarToBuffered_F32(Planar<GrayF32> src, DataBufferInt buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        float[] band1 = ((GrayF32)src.getBand((int)0)).data;
        float[] band2 = ((GrayF32)src.getBand((int)1)).data;
        float[] band3 = ((GrayF32)src.getBand((int)2)).data;
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                int x = 0;
                while (x < src.width) {
                    int c1 = (int)band1[indexSrc];
                    int c2 = (int)band2[indexSrc];
                    int c3 = (int)band3[indexSrc];
                    dstData[indexDst++] = c1 << 16 | c2 << 8 | c3;
                    ++x;
                    ++indexSrc;
                }
            });
        } else if (numBands == 4) {
            float[] band4 = ((GrayF32)src.getBand((int)3)).data;
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = y * src.width;
                int x = 0;
                while (x < src.width) {
                    int c1 = (int)band1[indexSrc];
                    int c2 = (int)band2[indexSrc];
                    int c3 = (int)band3[indexSrc];
                    int c4 = (int)band4[indexSrc];
                    dstData[indexDst++] = c1 << 24 | c2 << 16 | c3 << 8 | c4;
                    ++x;
                    ++indexSrc;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void grayToBuffered(GrayU8 src, BufferedImage dst) {
        int width = dst.getWidth();
        int height = dst.getHeight();
        byte[] data = src.data;
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            for (int x = 0; x < width; ++x) {
                int v = data[indexSrc++] & 0xFF;
                int rgb = v << 16 | v << 8 | v;
                dst.setRGB(x, y, rgb);
            }
        });
    }

    public static void grayToBuffered(GrayI16 src, BufferedImage dst) {
        int width = dst.getWidth();
        int height = dst.getHeight();
        short[] data = src.data;
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            for (int x = 0; x < width; ++x) {
                short v = data[indexSrc++];
                int argb = v << 16 | v << 8 | v;
                dst.setRGB(x, y, argb);
            }
        });
    }

    public static void grayToBuffered(GrayF32 src, BufferedImage dst) {
        int width = dst.getWidth();
        int height = dst.getHeight();
        float[] data = src.data;
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            for (int x = 0; x < width; ++x) {
                int v = (int)data[indexSrc++];
                int argb = v << 16 | v << 8 | v;
                dst.setRGB(x, y, argb);
            }
        });
    }

    public static void planarToBuffered_U8(Planar<GrayU8> src, BufferedImage dst) {
        if (src.getNumBands() != 3) {
            throw new IllegalArgumentException("src must have three bands");
        }
        int width = dst.getWidth();
        int height = dst.getHeight();
        byte[] band1 = ((GrayU8)src.getBand((int)0)).data;
        byte[] band2 = ((GrayU8)src.getBand((int)1)).data;
        byte[] band3 = ((GrayU8)src.getBand((int)2)).data;
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            int x = 0;
            while (x < width) {
                int c1 = band1[indexSrc] & 0xFF;
                int c2 = band2[indexSrc] & 0xFF;
                int c3 = band3[indexSrc] & 0xFF;
                int argb = c1 << 16 | c2 << 8 | c3;
                dst.setRGB(x, y, argb);
                ++x;
                ++indexSrc;
            }
        });
    }

    public static void planarToBuffered_F32(Planar<GrayF32> src, BufferedImage dst) {
        if (src.getNumBands() != 3) {
            throw new IllegalArgumentException("src must have three bands");
        }
        int width = dst.getWidth();
        int height = dst.getHeight();
        float[] band1 = ((GrayF32)src.getBand((int)0)).data;
        float[] band2 = ((GrayF32)src.getBand((int)1)).data;
        float[] band3 = ((GrayF32)src.getBand((int)2)).data;
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            int x = 0;
            while (x < width) {
                int c1 = (int)band1[indexSrc];
                int c2 = (int)band2[indexSrc];
                int c3 = (int)band3[indexSrc];
                int argb = c1 << 16 | c2 << 8 | c3;
                dst.setRGB(x, y, argb);
                ++x;
                ++indexSrc;
            }
        });
    }

    public static void interleavedToBuffered(InterleavedU8 src, DataBufferInt buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        int dstStride = ConvertRaster.stride(dst);
        int dstOffset = ConvertRaster.getOffset(dst);
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = dstOffset + y * dstStride;
                for (int x = 0; x < src.width; ++x) {
                    int c1 = src.data[indexSrc++] & 0xFF;
                    int c2 = src.data[indexSrc++] & 0xFF;
                    int c3 = src.data[indexSrc++] & 0xFF;
                    dstData[indexDst++] = c1 << 16 | c2 << 8 | c3;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = dstOffset + y * dstStride;
                for (int x = 0; x < src.width; ++x) {
                    int c1 = src.data[indexSrc++] & 0xFF;
                    int c2 = src.data[indexSrc++] & 0xFF;
                    int c3 = src.data[indexSrc++] & 0xFF;
                    int c4 = src.data[indexSrc++] & 0xFF;
                    dstData[indexDst++] = c1 << 24 | c2 << 16 | c3 << 8 | c4;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void interleavedToBuffered(InterleavedU8 src, DataBufferByte buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        int length = src.width * numBands;
        int dstStride = ConvertRaster.stride(dst);
        int dstOffset = ConvertRaster.getOffset(dst);
        BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            int indexDst = dstOffset + dstStride * y;
            System.arraycopy(src.data, indexSrc, dstData, indexDst, length);
        });
    }

    public static void interleavedToBuffered(InterleavedU8 src, BufferedImage dst) {
        if (src.getNumBands() != 3) {
            throw new IllegalArgumentException("src must have three bands");
        }
        int width = dst.getWidth();
        int height = dst.getHeight();
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            for (int x = 0; x < width; ++x) {
                int c1 = src.data[indexSrc++] & 0xFF;
                int c2 = src.data[indexSrc++] & 0xFF;
                int c3 = src.data[indexSrc++] & 0xFF;
                int argb = c1 << 16 | c2 << 8 | c3;
                dst.setRGB(x, y, argb);
            }
        });
    }

    public static void interleavedToBuffered(InterleavedF32 src, DataBufferInt buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        int[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        int dstStride = ConvertRaster.stride(dst);
        int dstOffset = ConvertRaster.getOffset(dst);
        if (numBands == 3) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = dstOffset + y * dstStride;
                for (int x = 0; x < src.width; ++x) {
                    int c1 = (int)src.data[indexSrc++];
                    int c2 = (int)src.data[indexSrc++];
                    int c3 = (int)src.data[indexSrc++];
                    dstData[indexDst++] = c1 << 16 | c2 << 8 | c3;
                }
            });
        } else if (numBands == 4) {
            BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
                int indexSrc = src.startIndex + y * src.stride;
                int indexDst = dstOffset + y * dstStride;
                for (int x = 0; x < src.width; ++x) {
                    int c1 = (int)src.data[indexSrc++];
                    int c2 = (int)src.data[indexSrc++];
                    int c3 = (int)src.data[indexSrc++];
                    int c4 = (int)src.data[indexSrc++];
                    dstData[indexDst++] = c1 << 24 | c2 << 16 | c3 << 8 | c4;
                }
            });
        } else {
            throw new RuntimeException("Code more here");
        }
    }

    public static void interleavedToBuffered(InterleavedF32 src, DataBufferByte buffer, WritableRaster dst) {
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("Unequal number of bands src = " + src.getNumBands() + " dst = " + dst.getNumBands());
        }
        byte[] dstData = buffer.getData();
        int numBands = dst.getNumBands();
        int length = src.width * numBands;
        int dstStride = ConvertRaster.stride(dst);
        int dstOffset = ConvertRaster.getOffset(dst);
        BoofConcurrency.loopFor((int)0, (int)src.height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            int indexDst = dstOffset + dstStride * y;
            int indexSrcEnd = indexSrc + length;
            while (indexSrc < indexSrcEnd) {
                dstData[indexDst++] = (byte)src.data[indexSrc++];
            }
        });
    }

    public static void interleavedToBuffered(InterleavedF32 src, BufferedImage dst) {
        if (src.getNumBands() != 3) {
            throw new IllegalArgumentException("src must have three bands");
        }
        int width = dst.getWidth();
        int height = dst.getHeight();
        BoofConcurrency.loopFor((int)0, (int)height, y -> {
            int indexSrc = src.startIndex + src.stride * y;
            for (int x = 0; x < width; ++x) {
                int c1 = (int)src.data[indexSrc++];
                int c2 = (int)src.data[indexSrc++];
                int c3 = (int)src.data[indexSrc++];
                int argb = c1 << 16 | c2 << 8 | c3;
                dst.setRGB(x, y, argb);
            }
        });
    }

    public static void orderBandsIntoRGB(InterleavedU8 image, BufferedImage input) {
        boolean swap = ConvertRaster.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                        byte tmp = image.data[index + 2];
                        image.data[index + 2] = image.data[index];
                        image.data[index] = tmp;
                    }
                });
            } else if (image.getNumBands() == 4) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                            byte tmp = image.data[index];
                            image.data[index] = image.data[index + 1];
                            image.data[index + 1] = image.data[index + 2];
                            image.data[index + 2] = image.data[index + 3];
                            image.data[index + 3] = tmp;
                        }
                    });
                } else if (bufferedImageType == 6) {
                    BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                            byte tmp1 = image.data[index + 1];
                            byte tmp0 = image.data[index];
                            image.data[index] = image.data[index + 3];
                            image.data[index + 1] = image.data[index + 2];
                            image.data[index + 2] = tmp1;
                            image.data[index + 3] = tmp0;
                        }
                    });
                }
            }
        }
    }

    public static void orderBandsIntoRGB(InterleavedF32 image, BufferedImage input) {
        boolean swap = ConvertRaster.swapBandOrder(input);
        if (swap) {
            if (image.getNumBands() == 3) {
                BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                    int index;
                    int indexEnd = index + image.width * 3;
                    for (index = image.startIndex + y * image.stride; index < indexEnd; index += 3) {
                        float tmp = image.data[index + 2];
                        image.data[index + 2] = image.data[index];
                        image.data[index] = tmp;
                    }
                });
            } else if (image.getNumBands() == 4) {
                int bufferedImageType = input.getType();
                if (bufferedImageType == 2) {
                    BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                            float tmp = image.data[index];
                            image.data[index] = image.data[index + 1];
                            image.data[index + 1] = image.data[index + 2];
                            image.data[index + 2] = image.data[index + 3];
                            image.data[index + 3] = tmp;
                        }
                    });
                } else if (bufferedImageType == 6) {
                    BoofConcurrency.loopFor((int)0, (int)image.height, y -> {
                        int index;
                        int indexEnd = index + image.width * 3;
                        for (index = image.startIndex + y * image.stride; index < indexEnd; index += 4) {
                            float tmp1 = image.data[index + 1];
                            float tmp0 = image.data[index];
                            image.data[index] = image.data[index + 3];
                            image.data[index + 1] = image.data[index + 2];
                            image.data[index + 2] = tmp1;
                            image.data[index + 3] = tmp0;
                        }
                    });
                }
            }
        }
    }

    public static void orderBandsBufferedFromRGB(DataBufferByte buffer, WritableRaster raster, int type) {
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = ConvertRaster.stride(raster);
        int offset = ConvertRaster.getOffset(raster);
        byte[] data = buffer.getData();
        if (5 == type) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp = data[index];
                    data[index] = data[index + 2];
                    data[index + 2] = tmp;
                    index += 3;
                }
            });
        } else if (6 == type) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = offset + y * stride;
                for (int x = 0; x < width; ++x) {
                    byte tmp0 = data[index];
                    byte tmp1 = data[index + 1];
                    data[index] = data[index + 3];
                    data[index + 1] = data[index + 2];
                    data[index + 2] = tmp1;
                    data[index + 3] = tmp0;
                    index += 4;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }

    public static void orderBandsBufferedFromRGB(DataBufferInt buffer, WritableRaster raster, int type) {
        if (1 == type) {
            return;
        }
        int height = raster.getHeight();
        int width = raster.getWidth();
        int stride = ConvertRaster.stride(raster);
        int offset = ConvertRaster.getOffset(raster);
        int[] data = buffer.getData();
        if (4 == type) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    data[index] = c1 << 16 | c2 << 8 | c3;
                    ++x;
                    ++index;
                }
            });
        } else if (2 == type) {
            BoofConcurrency.loopFor((int)0, (int)height, y -> {
                int index = offset + y * stride;
                int x = 0;
                while (x < width) {
                    int tmp = data[index];
                    int c1 = tmp & 0xFF;
                    int c2 = tmp >> 8 & 0xFF;
                    int c3 = tmp >> 16 & 0xFF;
                    int c4 = tmp >> 24 & 0xFF;
                    data[index] = c1 << 24 | c4 << 16 | c3 << 8 | c2;
                    ++x;
                    ++index;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported buffered image type");
        }
    }
}

