/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.calib;

import boofcv.struct.calib.CameraPinholeBrown;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.Serializable;
import org.ejml.data.DMatrixRMaj;

public class StereoParameters
implements Serializable {
    public static final long serialVersionUID = 1L;
    public CameraPinholeBrown left;
    public CameraPinholeBrown right;
    public Se3_F64 right_to_left;

    public StereoParameters(StereoParameters param) {
        this(param.left, param.right, param.getRightToLeft());
    }

    public StereoParameters(CameraPinholeBrown left, CameraPinholeBrown right, Se3_F64 right_to_left) {
        this.left = new CameraPinholeBrown(left);
        this.right_to_left = right_to_left.copy();
        this.right = new CameraPinholeBrown(right);
    }

    public StereoParameters() {
    }

    public Se3_F64 getRightToLeft() {
        return this.right_to_left;
    }

    public void setRightToLeft(Se3_F64 right_to_left) {
        this.right_to_left = right_to_left;
    }

    public double getBaseline() {
        return this.right_to_left.getT().norm();
    }

    public boolean isRectified(double tol) {
        double angle;
        return !this.left.isDistorted() && !this.right.isDistorted() && Math.abs(angle = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)this.right_to_left.R, null).theta) < tol;
    }

    public void setTo(StereoParameters src) {
        if (this.left == null) {
            this.left = new CameraPinholeBrown(src.left);
        } else {
            this.left.setTo(src.left);
        }
        if (this.right == null) {
            this.right = new CameraPinholeBrown(src.right);
        } else {
            this.right.setTo(src.right);
        }
        if (this.right_to_left == null) {
            this.right_to_left = src.right_to_left.copy();
        } else {
            this.right_to_left.setTo(src.right_to_left);
        }
    }

    public void print() {
        double[] euler = ConvertRotation3D_F64.matrixToEuler((DMatrixRMaj)this.right_to_left.getR(), (EulerType)EulerType.XYZ, (double[])null);
        Vector3D_F64 t = this.right_to_left.getT();
        System.out.println();
        System.out.println("Left Camera");
        this.left.print();
        System.out.println();
        System.out.println("Right Camera");
        this.right.print();
        System.out.println("Right to Left");
        System.out.printf("  Euler XYZ   [ %8.3f , %8.3f , %8.3f ]\n", euler[0], euler[1], euler[2]);
        System.out.printf("  Translation [ %8.3f , %8.3f , %8.3f ]\n", t.x, t.y, t.z);
    }

    public CameraPinholeBrown getLeft() {
        return this.left;
    }

    public CameraPinholeBrown getRight() {
        return this.right;
    }

    public void setLeft(CameraPinholeBrown left) {
        this.left = left;
    }

    public void setRight(CameraPinholeBrown right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StereoParameters)) {
            return false;
        }
        StereoParameters other = (StereoParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CameraPinholeBrown this$left = this.getLeft();
        CameraPinholeBrown other$left = other.getLeft();
        if (this$left == null ? other$left != null : !((Object)this$left).equals(other$left)) {
            return false;
        }
        CameraPinholeBrown this$right = this.getRight();
        CameraPinholeBrown other$right = other.getRight();
        if (this$right == null ? other$right != null : !((Object)this$right).equals(other$right)) {
            return false;
        }
        Se3_F64 this$right_to_left = this.right_to_left;
        Se3_F64 other$right_to_left = other.right_to_left;
        return !(this$right_to_left == null ? other$right_to_left != null : !this$right_to_left.equals(other$right_to_left));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StereoParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CameraPinholeBrown $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : ((Object)$left).hashCode());
        CameraPinholeBrown $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : ((Object)$right).hashCode());
        Se3_F64 $right_to_left = this.right_to_left;
        result = result * 59 + ($right_to_left == null ? 43 : $right_to_left.hashCode());
        return result;
    }

    public String toString() {
        return "StereoParameters(left=" + this.getLeft() + ", right=" + this.getRight() + ", right_to_left=" + this.right_to_left + ")";
    }
}

