/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.triangulate;

import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilTrig_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class ResidualsTriangulateEpipolarSampson
implements FunctionNtoM {
    private List<Point2D_F64> observations;
    private List<DMatrixRMaj> essential;
    private final Point3D_F64 point = new Point3D_F64();
    private final Point3D_F64 left = new Point3D_F64();
    private final Point3D_F64 right = new Point3D_F64();

    public void setObservations(List<Point2D_F64> observations, List<DMatrixRMaj> essential) {
        this.observations = observations;
        this.essential = essential;
    }

    public int getNumOfInputsN() {
        return 3;
    }

    public int getNumOfOutputsM() {
        return this.observations.size() * 4;
    }

    public void process(double[] input, double[] output) {
        this.point.x = input[0];
        this.point.y = input[1];
        this.point.z = input[2];
        int index = 0;
        for (int i = 0; i < this.observations.size(); ++i) {
            Point2D_F64 p = this.observations.get(i);
            DMatrixRMaj F = this.essential.get(i);
            GeometryMath_F64.multTran((DMatrixRMaj)F, (GeoTuple2D_F64)p, (GeoTuple3D_F64)this.left);
            GeometryMath_F64.mult((DMatrixRMaj)F, (GeoTuple3D_F64)this.point, (GeoTuple3D_F64)this.right);
            double j1 = this.left.x;
            double j2 = this.left.y;
            double j3 = this.right.x;
            double j4 = this.right.y;
            double JJ = j1 * j1 + j2 * j2 + j3 * j3 + j4 * j4;
            double epipolarError = UtilTrig_F64.dot((GeoTuple3D_F64)this.left, (GeoTuple3D_F64)this.point);
            if (JJ == 0.0) {
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                output[index++] = 0.0;
                continue;
            }
            double b = epipolarError / JJ;
            output[index++] = j1 * b;
            output[index++] = j2 * b;
            output[index++] = j3 * b;
            output[index++] = j4 * b;
        }
    }
}

