/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTuple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class ResolveSignAmbiguityPositiveDepth {
    public TriangulateNViewsMetric triangulateN = FactoryMultiView.triangulateNViewMetric(null);
    public boolean signChanged;
    public int bestInvalid;
    Point3D_F64 pointIn1 = new Point3D_F64();
    Point3D_F64 Xcam = new Point3D_F64();
    DogArray<PinholePtoN_F64> normalizers = new DogArray(PinholePtoN_F64::new);
    DogArray<Point2D_F64> pixelNorms = new DogArray(Point2D_F64::new);
    DogArray<Se3_F64> worldToViews = new DogArray(Se3_F64::new);

    public void process(List<AssociatedTuple> observations, MetricCameras views) {
        int viewIdx;
        BoofMiscOps.checkTrue((views.intrinsics.size == views.motion_1_to_k.size + 1 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((observations.size() > 0 ? 1 : 0) != 0);
        int numViews = views.intrinsics.size;
        int numObs = observations.size();
        this.normalizers.resize(numViews);
        this.pixelNorms.resize(numViews);
        this.worldToViews.resize(numViews);
        for (viewIdx = 0; viewIdx < numViews; ++viewIdx) {
            ((PinholePtoN_F64)this.normalizers.get(viewIdx)).setK((CameraPinhole)views.intrinsics.get(viewIdx));
        }
        for (viewIdx = 1; viewIdx < numViews; ++viewIdx) {
            ((Se3_F64)this.worldToViews.get(viewIdx)).setTo((Se3_F64)views.motion_1_to_k.get(viewIdx - 1));
        }
        this.signChanged = false;
        int best = -1;
        this.bestInvalid = Integer.MAX_VALUE;
        for (int trial = 0; trial < 4; ++trial) {
            int foundInvalid = 0;
            for (int obsIdx = 0; obsIdx < numObs; ++obsIdx) {
                int viewIdx2;
                for (viewIdx2 = 0; viewIdx2 < numViews; ++viewIdx2) {
                    Point2D_F64 pixel = observations.get(obsIdx).get(viewIdx2);
                    ((PinholePtoN_F64)this.normalizers.get(viewIdx2)).compute(pixel.x, pixel.y, (Point2D_F64)this.pixelNorms.get(viewIdx2));
                }
                this.triangulateN.triangulate(this.pixelNorms.toList(), this.worldToViews.toList(), this.pointIn1);
                if (this.pointIn1.z < 0.0) {
                    ++foundInvalid;
                }
                for (viewIdx2 = 1; viewIdx2 < numViews; ++viewIdx2) {
                    SePointOps_F64.transform((Se3_F64)((Se3_F64)this.worldToViews.get(viewIdx2)), (Point3D_F64)this.pointIn1, (Point3D_F64)this.Xcam);
                    if (!(this.Xcam.z < 0.0)) continue;
                    ++foundInvalid;
                }
            }
            for (int i = 1; i < this.worldToViews.size(); ++i) {
                ((Se3_F64)this.worldToViews.get((int)i)).T.scale(-1.0);
            }
            if (this.bestInvalid <= foundInvalid) continue;
            this.bestInvalid = foundInvalid;
            best = trial;
        }
        if (best == 1) {
            this.signChanged = true;
            for (int viewIdx3 = 0; viewIdx3 < views.motion_1_to_k.size; ++viewIdx3) {
                ((Se3_F64)views.motion_1_to_k.get((int)viewIdx3)).T.scale(-1.0);
            }
        }
    }

    public void process(List<AssociatedTriple> observations, MetricCameraTriple result) {
        this.signChanged = false;
        int best = -1;
        this.bestInvalid = Integer.MAX_VALUE;
        this.normalizers.resize(3);
        this.pixelNorms.resize(3);
        this.worldToViews.resize(3);
        PinholePtoN_F64 normalize1 = (PinholePtoN_F64)this.normalizers.get(0);
        PinholePtoN_F64 normalize2 = (PinholePtoN_F64)this.normalizers.get(1);
        PinholePtoN_F64 normalize3 = (PinholePtoN_F64)this.normalizers.get(2);
        Point2D_F64 n1 = (Point2D_F64)this.pixelNorms.get(0);
        Point2D_F64 n2 = (Point2D_F64)this.pixelNorms.get(1);
        Point2D_F64 n3 = (Point2D_F64)this.pixelNorms.get(2);
        ((Se3_F64)this.worldToViews.get(1)).setTo(result.view_1_to_2);
        ((Se3_F64)this.worldToViews.get(2)).setTo(result.view_1_to_3);
        normalize1.setK(result.view1);
        normalize2.setK(result.view2);
        normalize3.setK(result.view3);
        for (int trial = 0; trial < 2; ++trial) {
            int i;
            int foundInvalid = 0;
            for (i = 0; i < observations.size(); ++i) {
                AssociatedTriple ap = observations.get(i);
                normalize1.compute(ap.p1.x, ap.p1.y, n1);
                normalize2.compute(ap.p2.x, ap.p2.y, n2);
                normalize2.compute(ap.p3.x, ap.p3.y, n3);
                this.triangulateN.triangulate(this.pixelNorms.toList(), this.worldToViews.toList(), this.pointIn1);
                if (this.pointIn1.z < 0.0) {
                    ++foundInvalid;
                }
                SePointOps_F64.transform((Se3_F64)result.view_1_to_2, (Point3D_F64)this.pointIn1, (Point3D_F64)this.Xcam);
                if (this.Xcam.z < 0.0) {
                    ++foundInvalid;
                }
                SePointOps_F64.transform((Se3_F64)result.view_1_to_3, (Point3D_F64)this.pointIn1, (Point3D_F64)this.Xcam);
                if (!(this.Xcam.z < 0.0)) continue;
                ++foundInvalid;
            }
            for (i = 1; i < this.worldToViews.size(); ++i) {
                ((Se3_F64)this.worldToViews.get((int)i)).T.scale(-1.0);
            }
            if (this.bestInvalid <= foundInvalid) continue;
            this.bestInvalid = foundInvalid;
            best = trial;
        }
        if (best == 1) {
            result.view_1_to_2.T.scale(-1.0);
            result.view_1_to_3.T.scale(-1.0);
        }
    }
}

