/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.struct.geo.AssociatedPair;
import georegression.fitting.affine.MotionAffinePoint2D_F64;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;

public class GenerateAffine2D
implements ModelGenerator<Affine2D_F64, AssociatedPair>,
ModelFitter<Affine2D_F64, AssociatedPair> {
    MotionAffinePoint2D_F64 fitter = new MotionAffinePoint2D_F64();
    List<Point2D_F64> from = new ArrayList<Point2D_F64>();
    List<Point2D_F64> to = new ArrayList<Point2D_F64>();

    public boolean fitModel(List<AssociatedPair> dataSet, Affine2D_F64 initial, Affine2D_F64 found) {
        this.from.clear();
        this.to.clear();
        for (int i = 0; i < dataSet.size(); ++i) {
            AssociatedPair p = dataSet.get(i);
            this.from.add(p.p1);
            this.to.add(p.p2);
        }
        if (!this.fitter.process(this.from, this.to)) {
            return false;
        }
        found.setTo(this.fitter.getTransformSrcToDst());
        return true;
    }

    public boolean generate(List<AssociatedPair> dataSet, Affine2D_F64 model) {
        this.from.clear();
        this.to.clear();
        for (int i = 0; i < dataSet.size(); ++i) {
            AssociatedPair p = dataSet.get(i);
            this.from.add(p.p1);
            this.to.add(p.p2);
        }
        if (!this.fitter.process(this.from, this.to)) {
            return false;
        }
        model.setTo(this.fitter.getTransformSrcToDst());
        return true;
    }

    public int getMinimumPoints() {
        return this.fitter.getMinimumPoints();
    }

    public double getFitScore() {
        return 0.0;
    }
}

