/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.triangulate.TriangulateRefineProjectiveLS;
import boofcv.alg.geo.trifocal.TrifocalExtractGeometries;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple4D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class DistanceTrifocalReprojectionSq
implements DistanceFromModel<TrifocalTensor, AssociatedTriple> {
    DMatrixRMaj P1 = CommonOps_DDRM.identity((int)3, (int)4);
    DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    List<DMatrixRMaj> cameraMatrices = new ArrayList<DMatrixRMaj>();
    List<Point2D_F64> observations = new ArrayList<Point2D_F64>();
    TrifocalExtractGeometries extractor = new TrifocalExtractGeometries();
    TriangulateNViewsProjective triangulator = FactoryMultiView.triangulateNViewProj(ConfigTriangulation.DLT());
    TriangulateRefineProjectiveLS refiner;
    Point4D_F64 X = new Point4D_F64();
    Point2D_F64 pixel = new Point2D_F64();

    public DistanceTrifocalReprojectionSq(double gtol, int maxIterations) {
        this();
        this.refiner = new TriangulateRefineProjectiveLS(gtol, maxIterations);
    }

    public DistanceTrifocalReprojectionSq() {
        this.cameraMatrices.add(this.P1);
        this.cameraMatrices.add(this.P2);
        this.cameraMatrices.add(this.P3);
        this.observations.add(null);
        this.observations.add(null);
        this.observations.add(null);
    }

    public void setModel(TrifocalTensor trifocalTensor) {
        this.extractor.setTensor(trifocalTensor);
        this.extractor.extractCamera(this.P2, this.P3);
    }

    public double distance(AssociatedTriple pt) {
        this.observations.set(0, pt.p1);
        this.observations.set(1, pt.p2);
        this.observations.set(2, pt.p3);
        if (!this.triangulator.triangulate(this.observations, this.cameraMatrices, this.X)) {
            return 1.0E200;
        }
        if (this.refiner != null) {
            this.refiner.process(this.observations, this.cameraMatrices, this.X, this.X);
        }
        double error = 0.0;
        GeometryMath_F64.mult((DMatrixRMaj)this.P1, (GeoTuple4D_F64)this.X, (GeoTuple2D_F64)this.pixel);
        error += this.pixel.distance2((GeoTuple2D_F64)pt.p1);
        GeometryMath_F64.mult((DMatrixRMaj)this.P2, (GeoTuple4D_F64)this.X, (GeoTuple2D_F64)this.pixel);
        error += this.pixel.distance2((GeoTuple2D_F64)pt.p2);
        GeometryMath_F64.mult((DMatrixRMaj)this.P3, (GeoTuple4D_F64)this.X, (GeoTuple2D_F64)this.pixel);
        return error += this.pixel.distance2((GeoTuple2D_F64)pt.p3);
    }

    public void distances(List<AssociatedTriple> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.distance(observations.get(i));
        }
    }

    public Class<AssociatedTriple> getPointType() {
        return AssociatedTriple.class;
    }

    public Class<TrifocalTensor> getModelType() {
        return TrifocalTensor.class;
    }
}

