/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix2x2;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF2;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.ops.DConvertMatrixStruct;

public class PnPInfinitesimalPlanePoseEstimation {
    Estimate1ofEpipolar estimateHomography;
    Point2D_F64 center = new Point2D_F64();
    Vector3D_F64 center3 = new Vector3D_F64();
    DMatrixRMaj H = new DMatrixRMaj(3, 3);
    Se3_F64 pose0 = new Se3_F64();
    Se3_F64 pose1 = new Se3_F64();
    double error0;
    double error1;
    DMatrix2x2 J = new DMatrix2x2();
    double v1;
    double v2;
    private final DMatrixRMaj K_x = new DMatrixRMaj(3, 3);
    DMatrixRMaj R_v = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj tmp = new DMatrixRMaj(3, 3);
    private final DMatrix2x2 A = new DMatrix2x2();
    private final DMatrix2x2 AA = new DMatrix2x2();
    private final DMatrix2x2 B = new DMatrix2x2();
    private final DMatrix2x2 R22 = new DMatrix2x2();
    private final Vector3D_F64 l0 = new Vector3D_F64();
    private final Vector3D_F64 l1 = new Vector3D_F64();
    private final Vector3D_F64 ca = new Vector3D_F64();
    private final DMatrixRMaj W = new DMatrixRMaj(1, 3);
    private final DMatrixRMaj WW = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj y = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj Wty = new DMatrixRMaj(1, 1);
    DogArray<AssociatedPair> pointsAdj = new DogArray(AssociatedPair::new);
    Point3D_F64 tmpP = new Point3D_F64();

    public PnPInfinitesimalPlanePoseEstimation(Estimate1ofEpipolar estimateHomography) {
        this.estimateHomography = estimateHomography;
    }

    public PnPInfinitesimalPlanePoseEstimation() {
        this(FactoryMultiView.homographyTLS());
    }

    public boolean process(List<AssociatedPair> points) {
        if (points.size() < this.estimateHomography.getMinimumPoints()) {
            throw new IllegalArgumentException("At least " + this.estimateHomography.getMinimumPoints() + " must be provided");
        }
        this.zeroMeanWorldPoints(points);
        points = this.pointsAdj.toList();
        if (!this.estimateHomography.process(points, this.H)) {
            return false;
        }
        CommonOps_DDRM.divide((DMatrixD1)this.H, (double)this.H.get(2, 2));
        this.J.a11 = this.H.unsafe_get(0, 0) - this.H.unsafe_get(2, 0) * this.H.unsafe_get(0, 2);
        this.J.a12 = this.H.unsafe_get(0, 1) - this.H.unsafe_get(2, 1) * this.H.unsafe_get(0, 2);
        this.J.a21 = this.H.unsafe_get(1, 0) - this.H.unsafe_get(2, 0) * this.H.unsafe_get(1, 2);
        this.J.a22 = this.H.unsafe_get(1, 1) - this.H.unsafe_get(2, 1) * this.H.unsafe_get(1, 2);
        this.v1 = this.H.unsafe_get(0, 2);
        this.v2 = this.H.unsafe_get(1, 2);
        this.IPPE(this.pose0.R, this.pose1.R);
        this.estimateTranslation(this.pose0.R, points, this.pose0.T);
        this.estimateTranslation(this.pose1.R, points, this.pose1.T);
        this.error0 = this.computeError(points, this.pose0);
        this.error1 = this.computeError(points, this.pose1);
        if (this.error0 > this.error1) {
            double e = this.error0;
            this.error0 = this.error1;
            this.error1 = e;
            Se3_F64 s = this.pose0;
            this.pose0 = this.pose1;
            this.pose1 = s;
        }
        this.center3.setTo(-this.center.x, -this.center.y, 0.0);
        GeometryMath_F64.addMult((GeoTuple3D_F64)this.pose0.T, (DMatrixRMaj)this.pose0.R, (GeoTuple3D_F64)this.center3, (GeoTuple3D_F64)this.pose0.T);
        GeometryMath_F64.addMult((GeoTuple3D_F64)this.pose1.T, (DMatrixRMaj)this.pose1.R, (GeoTuple3D_F64)this.center3, (GeoTuple3D_F64)this.pose1.T);
        return true;
    }

    double computeError(List<AssociatedPair> points, Se3_F64 worldToCamera) {
        double error = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            AssociatedPair pair = points.get(i);
            this.tmpP.setTo(pair.p1.x, pair.p1.y, 0.0);
            SePointOps_F64.transform((Se3_F64)worldToCamera, (Point3D_F64)this.tmpP, (Point3D_F64)this.tmpP);
            error += pair.p2.distance2(this.tmpP.x / this.tmpP.z, this.tmpP.y / this.tmpP.z);
        }
        return Math.sqrt(error / (double)points.size());
    }

    private void zeroMeanWorldPoints(List<AssociatedPair> points) {
        int i;
        this.center.setTo(0.0, 0.0);
        this.pointsAdj.reset();
        for (i = 0; i < points.size(); ++i) {
            AssociatedPair pair = points.get(i);
            Point2D_F64 p = pair.p1;
            ((AssociatedPair)this.pointsAdj.grow()).p2.setTo(pair.p2);
            this.center.x += p.x;
            this.center.y += p.y;
        }
        this.center.x /= (double)points.size();
        this.center.y /= (double)points.size();
        for (i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get((int)i).p1;
            ((AssociatedPair)this.pointsAdj.get((int)i)).p1.setTo(p.x - this.center.x, p.y - this.center.y);
        }
    }

    void estimateTranslation(DMatrixRMaj R, List<AssociatedPair> points, Vector3D_F64 T) {
        int N = points.size();
        this.W.reshape(N * 2, 3);
        this.y.reshape(N * 2, 1);
        this.Wty.reshape(3, 1);
        DMatrix3x3 Rtmp = new DMatrix3x3();
        DConvertMatrixStruct.convert((DMatrixRMaj)R, (DMatrix3x3)Rtmp);
        int indexY = 0;
        int indexW = 0;
        for (int i = 0; i < N; ++i) {
            AssociatedPair p = points.get(i);
            double u1 = Rtmp.a11 * p.p1.x + Rtmp.a12 * p.p1.y;
            double u2 = Rtmp.a21 * p.p1.x + Rtmp.a22 * p.p1.y;
            double u3 = Rtmp.a31 * p.p1.x + Rtmp.a32 * p.p1.y;
            this.W.data[indexW++] = 1.0;
            this.W.data[indexW++] = 0.0;
            this.W.data[indexW++] = -p.p2.x;
            this.W.data[indexW++] = 0.0;
            this.W.data[indexW++] = 1.0;
            this.W.data[indexW++] = -p.p2.y;
            this.y.data[indexY++] = p.p2.x * u3 - u1;
            this.y.data[indexY++] = p.p2.y * u3 - u2;
        }
        CommonOps_DDRM.multTransA((DMatrix1Row)this.W, (DMatrix1Row)this.W, (DMatrix1Row)this.WW);
        CommonOps_DDRM.invert((DMatrixRMaj)this.WW);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.W, (DMatrix1Row)this.y, (DMatrix1Row)this.Wty);
        this.W.reshape(3, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.WW, (DMatrix1Row)this.Wty, (DMatrix1Row)this.W);
        T.x = this.W.data[0];
        T.y = this.W.data[1];
        T.z = this.W.data[2];
    }

    protected void IPPE(DMatrixRMaj R1, DMatrixRMaj R2) {
        double norm_v = Math.sqrt(this.v1 * this.v1 + this.v2 * this.v2);
        if (norm_v <= UtilEjml.EPS) {
            CommonOps_DDRM.setIdentity((DMatrix1Row)this.R_v);
        } else {
            this.compute_Rv();
        }
        PnPInfinitesimalPlanePoseEstimation.compute_B(this.B, this.R_v, this.v1, this.v2);
        CommonOps_DDF2.invert((DMatrix2x2)this.B, (DMatrix2x2)this.B);
        CommonOps_DDF2.mult((DMatrix2x2)this.B, (DMatrix2x2)this.J, (DMatrix2x2)this.A);
        double gamma = this.largestSingularValue2x2(this.A);
        CommonOps_DDF2.scale((double)(1.0 / gamma), (DMatrix2x2)this.A, (DMatrix2x2)this.R22);
        CommonOps_DDF2.setIdentity((DMatrix2x2)this.B);
        CommonOps_DDF2.multAddTransA((double)-1.0, (DMatrix2x2)this.R22, (DMatrix2x2)this.R22, (DMatrix2x2)this.B);
        double b1 = Math.sqrt(this.B.a11);
        double b2 = Math.signum(this.B.a12) * Math.sqrt(this.B.a22);
        this.l0.setTo(this.R22.a11, this.R22.a21, b1);
        this.l1.setTo(this.R22.a12, this.R22.a22, b2);
        this.ca.cross(this.l0, this.l1);
        PnPInfinitesimalPlanePoseEstimation.constructR(R1, this.R_v, this.R22, b1, b2, this.ca, 1.0, this.tmp);
        PnPInfinitesimalPlanePoseEstimation.constructR(R2, this.R_v, this.R22, b1, b2, this.ca, -1.0, this.tmp);
    }

    static void constructR(DMatrixRMaj R, DMatrixRMaj R_v, DMatrix2x2 R22, double b1, double b2, Vector3D_F64 ca, double sign, DMatrixRMaj tmp) {
        tmp.data[0] = R22.a11;
        tmp.data[1] = R22.a12;
        tmp.data[2] = sign * ca.x;
        tmp.data[3] = R22.a21;
        tmp.data[4] = R22.a22;
        tmp.data[5] = sign * ca.y;
        tmp.data[6] = sign * b1;
        tmp.data[7] = sign * b2;
        tmp.data[8] = ca.z;
        CommonOps_DDRM.mult((DMatrix1Row)R_v, (DMatrix1Row)tmp, (DMatrix1Row)R);
    }

    static void compute_B(DMatrix2x2 B, DMatrixRMaj R_v, double v1, double v2) {
        B.a11 = R_v.data[0] + R_v.data[6] * -v1;
        B.a12 = R_v.data[1] + R_v.data[7] * -v1;
        B.a21 = R_v.data[3] + R_v.data[6] * -v2;
        B.a22 = R_v.data[4] + R_v.data[7] * -v2;
    }

    double largestSingularValue2x2(DMatrix2x2 A) {
        CommonOps_DDF2.multTransB((DMatrix2x2)A, (DMatrix2x2)A, (DMatrix2x2)this.AA);
        double d = this.AA.a11 - this.AA.a22;
        return Math.sqrt(0.5 * (this.AA.a11 + this.AA.a22 + Math.sqrt(d * d + 4.0 * this.AA.a12 * this.AA.a12)));
    }

    void compute_Rv() {
        double t = Math.sqrt(this.v1 * this.v1 + this.v2 * this.v2);
        double s = Math.sqrt(t * t + 1.0);
        double cosT = 1.0 / s;
        double sinT = Math.sqrt(1.0 - 1.0 / (s * s));
        this.K_x.data[0] = 0.0;
        this.K_x.data[1] = 0.0;
        this.K_x.data[2] = this.v1;
        this.K_x.data[3] = 0.0;
        this.K_x.data[4] = 0.0;
        this.K_x.data[5] = this.v2;
        this.K_x.data[6] = -this.v1;
        this.K_x.data[7] = -this.v2;
        this.K_x.data[8] = 0.0;
        CommonOps_DDRM.divide((DMatrixD1)this.K_x, (double)t);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.R_v);
        CommonOps_DDRM.addEquals((DMatrixD1)this.R_v, (double)sinT, (DMatrixD1)this.K_x);
        CommonOps_DDRM.multAdd((double)(1.0 - cosT), (DMatrix1Row)this.K_x, (DMatrix1Row)this.K_x, (DMatrix1Row)this.R_v);
    }

    public DMatrixRMaj getHomography() {
        return this.H;
    }

    public int getMinimumPoints() {
        return this.estimateHomography.getMinimumPoints();
    }

    public Se3_F64 getWorldToCamera0() {
        return this.pose0;
    }

    public Se3_F64 getWorldToCamera1() {
        return this.pose1;
    }

    public double getError0() {
        return this.error0;
    }

    public double getError1() {
        return this.error1;
    }
}

