/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.impl;

import boofcv.alg.distort.pinhole.PinholeNtoP_F64;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class ImplPerspectiveOps_F64 {
    public static <C extends CameraPinhole> C adjustIntrinsic(C parameters, DMatrixRMaj adjustMatrix, C adjustedParam) {
        if (adjustedParam == null) {
            adjustedParam = (CameraPinhole)parameters.createLike();
        }
        adjustedParam.setTo(parameters);
        DMatrixRMaj K = ImplPerspectiveOps_F64.pinholeToMatrix(parameters, (DMatrixRMaj)null);
        DMatrixRMaj K_adj = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.mult((DMatrix1Row)adjustMatrix, (DMatrix1Row)K, (DMatrix1Row)K_adj);
        ImplPerspectiveOps_F64.matrixToPinhole(K_adj, parameters.width, parameters.height, adjustedParam);
        return adjustedParam;
    }

    public static DMatrixRMaj pinholeToMatrix(double fx, double fy, double skew, double cx, double cy, @Nullable DMatrixRMaj K) {
        if (K == null) {
            K = new DMatrixRMaj(3, 3);
        } else {
            K.reshape(3, 3);
        }
        CommonOps_DDRM.fill((DMatrixD1)K, (double)0.0);
        K.data[0] = fx;
        K.data[1] = skew;
        K.data[2] = cx;
        K.data[4] = fy;
        K.data[5] = cy;
        K.data[8] = 1.0;
        return K;
    }

    public static DMatrixRMaj pinholeToMatrix(CameraPinhole param, @Nullable DMatrixRMaj K) {
        return ImplPerspectiveOps_F64.pinholeToMatrix(param.fx, param.fy, param.skew, param.cx, param.cy, K);
    }

    public static DMatrix3x3 pinholeToMatrix(CameraPinhole param, DMatrix3x3 K) {
        if (K == null) {
            K = new DMatrix3x3();
        } else {
            CommonOps_DDF3.fill((DMatrix3x3)K, (double)0.0);
        }
        K.a11 = param.fx;
        K.a12 = param.skew;
        K.a13 = param.cx;
        K.a22 = param.fy;
        K.a23 = param.cy;
        K.a33 = 1.0;
        return K;
    }

    public static CameraPinhole matrixToPinhole(DMatrixRMaj K, int width, int height, @Nullable CameraPinhole output) {
        if (output == null) {
            output = new CameraPinhole();
        }
        output.fx = K.get(0, 0);
        output.fy = K.get(1, 1);
        output.skew = K.get(0, 1);
        output.cx = K.get(0, 2);
        output.cy = K.get(1, 2);
        output.width = width;
        output.height = height;
        return output;
    }

    public static Point2D_F64 convertNormToPixel(CameraModel param, double x, double y, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        Point2Transform2_F64 normToPixel = LensDistortionFactory.narrow(param).distort_F64(false, true);
        normToPixel.compute(x, y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertNormToPixel(DMatrixRMaj K, Point2D_F64 norm, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        PinholeNtoP_F64 alg = new PinholeNtoP_F64();
        alg.setK(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(norm.x, norm.y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertPixelToNorm(CameraModel param, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        Point2Transform2_F64 pixelToNorm = LensDistortionFactory.narrow(param).undistort_F64(true, false);
        pixelToNorm.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(DMatrixRMaj K, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        PinholePtoN_F64 alg = new PinholePtoN_F64();
        alg.setK(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(CameraPinhole intrinsic, double pixelX, double pixelY, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        double a11 = 1.0 / intrinsic.fx;
        double a12 = -intrinsic.skew / (intrinsic.fx * intrinsic.fy);
        double a13 = (intrinsic.skew * intrinsic.cy - intrinsic.cx * intrinsic.fy) / (intrinsic.fx * intrinsic.fy);
        double a22 = 1.0 / intrinsic.fy;
        double a23 = -intrinsic.cy / intrinsic.fy;
        norm.x = a11 * pixelX + a12 * pixelY + a13;
        norm.y = a22 * pixelY + a23;
        return norm;
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DMatrixRMaj K, Point3D_F64 X, @Nullable Point2D_F64 pixel) {
        DMatrixRMaj R = worldToCamera.R;
        Vector3D_F64 T = worldToCamera.T;
        double x = R.data[0] * X.x + R.data[1] * X.y + R.data[2] * X.z + T.x;
        double y = R.data[3] * X.x + R.data[4] * X.y + R.data[5] * X.z + T.y;
        double z = R.data[6] * X.x + R.data[7] * X.y + R.data[8] * X.z + T.z;
        if (z <= 0.0) {
            return null;
        }
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        pixel.setTo(x / z, y / z);
        if (K == null) {
            return pixel;
        }
        return (Point2D_F64)GeometryMath_F64.mult((DMatrixRMaj)K, (GeoTuple2D_F64)pixel, (GeoTuple2D_F64)pixel);
    }

    @Nullable
    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, double fx, double skew, double cx, double fy, double cy, Point3D_F64 X, @Nullable Point2D_F64 pixel) {
        Point3D_F64 X_cam = new Point3D_F64();
        SePointOps_F64.transform((Se3_F64)worldToCamera, (Point3D_F64)X, (Point3D_F64)X_cam);
        if (X_cam.z <= 0.0) {
            return null;
        }
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        double xx = X_cam.x / X_cam.z;
        double yy = X_cam.y / X_cam.z;
        pixel.x = fx * xx + skew * yy + cx;
        pixel.y = fy * yy + cy;
        return pixel;
    }

    @Nullable
    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, double fx, double skew, double cx, double fy, double cy, Point4D_F64 X, @Nullable Point2D_F64 pixel) {
        DMatrixRMaj R = worldToCamera.R;
        Vector3D_F64 T = worldToCamera.T;
        double x = R.data[0] * X.x + R.data[1] * X.y + R.data[2] * X.z + T.x * X.w;
        double y = R.data[3] * X.x + R.data[4] * X.y + R.data[5] * X.z + T.y * X.w;
        double z = R.data[6] * X.x + R.data[7] * X.y + R.data[8] * X.z + T.z * X.w;
        if (z <= 0.0) {
            return null;
        }
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        double xx = x / z;
        double yy = y / z;
        pixel.x = fx * xx + skew * yy + cx;
        pixel.y = fy * yy + cy;
        return pixel;
    }

    public static void renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X, Point3D_F64 pixelH) {
        DMatrixRMaj P = worldToCamera;
        pixelH.x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3];
        pixelH.y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7];
        pixelH.z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11];
    }

    public static void renderPixel(DMatrixRMaj worldToCamera, Point3D_F64 X, Point2D_F64 pixel) {
        DMatrixRMaj P = worldToCamera;
        double x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3];
        double y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7];
        double z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11];
        pixel.x = x / z;
        pixel.y = y / z;
    }

    public static void renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X, Point3D_F64 pixelH) {
        DMatrixRMaj P = cameraMatrix;
        pixelH.x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3] * X.w;
        pixelH.y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7] * X.w;
        pixelH.z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11] * X.w;
    }

    public static void renderPixel(DMatrixRMaj cameraMatrix, Point4D_F64 X, Point2D_F64 pixel) {
        DMatrixRMaj P = cameraMatrix;
        double x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3] * X.w;
        double y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7] * X.w;
        double z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11] * X.w;
        pixel.x = x / z;
        pixel.y = y / z;
    }

    public static double distance(Point4D_F64 a, Point4D_F64 b) {
        double na = a.norm();
        double nb = b.norm();
        if (na == 0.0 || nb == 0.0) {
            return a.distance((GeoTuple_F64)b);
        }
        return Math.sqrt(Math.min(ImplPerspectiveOps_F64.distance(a, b, na, nb), ImplPerspectiveOps_F64.distance(a, b, -na, nb)));
    }

    public static double distance(Point4D_F64 a, Point4D_F64 b, double na, double nb) {
        double xa = a.x / na;
        double ya = a.y / na;
        double za = a.z / na;
        double wa = a.w / na;
        double xb = b.x / nb;
        double yb = b.y / nb;
        double zb = b.z / nb;
        double wb = b.w / nb;
        double dx = xa - xb;
        double dy = ya - yb;
        double dz = za - zb;
        double dw = wa - wb;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public static DMatrixRMaj createCameraMatrix(DMatrixRMaj R, Vector3D_F64 T, @Nullable DMatrixRMaj K, @Nullable DMatrixRMaj ret) {
        if (ret == null) {
            ret = new DMatrixRMaj(3, 4);
        }
        CommonOps_DDRM.insert((DMatrix)R, (DMatrix)ret, (int)0, (int)0);
        ret.data[3] = T.x;
        ret.data[7] = T.y;
        ret.data[11] = T.z;
        if (K == null) {
            return ret;
        }
        DMatrixRMaj temp = new DMatrixRMaj(3, 4);
        CommonOps_DDRM.mult((DMatrix1Row)K, (DMatrix1Row)ret, (DMatrix1Row)temp);
        ret.set((DMatrixD1)temp);
        return ret;
    }
}

