/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F32;

public class RemoveBrownNtoN_F32
implements Point2Transform2_F32 {
    protected RadialTangential_F32 params;
    private float tol = GrlConstants.FCONV_TOL_A;

    public RemoveBrownNtoN_F32() {
    }

    public RemoveBrownNtoN_F32(float tol) {
        this.tol = tol;
    }

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public RemoveBrownNtoN_F32 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F32(radial, t1, t2);
        return this;
    }

    public void compute(float x, float y, Point2D_F32 out) {
        RemoveBrownNtoN_F32.removeRadial(x, y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }

    public RemoveBrownNtoN_F32 copyConcurrent() {
        RemoveBrownNtoN_F32 ret = new RemoveBrownNtoN_F32();
        ret.tol = this.tol;
        ret.params = new RadialTangential_F32(this.params);
        return ret;
    }

    public static void removeRadial(float x, float y, float[] radial, float t1, float t2, Point2D_F32 out, float tol) {
        float origX = x;
        float origY = y;
        float prevSum = 0.0f;
        for (int iter = 0; iter < 500; ++iter) {
            float r2;
            float ri2 = r2 = x * x + y * y;
            float sum = 0.0f;
            for (int i = 0; i < radial.length; ++i) {
                sum += radial[i] * ri2;
                ri2 *= r2;
            }
            float tx = 2.0f * t1 * x * y + t2 * (r2 + 2.0f * x * x);
            float ty = t1 * (r2 + 2.0f * y * y) + 2.0f * t2 * x * y;
            x = (origX - tx) / (1.0f + sum);
            y = (origY - ty) / (1.0f + sum);
            if (Math.abs(prevSum - sum) <= tol) break;
            prevSum = sum;
        }
        out.setTo(x, y);
    }
}

