/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;

public class AddBrownPtoN_F64
implements Point2Transform2_F64 {
    protected RadialTangential_F64 params;
    private double a11;
    private double a12;
    private double a13;
    private double a22;
    private double a23;

    public AddBrownPtoN_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.a11 = 1.0 / fx;
        this.a12 = -skew / (fx * fy);
        this.a13 = (skew * cy - cx * fy) / (fx * fy);
        this.a22 = 1.0 / fy;
        this.a23 = -cy / fy;
        return this;
    }

    public AddBrownPtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        double r2;
        double sum = 0.0;
        double[] radial = this.params.radial;
        double t1 = this.params.t1;
        double t2 = this.params.t2;
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        double ri2 = r2 = out.x * out.x + out.y * out.y;
        for (int i = 0; i < radial.length; ++i) {
            sum += radial[i] * ri2;
            ri2 *= r2;
        }
        double tx = 2.0 * t1 * out.x * out.y + t2 * (r2 + 2.0 * out.x * out.x);
        double ty = t1 * (r2 + 2.0 * out.y * out.y) + 2.0 * t2 * out.x * out.y;
        out.x = out.x * (1.0 + sum) + tx;
        out.y = out.y * (1.0 + sum) + ty;
    }

    public AddBrownPtoN_F64 copyConcurrent() {
        AddBrownPtoN_F64 ret = new AddBrownPtoN_F64();
        ret.a11 = this.a11;
        ret.a12 = this.a12;
        ret.a13 = this.a13;
        ret.a22 = this.a22;
        ret.a23 = this.a23;
        ret.params = new RadialTangential_F64(this.params);
        return ret;
    }
}

