/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.PruneStructureFromSceneMetric;
import boofcv.abst.geo.bundle.ScaleSceneStructure;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.ConfigConverge;
import java.io.PrintStream;
import org.jetbrains.annotations.Nullable;

public class MetricBundleAdjustmentUtils {
    public final ConfigConverge configConverge = new ConfigConverge(1.0E-5, 1.0E-5, 30);
    public boolean configScale = false;
    public double keepFraction = 1.0;
    public final SceneStructureMetric structure = new SceneStructureMetric(true);
    public final SceneObservations observations = new SceneObservations();
    public BundleAdjustment<SceneStructureMetric> sba = FactoryMultiView.bundleSparseMetric(null);
    public TriangulateNViewsMetricH triangulator = FactoryMultiView.triangulateNViewMetricH(null);
    public ScaleSceneStructure scaler = new ScaleSceneStructure();

    public boolean process(@Nullable PrintStream verbose) {
        if (this.configConverge.maxIterations == 0) {
            return true;
        }
        if (this.configScale) {
            this.scaler.applyScale(this.structure, this.observations);
        }
        this.sba.configure(this.configConverge.ftol, this.configConverge.gtol, this.configConverge.maxIterations);
        this.sba.setParameters(this.structure, this.observations);
        if (verbose != null) {
            verbose.println("SBA BEFORE        average error=" + Math.sqrt(this.sba.getFitScore()) / (double)this.observations.getObservationCount());
        }
        if (!this.sba.optimize(this.structure)) {
            return false;
        }
        if (verbose != null) {
            verbose.println("SBA AFTER         average error=" + Math.sqrt(this.sba.getFitScore()) / (double)this.observations.getObservationCount());
        }
        if (this.keepFraction < 1.0) {
            this.prune(this.keepFraction, -1, 1);
            this.sba.setParameters(this.structure, this.observations);
            if (verbose != null) {
                verbose.println("SBA PRUNED-BEFORE average error=" + Math.sqrt(this.sba.getFitScore()) / (double)this.observations.getObservationCount());
            }
            if (!this.sba.optimize(this.structure)) {
                return false;
            }
            if (verbose != null) {
                verbose.println("SBA PRUNED-AFTER  average error=" + Math.sqrt(this.sba.getFitScore()) / (double)this.observations.getObservationCount());
            }
        }
        if (this.configScale) {
            this.scaler.undoScale(this.structure, this.observations);
        }
        return true;
    }

    public void prune(double keepFraction, int pruneViews, int prunePoints) {
        prunePoints = Math.max(1, prunePoints);
        PruneStructureFromSceneMetric pruner = new PruneStructureFromSceneMetric(this.structure, this.observations);
        pruner.pruneObservationsByErrorRank(keepFraction);
        if (pruneViews > 0 && pruner.pruneViews(pruneViews)) {
            pruner.pruneUnusedMotions();
        }
        pruner.prunePoints(prunePoints);
    }

    public void printCounts(PrintStream out) {
        out.println("Points=" + this.structure.points.size);
        out.println("Views=" + this.structure.views.size);
        out.println("Cameras=" + this.structure.cameras.size);
        for (int viewIdx = 0; viewIdx < this.observations.views.size; ++viewIdx) {
            out.println("view[" + viewIdx + "].observations.size=" + ((SceneObservations.View)this.observations.views.get(viewIdx)).size());
        }
    }

    public ConfigConverge getConfigConverge() {
        return this.configConverge;
    }

    public boolean isConfigScale() {
        return this.configScale;
    }

    public void setConfigScale(boolean configScale) {
        this.configScale = configScale;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }

    public BundleAdjustment<SceneStructureMetric> getSba() {
        return this.sba;
    }

    public void setSba(BundleAdjustment<SceneStructureMetric> sba) {
        this.sba = sba;
    }

    public TriangulateNViewsMetricH getTriangulator() {
        return this.triangulator;
    }

    public void setTriangulator(TriangulateNViewsMetricH triangulator) {
        this.triangulator = triangulator;
    }

    public ScaleSceneStructure getScaler() {
        return this.scaler;
    }
}

