/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

public class CachedSineCosine_F32 {
    float minAngle;
    float maxAngle;
    float delta;
    public float[] c;
    public float[] s;

    public CachedSineCosine_F32(float minAngle, float maxAngle, int size) {
        this.minAngle = minAngle;
        this.maxAngle = maxAngle;
        this.delta = (maxAngle - minAngle) / (float)size;
        this.c = new float[size];
        this.s = new float[size];
        for (int i = 0; i < size; ++i) {
            float angle = (maxAngle - minAngle) * (float)i / (float)size + minAngle;
            this.c[i] = (float)Math.cos(angle);
            this.s[i] = (float)Math.sin(angle);
        }
    }

    public float cosine(float value) {
        return this.interpolate(value, this.c);
    }

    public float sine(float value) {
        return this.interpolate(value, this.s);
    }

    private float interpolate(float value, float[] table) {
        float v = value - this.minAngle;
        int i = (int)v;
        if (i < 0) {
            return table[0];
        }
        if (i >= table.length - 1) {
            return table[table.length - 1];
        }
        float w = v - (float)i;
        return table[i] * (1.0f - w) + table[i + 1] * w;
    }

    public int computeIndex(float angle) {
        return (int)((angle - this.minAngle) / this.delta);
    }
}

