/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.WrapDescribeBrief;
import boofcv.abst.feature.describe.WrapDescribePixelRegionNCC;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.ConfigFastCorner;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.ConfigTrackerHybrid;
import boofcv.abst.tracker.PointTracker;
import boofcv.abst.tracker.PointTrackerDda;
import boofcv.abst.tracker.PointTrackerHybrid;
import boofcv.abst.tracker.PointTrackerKltPyramid;
import boofcv.alg.feature.describe.DescribePointBrief;
import boofcv.alg.feature.describe.DescribePointPixelRegionNCC;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.dda.DetectDescribeAssociateTracker;
import boofcv.alg.tracker.hybrid.HybridTrackerScalePoint;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.associate.ConfigAssociateGreedy;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPoint;
import boofcv.factory.feature.orientation.FactoryOrientation;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.factory.tracker.FactoryTrackerAlg;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class FactoryPointTracker {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> tracker(ConfigPointTracker config, Class<I> imageType, @Nullable Class<D> derivType) {
        if (config.typeTracker == ConfigPointTracker.TrackerType.KLT) {
            return FactoryPointTracker.klt(config.klt, config.detDesc.detectPoint, imageType, derivType);
        }
        DetectDescribePoint<I, TupleDesc_F64> detDesc = FactoryDetectDescribe.generic(config.detDesc, imageType);
        AssociateDescription2D associate = FactoryAssociation.generic2(config.associate, detDesc);
        switch (config.typeTracker) {
            case DDA: {
                return FactoryPointTracker.dda(detDesc, associate, config.dda);
            }
            case HYBRID: {
                return FactoryPointTracker.hybrid(detDesc, associate, config.detDesc.findNonMaxRadius(), config.klt, config.hybrid, imageType);
            }
        }
        throw new RuntimeException("BUG! KLT all trackers should have been handled already");
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> klt(int numLevels, @Nullable ConfigPointDetector configDetect, int featureRadius, Class<I> imageType, Class<D> derivType) {
        ConfigPKlt config = new ConfigPKlt();
        config.pyramidLevels = ConfigDiscreteLevels.levels((int)numLevels);
        config.templateRadius = featureRadius;
        return FactoryPointTracker.klt(config, configDetect, imageType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTrackerKltPyramid<I, D> klt(@Nullable ConfigPKlt config, @Nullable ConfigPointDetector configDetect, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        if (config == null) {
            config = new ConfigPKlt();
        }
        config.checkValidity();
        if (configDetect == null) {
            configDetect = new ConfigPointDetector();
            configDetect.type = PointDetectorTypes.SHI_TOMASI;
        }
        configDetect.checkValidity();
        GeneralFeatureDetector detector = FactoryDetectPoint.create(configDetect, imageType, derivType);
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, (Class)derivType);
        PyramidDiscrete pyramid = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)config.pyramidLevels, (double)-1.0, (int)2, (boolean)true, (ImageType)ImageType.single(imageType));
        PointTrackerKltPyramid ret = new PointTrackerKltPyramid(config.config, config.toleranceFB, config.templateRadius, config.pruneClose, pyramid, detector, gradient, interpInput, interpDeriv, derivType);
        ret.configMaxTracks = config.maximumTracks;
        return ret;
    }

    @Deprecated
    public static <I extends ImageGray<I>> PointTracker<I> dda_FH_SURF_Fast(ConfigFastHessian configDetector, ConfigSurfDescribe.Fast configDescribe, ConfigAverageIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateDescription<TupleDesc_F64> assoc = FactoryAssociation.greedy(new ConfigAssociateGreedy(true, 5.0), score);
        AssociateDescTo2D<TupleDesc_F64> associate2D = new AssociateDescTo2D<TupleDesc_F64>(assoc);
        DetectDescribePoint<I, TupleDesc_F64> fused = FactoryDetectDescribe.surfFast(configDetector, configDescribe, configOrientation, imageType);
        return new PointTrackerDda<I, TupleDesc_F64>(new DetectDescribeAssociateTracker<I, TupleDesc_F64>(fused, associate2D, new ConfigTrackerDda()));
    }

    @Deprecated
    public static <I extends ImageGray<I>> PointTracker<I> dda_FH_SURF_Stable(ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateDescription<TupleDesc_F64> assoc = FactoryAssociation.greedy(new ConfigAssociateGreedy(true, 5.0), score);
        AssociateDescTo2D<TupleDesc_F64> associate2D = new AssociateDescTo2D<TupleDesc_F64>(assoc);
        DetectDescribePoint<I, TupleDesc_F64> fused = FactoryDetectDescribe.surfStable(configDetector, configDescribe, configOrientation, imageType);
        return new PointTrackerDda<I, TupleDesc_F64>(new DetectDescribeAssociateTracker<I, TupleDesc_F64>(fused, associate2D, new ConfigTrackerDda()));
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_ST_BRIEF(int maxAssociationError, ConfigGeneralDetector configExtract, Class<I> imageType, Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        DescribePointBrief brief = FactoryDescribePointAlgs.brief(FactoryBriefDefinition.gaussian2(new Random(123L), 16, 512), FactoryBlurFilter.gaussian((ImageType)ImageType.single(imageType), (double)0.0, (int)4));
        WrapDescribeBrief describeBrief = new WrapDescribeBrief(brief, imageType);
        GeneralFeatureDetector<I, D> detectPoint = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D<TupleDesc_B> association = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, maxAssociationError), score));
        InterestPointDetector<I> detector = FactoryInterestPoint.wrapPoint(detectPoint, 1.0, imageType, derivType);
        DetectDescribePoint fused = FactoryDetectDescribe.fuseTogether(detector, null, describeBrief);
        return new PointTrackerDda<I, TupleDesc_B>(new DetectDescribeAssociateTracker<I, TupleDesc_B>(fused, association, new ConfigTrackerDda()));
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_FAST_BRIEF(ConfigFastCorner configFast, ConfigGeneralDetector configExtract, int maxAssociationError, Class<I> imageType) {
        DescribePointBrief brief = FactoryDescribePointAlgs.brief(FactoryBriefDefinition.gaussian2(new Random(123L), 16, 512), FactoryBlurFilter.gaussian((ImageType)ImageType.single(imageType), (double)0.0, (int)4));
        WrapDescribeBrief describeBrief = new WrapDescribeBrief(brief, imageType);
        GeneralFeatureDetector corner = FactoryDetectPoint.createFast(configExtract, configFast, imageType);
        ScoreAssociateHamming_B score = new ScoreAssociateHamming_B();
        AssociateDescTo2D<TupleDesc_B> association = new AssociateDescTo2D<TupleDesc_B>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, maxAssociationError), score));
        InterestPointDetector<I> detector = FactoryInterestPoint.wrapPoint(corner, 1.0, imageType, null);
        DetectDescribePoint fused = FactoryDetectDescribe.fuseTogether(detector, null, describeBrief);
        return new PointTrackerDda<I, TupleDesc_B>(new DetectDescribeAssociateTracker<I, TupleDesc_B>(fused, association, new ConfigTrackerDda()));
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> dda_ST_NCC(ConfigGeneralDetector configExtract, int describeRadius, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        int w = 2 * describeRadius + 1;
        DescribePointPixelRegionNCC<I> ncc = FactoryDescribePointAlgs.pixelRegionNCC(w, w, imageType);
        WrapDescribePixelRegionNCC<I> describeNCC = new WrapDescribePixelRegionNCC<I>(ncc, imageType);
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        ScoreAssociateNccFeature score = new ScoreAssociateNccFeature();
        AssociateDescTo2D<NccFeature> association = new AssociateDescTo2D<NccFeature>(FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score));
        InterestPointDetector<I> detector = FactoryInterestPoint.wrapPoint(corner, 1.0, imageType, null);
        DetectDescribePoint fused = FactoryDetectDescribe.fuseTogether(detector, null, describeNCC);
        return new PointTrackerDda<I, NccFeature>(new DetectDescribeAssociateTracker<I, NccFeature>(fused, association, new ConfigTrackerDda()));
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> DetectDescribeAssociateTracker<I, Desc> dda(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, ConfigTrackerDda config) {
        DetectDescribeFusion<I, Desc> fused = new DetectDescribeFusion<I, Desc>(detector, orientation, describe);
        return new DetectDescribeAssociateTracker<I, Desc>(fused, associate, config);
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> PointTrackerDda<I, Desc> dda(DetectDescribePoint<I, Desc> detDesc, AssociateDescription2D<Desc> associate, ConfigTrackerDda config) {
        return new PointTrackerDda<I, Desc>(new DetectDescribeAssociateTracker<I, Desc>(detDesc, associate, config));
    }

    @Deprecated
    public static <I extends ImageGray<I>> PointTracker<I> combined_FH_SURF_KLT(ConfigPKlt kltConfig, ConfigTrackerHybrid configHybrid, ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType) {
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.defaultScore(TupleDesc_F64.class);
        AssociateDescription<TupleDesc_F64> assoc = FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score);
        AssociateDescTo2D<TupleDesc_F64> associate2D = new AssociateDescTo2D<TupleDesc_F64>(assoc);
        DetectDescribePoint<I, TupleDesc_F64> fused = FactoryDetectDescribe.surfStable(configDetector, configDescribe, configOrientation, imageType);
        return FactoryPointTracker.hybrid(fused, associate2D, configDetector.extract.radius, kltConfig, configHybrid, imageType);
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> PointTracker<I> combined_ST_SURF_KLT(ConfigGeneralDetector configExtract, ConfigPKlt kltConfig, ConfigTrackerHybrid configHybrid, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<I> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        GeneralFeatureDetector<I, D> corner = FactoryPointTracker.createShiTomasi(configExtract, derivType);
        InterestPointDetector<I> detector = FactoryInterestPoint.wrapPoint(corner, 1.0, imageType, derivType);
        DescribeRegionPoint<I, TupleDesc_F64> regionDesc = FactoryDescribeRegionPoint.surfStable(configDescribe, imageType);
        ScoreAssociation<TupleDesc_F64> score = FactoryAssociation.scoreEuclidean(TupleDesc_F64.class, true);
        AssociateDescription<TupleDesc_F64> assoc = FactoryAssociation.greedy(new ConfigAssociateGreedy(true, Double.MAX_VALUE), score);
        AssociateDescTo2D<TupleDesc_F64> associate2D = new AssociateDescTo2D<TupleDesc_F64>(assoc);
        OrientationImage<I> orientation = null;
        if (configOrientation != null) {
            Class integralType = GIntegralImageOps.getIntegralType(imageType);
            OrientationIntegral orientationII = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
            orientation = FactoryOrientation.convertImage(orientationII, imageType);
        }
        return FactoryPointTracker.hybrid(detector, orientation, regionDesc, associate2D, configExtract.radius, kltConfig, configHybrid, imageType);
    }

    public static <I extends ImageGray<I>, Desc extends TupleDesc> PointTracker<I> hybrid(InterestPointDetector<I> detector, OrientationImage<I> orientation, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, int tooCloseRadius, ConfigPKlt kltConfig, ConfigTrackerHybrid configHybrid, Class<I> imageType) {
        DetectDescribeFusion<I, Desc> fused = new DetectDescribeFusion<I, Desc>(detector, orientation, describe);
        return FactoryPointTracker.hybrid(fused, associate, tooCloseRadius, kltConfig, configHybrid, imageType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTracker<I> hybrid(DetectDescribePoint<I, Desc> detector, AssociateDescription2D<Desc> associate, int tooCloseRadius, ConfigPKlt kltConfig, ConfigTrackerHybrid configHybrid, Class<I> imageType) {
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        if (kltConfig == null) {
            kltConfig = new ConfigPKlt();
        }
        if (!configHybrid.pruneCloseTracks) {
            tooCloseRadius = -1;
        }
        HybridTrackerScalePoint tracker = FactoryTrackerAlg.hybrid(detector, associate, tooCloseRadius, kltConfig, configHybrid, imageType, derivType);
        tracker.rand = new Random(configHybrid.seed);
        PointTrackerHybrid pointHybrid = new PointTrackerHybrid(tracker, kltConfig.pyramidLevels, imageType, derivType);
        pointHybrid.thresholdRespawn.setTo(configHybrid.thresholdRespawn);
        return pointHybrid;
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> PointTracker<I> dda(GeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, AssociateDescription2D<Desc> associate, double scale, Class<I> imageType) {
        InterestPointDetector<I> detectInterest = FactoryInterestPoint.wrapPoint(detector, scale, imageType, null);
        DetectDescribePoint<I, Desc> fused = FactoryDetectDescribe.fuseTogether(detectInterest, null, describe);
        return new PointTrackerDda<I, Desc>(new DetectDescribeAssociateTracker<I, Desc>(fused, associate, new ConfigTrackerDda()));
    }

    @Deprecated
    public static <I extends ImageGray<I>, D extends ImageGray<D>> GeneralFeatureDetector<I, D> createShiTomasi(ConfigGeneralDetector config, Class<D> derivType) {
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.shiTomasi(1, false, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, config);
    }
}

