/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.dda;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.AssociateDescriptionSets2D;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class DetectDescribeAssociateTracker<I extends ImageGray<I>, TD extends TupleDesc> {
    protected AssociateDescriptionSets2D<TD> associate;
    protected DetectDescribePoint<I, TD> detector;
    protected DogArray<PointTrack> tracksAll;
    protected List<PointTrack> tracksActive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksInactive = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksDropped = new ArrayList<PointTrack>();
    protected List<PointTrack> tracksNew = new ArrayList<PointTrack>();
    protected long frameID = -1L;
    protected long featureID = 0L;
    boolean updateDescription;
    protected int maxInactiveTracks;
    protected Random rand;
    protected FastArray<TD> dstDesc;
    protected DogArray_I32 dstSet = new DogArray_I32();
    protected FastArray<Point2D_F64> dstPixels = new FastArray(Point2D_F64.class);
    protected FastArray<TD> srcDesc;
    protected DogArray_I32 srcSet = new DogArray_I32();
    protected FastArray<Point2D_F64> srcPixels = new FastArray(Point2D_F64.class);

    public DetectDescribeAssociateTracker(DetectDescribePoint<I, TD> detector, AssociateDescription2D<TD> associate, ConfigTrackerDda config) {
        this.detector = detector;
        this.associate = new AssociateDescriptionSets2D<TD>(associate, detector.getDescriptionType());
        this.updateDescription = config.updateDescription;
        this.maxInactiveTracks = config.maxInactiveTracks;
        this.rand = new Random(config.seed);
        this.dstDesc = new FastArray(detector.getDescriptionType());
        this.srcDesc = new FastArray(detector.getDescriptionType());
        this.tracksAll = new DogArray(this::createNewTrack, this::resetTrack);
        this.associate.initialize(detector.getNumberOfSets());
    }

    protected DetectDescribeAssociateTracker() {
    }

    protected PointTrack createNewTrack() {
        PointTrack t = new PointTrack();
        t.setDescription(this.detector.createDescription());
        return t;
    }

    protected void resetTrack(PointTrack t) {
        TupleDesc desc = (TupleDesc)t.getDescription();
        Object cookie = t.getCookie();
        t.reset();
        t.setDescription(desc);
        t.setCookie(cookie);
    }

    public void reset() {
        this.dropAllTracks();
        this.featureID = 0L;
        this.frameID = -1L;
    }

    public void process(I input) {
        if (this.frameID == -1L) {
            this.associate.initialize(((ImageGray)input).width, ((ImageGray)input).height);
        }
        ++this.frameID;
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.detector.detect(input);
        int N = this.detector.getNumberOfFeatures();
        this.dstDesc.resize(N);
        this.dstSet.resize(N);
        this.dstPixels.resize(N);
        for (int i = 0; i < N; ++i) {
            ((TupleDesc[])this.dstDesc.data)[i] = this.detector.getDescription(i);
            this.dstSet.data[i] = this.detector.getSet(i);
            ((Point2D_F64[])this.dstPixels.data)[i] = this.detector.getLocation(i);
        }
        if (this.tracksAll.size == 0) {
            return;
        }
        this.performTracking();
        DogArray_I32 unassociatedIdx = this.associate.getUnassociatedSource();
        for (int j = 0; j < unassociatedIdx.size(); ++j) {
            this.tracksInactive.add((PointTrack)this.tracksAll.get(unassociatedIdx.get(j)));
        }
        this.dropExcessiveInactiveTracks(unassociatedIdx);
    }

    void dropExcessiveInactiveTracks(DogArray_I32 unassociated) {
        if (unassociated.size > this.maxInactiveTracks) {
            int i;
            int numDrop = unassociated.size - this.maxInactiveTracks;
            for (i = 0; i < numDrop; ++i) {
                int selected = this.rand.nextInt(unassociated.size - i) + i;
                int a = unassociated.get(i);
                unassociated.data[i] = unassociated.data[selected];
                unassociated.data[selected] = a;
            }
            unassociated.size = numDrop;
            unassociated.sort();
            for (i = unassociated.size - 1; i >= 0; --i) {
                this.tracksDropped.add(this.dropTrackIndexInAll(unassociated.get(i)));
            }
        }
    }

    protected void performTracking() {
        int numTracks = this.tracksAll.size();
        this.srcDesc.resize(numTracks);
        this.srcPixels.resize(numTracks);
        this.srcSet.resize(numTracks);
        for (int i = 0; i < numTracks; ++i) {
            PointTrack t = (PointTrack)this.tracksAll.get(i);
            ((TupleDesc[])this.srcDesc.data)[i] = (TupleDesc)t.getDescription();
            ((Point2D_F64[])this.srcPixels.data)[i] = t.pixel;
            this.srcSet.data[i] = t.detectorSetId;
        }
        UtilFeature.setSource(this.srcDesc, this.srcSet, this.srcPixels, this.associate);
        UtilFeature.setDestination(this.dstDesc, this.dstSet, this.dstPixels, this.associate);
        this.associate.associate();
        FastAccess<AssociatedIndex> matches = this.associate.getMatches();
        for (int i = 0; i < matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])matches.data)[i];
            PointTrack track = (PointTrack)this.tracksAll.get(indexes.src);
            Point2D_F64 loc = ((Point2D_F64[])this.dstPixels.data)[indexes.dst];
            track.pixel.setTo(loc.x, loc.y);
            track.lastSeenFrameID = this.frameID;
            this.tracksActive.add(track);
            if (!this.updateDescription) continue;
            ((TupleDesc)track.getDescription()).setTo((TupleDesc)this.dstDesc.get(indexes.dst));
        }
    }

    public void spawnTracks() {
        if (this.tracksAll.size == 0) {
            for (int i = 0; i < this.dstDesc.size; ++i) {
                Point2D_F64 loc = (Point2D_F64)this.dstPixels.get(i);
                this.addNewTrack(this.dstSet.get(i), loc.x, loc.y, (TupleDesc)this.dstDesc.get(i));
            }
            return;
        }
        DogArray_I32 unassociated = this.associate.getUnassociatedDestination();
        for (int i = 0; i < unassociated.size; ++i) {
            int indexDst = unassociated.get(i);
            Point2D_F64 loc = (Point2D_F64)this.dstPixels.get(indexDst);
            this.addNewTrack(this.dstSet.get(i), loc.x, loc.y, (TupleDesc)this.dstDesc.get(indexDst));
        }
    }

    protected void addNewTrack(int set, double x, double y, TD desc) {
        PointTrack p = (PointTrack)this.tracksAll.grow();
        p.pixel.setTo(x, y);
        ((TupleDesc)p.getDescription()).setTo(desc);
        p.spawnFrameID = this.frameID;
        p.lastSeenFrameID = this.frameID;
        p.detectorSetId = set;
        p.featureId = this.featureID++;
        this.tracksNew.add(p);
        this.tracksActive.add(p);
    }

    public void dropAllTracks() {
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksAll.reset();
        this.tracksNew.clear();
    }

    public boolean dropTrack(PointTrack track) {
        int indexInAll = this.tracksAll.indexOf((Object)track);
        if (indexInAll < 0) {
            return false;
        }
        this.dropTrackIndexInAll(indexInAll);
        return true;
    }

    private PointTrack dropTrackIndexInAll(int indexInAll) {
        PointTrack track = (PointTrack)this.tracksAll.removeSwap(indexInAll);
        boolean found = this.tracksActive.remove(track);
        assert (found |= this.tracksInactive.remove(track));
        return track;
    }

    public void dropTracks(PointTracker.Dropper dropper) {
        for (int i = this.tracksAll.size() - 1; i >= 0; --i) {
            PointTrack track = (PointTrack)this.tracksAll.get(i);
            if (!dropper.shouldDropTrack(track)) continue;
            this.dropTrackIndexInAll(i);
        }
    }

    public DogArray<PointTrack> getTracksAll() {
        return this.tracksAll;
    }

    public List<PointTrack> getTracksActive() {
        return this.tracksActive;
    }

    public List<PointTrack> getTracksInactive() {
        return this.tracksInactive;
    }

    public List<PointTrack> getTracksDropped() {
        return this.tracksDropped;
    }

    public List<PointTrack> getTracksNew() {
        return this.tracksNew;
    }

    public long getFrameID() {
        return this.frameID;
    }

    public boolean isUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(boolean updateDescription) {
        this.updateDescription = updateDescription;
    }
}

