/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.alg.feature.detect.line.HoughTransformParameters;
import boofcv.struct.image.GrayF32;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;

public class HoughParametersFootOfNorm
implements HoughTransformParameters {
    int originX;
    int originY;
    int minDistanceFromOrigin;

    public HoughParametersFootOfNorm(int minDistanceFromOrigin) {
        this.minDistanceFromOrigin = minDistanceFromOrigin;
    }

    @Override
    public void initialize(int width, int height, GrayF32 transform) {
        this.originX = width / 2;
        this.originY = height / 2;
        transform.reshape(width, height);
    }

    @Override
    public boolean isTransformValid(int x, int y) {
        return Math.abs(x - this.originX) >= this.minDistanceFromOrigin || Math.abs(y - this.originX) >= this.minDistanceFromOrigin;
    }

    @Override
    public void lineToCoordinate(LineParametric2D_F32 line, Point2D_F64 coordinate) {
        coordinate.setTo((double)line.p.x, (double)line.p.y);
    }

    @Override
    public void transformToLine(float x, float y, LineParametric2D_F32 l) {
        l.p.x = x;
        l.p.y = y;
        l.slope.x = -(l.p.y - (float)this.originY);
        l.slope.y = l.p.x - (float)this.originX;
    }

    @Override
    public void parameterize(int x, int y, GrayF32 transform) {
        throw new IllegalArgumentException("Not supported");
    }

    @Override
    public void parameterize(int x, int y, float derivX, float derivY, Point2D_F32 parameter) {
        float v = ((float)(x -= this.originX) * derivX + (float)(y -= this.originY) * derivY) / (derivX * derivX + derivY * derivY);
        parameter.x = v * derivX + (float)this.originX;
        parameter.y = v * derivY + (float)this.originY;
    }
}

