/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.intensity.GIntegralImageFeatureIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensityImage;
import boofcv.alg.feature.detect.selector.SampleIntensityScalePoint;
import boofcv.alg.transform.ii.DerivativeIntegralImage;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I16;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class FastHessianFeatureDetector<II extends ImageGray<II>> {
    private II integral;
    private NonMaxSuppression extractor;
    private FeatureSelectLimitIntensity<Point2D_I16> selectFeaturesInScale;
    private FastArray<Point2D_I16> selectedScale = new FastArray(Point2D_I16.class);
    public int maxFeaturesPerScale = -1;
    private FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll;
    private FastArray<ScalePoint> selectedAll = new FastArray(ScalePoint.class);
    public int maxFeaturesAll = -1;
    private GrayF32[] intensity;
    private int spaceIndex = 0;
    private QueueCorner foundFeatures = new QueueCorner(100);
    private DogArray<ScalePoint> featuresAllScales = new DogArray(10, ScalePoint::new);
    private final int initialSize;
    private final int scaleStepSize;
    private final int numberOfOctaves;
    private final int[] sizes;
    protected IntegralKernel kerXX;
    protected IntegralKernel kerYY;
    private final int initialSampleRate;

    public FastHessianFeatureDetector(NonMaxSuppression extractor, FeatureSelectLimitIntensity<Point2D_I16> selectFeaturesInScale, FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll, int initialSampleRate, int initialSize, int numberScalesPerOctave, int numberOfOctaves, int scaleStepSize) {
        this.extractor = extractor;
        this.selectFeaturesInScale = selectFeaturesInScale;
        this.selectFeaturesAll = selectFeaturesAll;
        this.initialSampleRate = initialSampleRate;
        this.initialSize = initialSize;
        this.numberOfOctaves = numberOfOctaves;
        this.scaleStepSize = scaleStepSize;
        this.sizes = new int[numberScalesPerOctave];
        selectFeaturesInScale.setSampler(new SampleIntensityImage.I16());
        selectFeaturesAll.setSampler(new SampleIntensityScalePoint());
    }

    public void detect(II integral) {
        if (this.intensity == null) {
            this.intensity = new GrayF32[3];
            for (int i = 0; i < this.intensity.length; ++i) {
                this.intensity[i] = new GrayF32(((ImageGray)integral).width, ((ImageGray)integral).height);
            }
        }
        this.featuresAllScales.reset();
        int skip = this.initialSampleRate;
        int sizeStep = this.scaleStepSize;
        int octaveSize = this.initialSize;
        for (int octave = 0; octave < this.numberOfOctaves; ++octave) {
            for (int i = 0; i < this.sizes.length; ++i) {
                this.sizes[i] = octaveSize + i * sizeStep;
            }
            int maxSize = this.sizes[this.sizes.length - 1];
            if (maxSize > ((ImageGray)integral).width || maxSize > ((ImageGray)integral).height) break;
            this.detectOctave(integral, skip, this.sizes);
            skip += skip;
            octaveSize += sizeStep;
            sizeStep += sizeStep;
        }
        if (this.maxFeaturesAll > 0) {
            this.selectFeaturesAll.select(null, ((ImageGray)integral).width, ((ImageGray)integral).height, true, (FastAccess<ScalePoint>)null, (FastAccess<ScalePoint>)this.featuresAllScales, this.maxFeaturesAll, this.selectedAll);
        }
    }

    protected void detectOctave(II integral, int skip, int ... featureSize) {
        int i;
        this.integral = integral;
        int w = ((ImageGray)integral).width / skip;
        int h = ((ImageGray)integral).height / skip;
        for (i = 0; i < this.intensity.length; ++i) {
            this.intensity[i].reshape(w, h);
        }
        for (i = 0; i < featureSize.length; ++i) {
            GIntegralImageFeatureIntensity.hessian(integral, skip, featureSize[i], this.intensity[this.spaceIndex]);
            ++this.spaceIndex;
            if (this.spaceIndex >= 3) {
                this.spaceIndex = 0;
            }
            if (i < 2) continue;
            this.findLocalScaleSpaceMax(featureSize, i - 1, skip);
        }
    }

    private void findLocalScaleSpaceMax(int[] size, int level, int skip) {
        FastArray<Point2D_I16> features;
        int index0 = this.spaceIndex;
        int index1 = (this.spaceIndex + 1) % 3;
        int index2 = (this.spaceIndex + 2) % 3;
        ImageBorder_F32 inten0 = FactoryImageBorderAlgs.value((GrayF32)this.intensity[index0], (float)0.0f);
        GrayF32 inten1 = this.intensity[index1];
        ImageBorder_F32 inten2 = FactoryImageBorderAlgs.value((GrayF32)this.intensity[index2], (float)0.0f);
        this.foundFeatures.reset();
        this.extractor.setIgnoreBorder(size[level] / (2 * skip));
        this.extractor.process(this.intensity[index1], null, null, null, this.foundFeatures);
        int ignoreRadius = this.extractor.getIgnoreBorder() + this.extractor.getSearchRadius();
        int ignoreWidth = this.intensity[index1].width - ignoreRadius;
        int ignoreHeight = this.intensity[index1].height - ignoreRadius;
        if (this.maxFeaturesPerScale > 0) {
            this.selectFeaturesInScale.select(this.intensity[index1], -1, -1, true, null, (FastAccess<Point2D_I16>)this.foundFeatures, this.maxFeaturesPerScale, this.selectedScale);
            features = this.selectedScale;
        } else {
            features = this.foundFeatures;
        }
        int levelSize = size[level];
        int sizeStep = levelSize - size[level - 1];
        this.featuresAllScales.reserve(this.featuresAllScales.size + features.size);
        for (int i = 0; i < features.size; ++i) {
            float intenF;
            Point2D_I16 f = (Point2D_I16)features.get(i);
            if (f.x < ignoreRadius || f.x >= ignoreWidth || f.y < ignoreRadius || f.y >= ignoreHeight || !FastHessianFeatureDetector.checkMax(inten0, intenF = inten1.get((int)f.x, (int)f.y), f.x, f.y) || !FastHessianFeatureDetector.checkMax(inten2, intenF, f.x, f.y)) continue;
            float peakX = FastHessianFeatureDetector.polyPeak(inten1.get(f.x - 1, (int)f.y), inten1.get((int)f.x, (int)f.y), inten1.get(f.x + 1, (int)f.y));
            float peakY = FastHessianFeatureDetector.polyPeak(inten1.get((int)f.x, f.y - 1), inten1.get((int)f.x, (int)f.y), inten1.get((int)f.x, f.y + 1));
            float peakS = FastHessianFeatureDetector.polyPeak(inten0.get((int)f.x, (int)f.y), inten1.get((int)f.x, (int)f.y), inten2.get((int)f.x, (int)f.y));
            float interpX = ((float)f.x + peakX) * (float)skip;
            float interpY = ((float)f.y + peakY) * (float)skip;
            float interpS = (float)levelSize + peakS * (float)sizeStep;
            double scale = 1.2 * (double)interpS / 9.0;
            boolean white = this.computeLaplaceSign((int)((double)interpX + 0.5), (int)((double)interpY + 0.5), scale);
            ((ScalePoint)this.featuresAllScales.grow()).setTo(interpX, interpY, scale, white, intenF);
        }
    }

    public boolean computeLaplaceSign(int x, int y, double scale) {
        int s = (int)Math.ceil(scale);
        this.kerXX = DerivativeIntegralImage.kernelDerivXX((int)(9 * s), (IntegralKernel)this.kerXX);
        this.kerYY = DerivativeIntegralImage.kernelDerivYY((int)(9 * s), (IntegralKernel)this.kerYY);
        double lap = GIntegralImageOps.convolveSparse(this.integral, (IntegralKernel)this.kerXX, (int)x, (int)y);
        return (lap += GIntegralImageOps.convolveSparse(this.integral, (IntegralKernel)this.kerYY, (int)x, (int)y)) > 0.0;
    }

    protected static boolean checkMax(ImageBorder_F32 inten, float bestScore, int c_x, int c_y) {
        for (int y = c_y - 1; y <= c_y + 1; ++y) {
            for (int x = c_x - 1; x <= c_x + 1; ++x) {
                if (!(inten.get(x, y) >= bestScore)) continue;
                return false;
            }
        }
        return true;
    }

    public static float polyPeak(float lower, float middle, float upper) {
        float a = 0.5f * lower - middle + 0.5f * upper;
        float b = 0.5f * upper - 0.5f * lower;
        if (a == 0.0f) {
            return 0.0f;
        }
        return -b / (2.0f * a);
    }

    public static double polyPeak(double lower, double middle, double upper) {
        double a = 0.5 * lower - middle + 0.5 * upper;
        double b = 0.5 * upper - 0.5 * lower;
        if (a == 0.0) {
            return 0.0;
        }
        return -b / (2.0 * a);
    }

    public static double polyPeak(double lower, double middle, double upper, double lowerVal, double middleVal, double upperVal) {
        double offset = FastHessianFeatureDetector.polyPeak(lower, middle, upper);
        if (offset < 0.0) {
            return -lowerVal * offset + (1.0 + offset) * middle;
        }
        return upperVal * offset + offset * middle;
    }

    public List<ScalePoint> getFoundFeatures() {
        return (this.maxFeaturesAll <= 0 ? this.featuresAllScales : this.selectedAll).toList();
    }

    public int getSmallestWidth() {
        return this.initialSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getScaleStepSize() {
        return this.scaleStepSize;
    }

    public int getNumberOfOctaves() {
        return this.numberOfOctaves;
    }
}

