/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.transform.ii.DerivativeIntegralImage;
import boofcv.alg.transform.ii.IntegralImageOps;
import boofcv.alg.transform.ii.IntegralKernel;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;

public class ImplIntegralImageFeatureIntensity {
    public static void hessianNaive(GrayF32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        IntegralKernel kerXX = DerivativeIntegralImage.kernelDerivXX((int)size, null);
        IntegralKernel kerYY = DerivativeIntegralImage.kernelDerivYY((int)size, null);
        IntegralKernel kerXY = DerivativeIntegralImage.kernelDerivXY((int)size, null);
        float norm = 1.0f / (float)(size * size);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int xx = x * skip;
                int yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
    }

    public static void hessianBorder(GrayF32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        IntegralKernel kerXX = DerivativeIntegralImage.kernelDerivXX((int)size, null);
        IntegralKernel kerYY = DerivativeIntegralImage.kernelDerivYY((int)size, null);
        IntegralKernel kerXY = DerivativeIntegralImage.kernelDerivXY((int)size, null);
        int radiusFeature = size / 2;
        int borderOrig = radiusFeature + 1 + skip - (radiusFeature + 1) % skip;
        int border = borderOrig / skip;
        float norm = 1.0f / (float)(size * size);
        for (int y = 0; y < h; ++y) {
            int xx;
            int x;
            int yy = y * skip;
            for (x = 0; x < border; ++x) {
                xx = x * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
            for (x = w - border; x < w; ++x) {
                xx = x * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
        for (int x = border; x < w - border; ++x) {
            int yy;
            int y;
            int xx = x * skip;
            for (y = 0; y < border; ++y) {
                yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
            for (y = h - border; y < h; ++y) {
                yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
    }

    public static void computeHessian(GrayF32 integral, GrayF32 intensity, IntegralKernel kerXX, IntegralKernel kerYY, IntegralKernel kerXY, float norm, int y, int yy, int x, int xx) {
        float Dxx = IntegralImageOps.convolveSparse((GrayF32)integral, (IntegralKernel)kerXX, (int)xx, (int)yy);
        float Dyy = IntegralImageOps.convolveSparse((GrayF32)integral, (IntegralKernel)kerYY, (int)xx, (int)yy);
        float Dxy = IntegralImageOps.convolveSparse((GrayF32)integral, (IntegralKernel)kerXY, (int)xx, (int)yy);
        float det = (Dxx *= norm) * (Dyy *= norm) - 0.81f * (Dxy *= norm) * Dxy;
        intensity.set(x, y, det);
    }

    public static void hessianInner(GrayF32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        float norm = 1.0f / (float)(size * size);
        int blockSmall = size / 3;
        int blockLarge = size - blockSmall - 1;
        int radiusFeature = size / 2;
        int radiusSkinny = blockLarge / 2;
        int blockW2 = 2 * blockSmall;
        int blockW3 = 3 * blockSmall;
        int rowOff1 = blockSmall * integral.stride;
        int rowOff2 = 2 * rowOff1;
        int rowOff3 = 3 * rowOff1;
        int borderOrig = radiusFeature + 1 + skip - (radiusFeature + 1) % skip;
        int border = borderOrig / skip;
        int lostPixel = borderOrig - radiusFeature - 1;
        int endY = h - border;
        int endX = w - border;
        for (int y = border; y < endY; ++y) {
            int yy = y * skip;
            int indexDst = intensity.startIndex + y * intensity.stride + border;
            int indexTop = integral.startIndex + (yy - radiusSkinny - 1) * integral.stride + lostPixel;
            int indexBottom = indexTop + blockLarge * integral.stride;
            int indexL = integral.startIndex + (yy - radiusFeature - 1) * integral.stride + radiusFeature - radiusSkinny + lostPixel;
            int indexR = indexL + blockLarge;
            int indexY1 = integral.startIndex + (yy - blockSmall - 1) * integral.stride + radiusFeature - blockSmall + lostPixel;
            int indexY2 = indexY1 + blockSmall * integral.stride;
            int indexY3 = indexY2 + integral.stride;
            int indexY4 = indexY3 + blockSmall * integral.stride;
            int x = border;
            while (x < endX) {
                float Dxx = integral.data[indexBottom + blockW3] - integral.data[indexTop + blockW3] - integral.data[indexBottom] + integral.data[indexTop];
                Dxx -= 3.0f * (integral.data[indexBottom + blockW2] - integral.data[indexTop + blockW2] - integral.data[indexBottom + blockSmall] + integral.data[indexTop + blockSmall]);
                float Dyy = integral.data[indexR + rowOff3] - integral.data[indexL + rowOff3] - integral.data[indexR] + integral.data[indexL];
                Dyy -= 3.0f * (integral.data[indexR + rowOff2] - integral.data[indexL + rowOff2] - integral.data[indexR + rowOff1] + integral.data[indexL + rowOff1]);
                int x3 = blockSmall + 1;
                int x4 = x3 + blockSmall;
                float Dxy = integral.data[indexY2 + blockSmall] - integral.data[indexY1 + blockSmall] - integral.data[indexY2] + integral.data[indexY1];
                Dxy -= integral.data[indexY2 + x4] - integral.data[indexY1 + x4] - integral.data[indexY2 + x3] + integral.data[indexY1 + x3];
                Dxy += integral.data[indexY4 + x4] - integral.data[indexY3 + x4] - integral.data[indexY4 + x3] + integral.data[indexY3 + x3];
                Dxy -= integral.data[indexY4 + blockSmall] - integral.data[indexY3 + blockSmall] - integral.data[indexY4] + integral.data[indexY3];
                intensity.data[indexDst] = (Dxx *= norm) * (Dyy *= norm) - 0.81f * (Dxy *= norm) * Dxy;
                indexTop += skip;
                indexBottom += skip;
                indexL += skip;
                indexR += skip;
                indexY1 += skip;
                indexY2 += skip;
                indexY3 += skip;
                indexY4 += skip;
                ++x;
                ++indexDst;
            }
        }
    }

    public static void hessianNaive(GrayS32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        IntegralKernel kerXX = DerivativeIntegralImage.kernelDerivXX((int)size, null);
        IntegralKernel kerYY = DerivativeIntegralImage.kernelDerivYY((int)size, null);
        IntegralKernel kerXY = DerivativeIntegralImage.kernelDerivXY((int)size, null);
        float norm = 1.0f / (float)(size * size);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int xx = x * skip;
                int yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
    }

    public static void hessianBorder(GrayS32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        IntegralKernel kerXX = DerivativeIntegralImage.kernelDerivXX((int)size, null);
        IntegralKernel kerYY = DerivativeIntegralImage.kernelDerivYY((int)size, null);
        IntegralKernel kerXY = DerivativeIntegralImage.kernelDerivXY((int)size, null);
        int radiusFeature = size / 2;
        int borderOrig = radiusFeature + 1 + skip - (radiusFeature + 1) % skip;
        int border = borderOrig / skip;
        float norm = 1.0f / (float)(size * size);
        for (int y = 0; y < h; ++y) {
            int xx;
            int x;
            int yy = y * skip;
            for (x = 0; x < border; ++x) {
                xx = x * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
            for (x = w - border; x < w; ++x) {
                xx = x * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
        for (int x = border; x < w - border; ++x) {
            int yy;
            int y;
            int xx = x * skip;
            for (y = 0; y < border; ++y) {
                yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
            for (y = h - border; y < h; ++y) {
                yy = y * skip;
                ImplIntegralImageFeatureIntensity.computeHessian(integral, intensity, kerXX, kerYY, kerXY, norm, y, yy, x, xx);
            }
        }
    }

    public static void computeHessian(GrayS32 integral, GrayF32 intensity, IntegralKernel kerXX, IntegralKernel kerYY, IntegralKernel kerXY, float norm, int y, int yy, int x, int xx) {
        float Dxx = IntegralImageOps.convolveSparse((GrayS32)integral, (IntegralKernel)kerXX, (int)xx, (int)yy);
        float Dyy = IntegralImageOps.convolveSparse((GrayS32)integral, (IntegralKernel)kerYY, (int)xx, (int)yy);
        float Dxy = IntegralImageOps.convolveSparse((GrayS32)integral, (IntegralKernel)kerXY, (int)xx, (int)yy);
        float det = (Dxx *= norm) * (Dyy *= norm) - 0.81f * (Dxy *= norm) * Dxy;
        intensity.set(x, y, det);
    }

    public static void hessianInner(GrayS32 integral, int skip, int size, GrayF32 intensity) {
        int w = intensity.width;
        int h = intensity.height;
        float norm = 1.0f / (float)(size * size);
        int blockSmall = size / 3;
        int blockLarge = size - blockSmall - 1;
        int radiusFeature = size / 2;
        int radiusSkinny = blockLarge / 2;
        int blockW2 = 2 * blockSmall;
        int blockW3 = 3 * blockSmall;
        int rowOff1 = blockSmall * integral.stride;
        int rowOff2 = 2 * rowOff1;
        int rowOff3 = 3 * rowOff1;
        int borderOrig = radiusFeature + 1 + skip - (radiusFeature + 1) % skip;
        int border = borderOrig / skip;
        int lostPixel = borderOrig - radiusFeature - 1;
        int endY = h - border;
        int endX = w - border;
        for (int y = border; y < endY; ++y) {
            int yy = y * skip;
            int indexDst = intensity.startIndex + y * intensity.stride + border;
            int indexTop = integral.startIndex + (yy - radiusSkinny - 1) * integral.stride + lostPixel;
            int indexBottom = indexTop + blockLarge * integral.stride;
            int indexL = integral.startIndex + (yy - radiusFeature - 1) * integral.stride + radiusFeature - radiusSkinny + lostPixel;
            int indexR = indexL + blockLarge;
            int indexY1 = integral.startIndex + (yy - blockSmall - 1) * integral.stride + radiusFeature - blockSmall + lostPixel;
            int indexY2 = indexY1 + blockSmall * integral.stride;
            int indexY3 = indexY2 + integral.stride;
            int indexY4 = indexY3 + blockSmall * integral.stride;
            int x = border;
            while (x < endX) {
                float Dxx = integral.data[indexBottom + blockW3] - integral.data[indexTop + blockW3] - integral.data[indexBottom] + integral.data[indexTop];
                Dxx -= (float)(3 * (integral.data[indexBottom + blockW2] - integral.data[indexTop + blockW2] - integral.data[indexBottom + blockSmall] + integral.data[indexTop + blockSmall]));
                float Dyy = integral.data[indexR + rowOff3] - integral.data[indexL + rowOff3] - integral.data[indexR] + integral.data[indexL];
                Dyy -= (float)(3 * (integral.data[indexR + rowOff2] - integral.data[indexL + rowOff2] - integral.data[indexR + rowOff1] + integral.data[indexL + rowOff1]));
                int x3 = blockSmall + 1;
                int x4 = x3 + blockSmall;
                float Dxy = integral.data[indexY2 + blockSmall] - integral.data[indexY1 + blockSmall] - integral.data[indexY2] + integral.data[indexY1];
                Dxy -= (float)(integral.data[indexY2 + x4] - integral.data[indexY1 + x4] - integral.data[indexY2 + x3] + integral.data[indexY1 + x3]);
                Dxy += (float)(integral.data[indexY4 + x4] - integral.data[indexY3 + x4] - integral.data[indexY4 + x3] + integral.data[indexY3 + x3]);
                Dxy -= (float)(integral.data[indexY4 + blockSmall] - integral.data[indexY3 + blockSmall] - integral.data[indexY4] + integral.data[indexY3]);
                intensity.data[indexDst] = (Dxx *= norm) * (Dyy *= norm) - 0.81f * (Dxy *= norm) * Dxy;
                indexTop += skip;
                indexBottom += skip;
                indexL += skip;
                indexR += skip;
                indexY1 += skip;
                indexY2 += skip;
                indexY3 += skip;
                indexY4 += skip;
                ++x;
                ++indexDst;
            }
        }
    }
}

