/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.FastCornerInterface;
import boofcv.struct.image.GrayF32;

public abstract class ImplFastHelper_F32
implements FastCornerInterface<GrayF32> {
    protected float tol;
    protected int[] offsets;
    protected float[] data;
    float centerValue;
    float lower;
    float upper;

    protected ImplFastHelper_F32(float pixelTol) {
        this.tol = pixelTol;
    }

    @Override
    public void setImage(GrayF32 image, int[] offsets) {
        this.data = image.data;
        this.offsets = offsets;
    }

    @Override
    public float scoreLower(int index) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            float v = this.data[index + this.offsets[i]];
            if (!(v < this.lower)) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total - this.centerValue * (float)count;
    }

    @Override
    public float scoreUpper(int index) {
        float total = 0.0f;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            float v = this.data[index + this.offsets[i]];
            if (!(v > this.upper)) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total - this.centerValue * (float)count;
    }

    @Override
    public void setThreshold(int index) {
        this.centerValue = this.data[index];
        this.lower = this.centerValue - this.tol;
        this.upper = this.centerValue + this.tol;
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }
}

