/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;

public class ImplEdgeNonMaxSuppression {
    public static void inner4(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        for (int y = 1; y < h; ++y) {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexD = direction.startIndex + y * direction.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dy;
                int dx;
                byte dir = direction.data[indexD];
                if (dir == 0) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexD;
                ++indexO;
            }
        }
    }

    public static void naive4(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value((GrayF32)_intensity, (float)0.0f);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int dy;
                int dx;
                int dir = direction.get(x, y);
                if (dir == 0) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float left = intensity.get(x - dx, y - dy);
                float middle = intensity.get(x, y);
                float right = intensity.get(x + dx, y + dy);
                if (left > middle || right > middle) {
                    output.set(x, y, 0.0f);
                    continue;
                }
                output.set(x, y, middle);
            }
        }
    }

    public static void border4(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        float right;
        float middle;
        float left;
        int dy;
        int dx;
        int dir;
        int x;
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value((GrayF32)_intensity, (float)0.0f);
        for (x = 0; x < w; ++x) {
            dir = direction.get(x, 0);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(x - dx, -dy);
            middle = intensity.get(x, 0);
            right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
                continue;
            }
            output.set(x, 0, middle);
        }
        for (x = 0; x < w; ++x) {
            dir = direction.get(x, h);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(x - dx, h - dy);
            middle = intensity.get(x, h);
            right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
                continue;
            }
            output.set(x, h, middle);
        }
        for (int y = 1; y < h; ++y) {
            dir = direction.get(0, y);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(-dx, y - dy);
            middle = intensity.get(0, y);
            right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
                continue;
            }
            output.set(0, y, middle);
        }
        int _w = w - 1;
        for (int y = 1; y < h; ++y) {
            int dy2;
            int dx2;
            int dir2 = direction.get(_w, y);
            if (dir2 == 0) {
                dx2 = 1;
                dy2 = 0;
            } else if (dir2 == 1) {
                dx2 = 1;
                dy2 = 1;
            } else if (dir2 == 2) {
                dx2 = 0;
                dy2 = 1;
            } else {
                dx2 = 1;
                dy2 = -1;
            }
            float left2 = intensity.get(_w - dx2, y - dy2);
            float middle2 = intensity.get(_w, y);
            float right2 = intensity.get(_w + dx2, y + dy2);
            if (left2 > middle2 || right2 > middle2) {
                output.set(_w, y, 0.0f);
                continue;
            }
            output.set(_w, y, middle2);
        }
    }

    public static void inner8(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        for (int y = 1; y < h; ++y) {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexD = direction.startIndex + y * direction.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dy;
                int dx;
                byte dir = direction.data[indexD];
                if (dir == 0 || dir == 4) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1 || dir == -3) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2 || dir == -2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexD;
                ++indexO;
            }
        }
    }

    public static void naive8(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value((GrayF32)_intensity, (float)0.0f);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int dy;
                int dx;
                int dir = direction.get(x, y);
                if (dir == 0 || dir == 4) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1 || dir == -3) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2 || dir == -2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float left = intensity.get(x - dx, y - dy);
                float middle = intensity.get(x, y);
                float right = intensity.get(x + dx, y + dy);
                if (left > middle || right > middle) {
                    output.set(x, y, 0.0f);
                    continue;
                }
                output.set(x, y, middle);
            }
        }
    }

    public static void border8(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        float right;
        float middle;
        float left;
        int dy;
        int dx;
        int dir;
        int x;
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value((GrayF32)_intensity, (float)0.0f);
        for (x = 0; x < w; ++x) {
            dir = direction.get(x, 0);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(x - dx, -dy);
            middle = intensity.get(x, 0);
            right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
                continue;
            }
            output.set(x, 0, middle);
        }
        for (x = 0; x < w; ++x) {
            dir = direction.get(x, h);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(x - dx, h - dy);
            middle = intensity.get(x, h);
            right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
                continue;
            }
            output.set(x, h, middle);
        }
        for (int y = 1; y < h; ++y) {
            dir = direction.get(0, y);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            left = intensity.get(-dx, y - dy);
            middle = intensity.get(0, y);
            right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
                continue;
            }
            output.set(0, y, middle);
        }
        int _w = w - 1;
        for (int y = 1; y < h; ++y) {
            int dy2;
            int dx2;
            int dir2 = direction.get(_w, y);
            if (dir2 == 0 || dir2 == 4) {
                dx2 = 1;
                dy2 = 0;
            } else if (dir2 == 1 || dir2 == -3) {
                dx2 = 1;
                dy2 = 1;
            } else if (dir2 == 2 || dir2 == -2) {
                dx2 = 0;
                dy2 = 1;
            } else {
                dx2 = 1;
                dy2 = -1;
            }
            float left2 = intensity.get(_w - dx2, y - dy2);
            float middle2 = intensity.get(_w, y);
            float right2 = intensity.get(_w + dx2, y + dy2);
            if (left2 > middle2 || right2 > middle2) {
                output.set(_w, y, 0.0f);
                continue;
            }
            output.set(_w, y, middle2);
        }
    }
}

