/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;

public class PropertiesManager {
    public static void saveProperties(Properties properties, String pathName) throws IOException {
        PropertiesManager.saveProperties(properties, new File(pathName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            properties.store(outputStream, "Storing modified properties");
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(URL url) throws IOException {
        InputStreamReader reader = new InputStreamReader(url.openStream());
        try {
            Properties properties = PropertiesManager.getProperties(reader);
            return properties;
        }
        finally {
            reader.close();
        }
    }

    public static Properties getProperties(String fileName) throws IOException {
        return PropertiesManager.getProperties(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(File file) throws IOException {
        FileReader reader = new FileReader(file);
        try {
            Properties properties = PropertiesManager.getProperties(reader);
            return properties;
        }
        finally {
            reader.close();
        }
    }

    private static Properties getProperties(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePropertiesToXML(Properties properties, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            properties.storeToXML((OutputStream)outputStream, "Storing modified properties", "UTF-8");
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromXML(File file) throws IOException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            properties.loadFromXML(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            fileInputStream.close();
        }
    }
}

