/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.parameter.ParameterDefinition;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.internal.ProcessDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

public class DesignProcessDefinitionImpl
extends ProcessDefinitionImpl
implements DesignProcessDefinition {
    private static final long serialVersionUID = -4719128363958199300L;
    private String displayName;
    private String displayDescription;
    private final Set<ParameterDefinition> parameters = new HashSet<ParameterDefinition>();
    private final List<ActorDefinition> actors = new ArrayList<ActorDefinition>();
    private ActorDefinition actorInitiator;
    private org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition flowElementContainer;
    private String stringIndexLabel1;
    private String stringIndexLabel2;
    private String stringIndexLabel3;
    private String stringIndexLabel4;
    private String stringIndexLabel5;
    private Expression stringIndexValue1;
    private Expression stringIndexValue2;
    private Expression stringIndexValue3;
    private Expression stringIndexValue4;
    private Expression stringIndexValue5;

    public DesignProcessDefinitionImpl(String name, String version) {
        super(name, version);
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setDisplayDescription(String description) {
        this.displayDescription = description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    @Override
    public List<ActorDefinition> getActorsList() {
        return this.actors;
    }

    @Override
    @Deprecated
    public Set<ActorDefinition> getActors() {
        return new HashSet<ActorDefinition>(this.actors);
    }

    @Override
    public Set<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void addParameter(ParameterDefinition parameter) {
        this.parameters.add(parameter);
    }

    public void addActor(ActorDefinition actor) {
        this.actors.add(actor);
    }

    @Override
    public ActorDefinition getActorInitiator() {
        return this.actorInitiator;
    }

    public void setActorInitiator(ActorDefinition actorInitiator) {
        this.actorInitiator = actorInitiator;
    }

    @Override
    public org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition getProcessContainer() {
        return this.flowElementContainer;
    }

    public void setProcessContainer(org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition processContainer) {
        this.flowElementContainer = processContainer;
    }

    @Override
    public FlowElementContainerDefinition getFlowElementContainer() {
        return this.flowElementContainer;
    }

    @Override
    public String getStringIndexLabel(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexLabel1;
            }
            case 2: {
                return this.stringIndexLabel2;
            }
            case 3: {
                return this.stringIndexLabel3;
            }
            case 4: {
                return this.stringIndexLabel4;
            }
            case 5: {
                return this.stringIndexLabel5;
            }
        }
        throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
    }

    @Override
    public Expression getStringIndexValue(int index) {
        switch (index) {
            case 1: {
                return this.stringIndexValue1;
            }
            case 2: {
                return this.stringIndexValue2;
            }
            case 3: {
                return this.stringIndexValue3;
            }
            case 4: {
                return this.stringIndexValue4;
            }
            case 5: {
                return this.stringIndexValue5;
            }
        }
        throw new IndexOutOfBoundsException("string index value must be between 1 and 5 (included)");
    }

    public ActorDefinition getActor(String actorName) {
        Iterator<ActorDefinition> iterator = this.actors.iterator();
        ActorDefinition actorDefinition = null;
        boolean found = false;
        while (!found && iterator.hasNext()) {
            ActorDefinition next = iterator.next();
            if (!next.getName().equals(actorName)) continue;
            found = true;
            actorDefinition = next;
        }
        return actorDefinition;
    }

    public void setStringIndex(int index, String label, Expression initialValue) {
        switch (index) {
            case 1: {
                this.stringIndexLabel1 = label;
                this.stringIndexValue1 = initialValue;
                break;
            }
            case 2: {
                this.stringIndexLabel2 = label;
                this.stringIndexValue2 = initialValue;
                break;
            }
            case 3: {
                this.stringIndexLabel3 = label;
                this.stringIndexValue3 = initialValue;
                break;
            }
            case 4: {
                this.stringIndexLabel4 = label;
                this.stringIndexValue4 = initialValue;
                break;
            }
            case 5: {
                this.stringIndexLabel5 = label;
                this.stringIndexValue5 = initialValue;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("string index label must be between 1 and 5 (included)");
            }
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.displayName).append((Object)this.displayDescription).append(this.parameters).append(this.actors).append((Object)this.actorInitiator).append((Object)this.flowElementContainer).append((Object)this.stringIndexLabel1).append((Object)this.stringIndexLabel2).append((Object)this.stringIndexLabel3).append((Object)this.stringIndexLabel4).append((Object)this.stringIndexLabel5).append((Object)this.stringIndexValue1).append((Object)this.stringIndexValue2).append((Object)this.stringIndexValue3).append((Object)this.stringIndexValue4).append((Object)this.stringIndexValue5).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DesignProcessDefinitionImpl other = (DesignProcessDefinitionImpl)obj;
        return new EqualsBuilder().append((Object)this.displayName, (Object)other.displayName).append((Object)this.displayDescription, (Object)other.displayDescription).append(this.parameters, other.parameters).append(this.actors, other.actors).append((Object)this.actorInitiator, (Object)other.actorInitiator).append((Object)this.flowElementContainer, (Object)other.flowElementContainer).append((Object)this.stringIndexLabel1, (Object)other.stringIndexLabel1).append((Object)this.stringIndexLabel2, (Object)other.stringIndexLabel2).append((Object)this.stringIndexLabel3, (Object)other.stringIndexLabel3).append((Object)this.stringIndexLabel4, (Object)other.stringIndexLabel4).append((Object)this.stringIndexLabel5, (Object)other.stringIndexLabel5).append((Object)this.stringIndexValue1, (Object)other.stringIndexValue1).append((Object)this.stringIndexValue2, (Object)other.stringIndexValue2).append((Object)this.stringIndexValue3, (Object)other.stringIndexValue3).append((Object)this.stringIndexValue4, (Object)other.stringIndexValue4).append((Object)this.stringIndexValue5, (Object)other.stringIndexValue5).build();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.getName()).append((Object)this.getVersion()).append((Object)this.displayName).append((Object)this.displayDescription).append(this.parameters).append(this.actors).append((Object)this.actorInitiator).append((Object)this.flowElementContainer).append((Object)this.stringIndexLabel1).append((Object)this.stringIndexLabel2).append((Object)this.stringIndexLabel3).append((Object)this.stringIndexLabel4).append((Object)this.stringIndexLabel5).append((Object)this.stringIndexValue1).append((Object)this.stringIndexValue2).append((Object)this.stringIndexValue3).append((Object)this.stringIndexValue4).append((Object)this.stringIndexValue5).build();
    }
}

