/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.process.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.bpm.actor.ActorDefinition;
import org.bonitasoft.engine.bpm.businessdata.BusinessDataDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.document.DocumentDefinition;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.AutomaticTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.BoundaryEventDefinition;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CatchMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.EndEventDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowElementContainerDefinition;
import org.bonitasoft.engine.bpm.flownode.FlowNodeDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayDefinition;
import org.bonitasoft.engine.bpm.flownode.GatewayType;
import org.bonitasoft.engine.bpm.flownode.ReceiveTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.SendTaskDefinition;
import org.bonitasoft.engine.bpm.flownode.StartEventDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.TimerType;
import org.bonitasoft.engine.bpm.flownode.TransitionDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.FlowElementContainerDefinitionImpl;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.bpm.process.DesignProcessDefinition;
import org.bonitasoft.engine.bpm.process.InvalidProcessDefinitionException;
import org.bonitasoft.engine.bpm.process.SubProcessDefinition;
import org.bonitasoft.engine.bpm.process.impl.ActorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.AutomaticTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.CallActivityBuilder;
import org.bonitasoft.engine.bpm.process.impl.ConnectorDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ContainerBuilder;
import org.bonitasoft.engine.bpm.process.impl.DataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DescriptionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DocumentDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.DocumentListDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.EndEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.GatewayDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateCatchEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.IntermediateThrowEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ManualTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.ReceiveTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SendTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.StartEventDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.SubProcessActivityDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.TextDataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.TransitionDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.UserTaskDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.XMLDataDefinitionBuilder;
import org.bonitasoft.engine.bpm.process.impl.internal.DesignProcessDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperatorType;

public class ProcessDefinitionBuilder
implements DescriptionBuilder,
ContainerBuilder {
    private static final String DOUBLE_HYPHEN = "--";
    private static final int MAX_CHARACTER_URL = 1024;
    private static final int MAX_CHARACTER_FILENAME = 255;
    protected DesignProcessDefinitionImpl process;
    private List<String> designErrors;

    public ProcessDefinitionBuilder createNewInstance(String name, String version) {
        this.designErrors = new ArrayList<String>(5);
        if (name == null || name.isEmpty()) {
            this.designErrors.add("name of the process is null or empty");
        }
        this.process = new DesignProcessDefinitionImpl(name, version);
        this.process.setProcessContainer(new FlowElementContainerDefinitionImpl());
        return this;
    }

    public DesignProcessDefinition done() throws InvalidProcessDefinitionException {
        this.validateProcess();
        if (!this.designErrors.isEmpty()) {
            throw new InvalidProcessDefinitionException(this.designErrors);
        }
        return this.process;
    }

    private void validateProcess() {
        org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition flowElementContainer = this.process.getProcessContainer();
        ArrayList<String> names = new ArrayList<String>();
        this.validateFlowNodeUnique(flowElementContainer, names);
        this.validateProcessAttributes();
        this.validateProcess(flowElementContainer, true);
        this.validateEventsSubProcess();
        this.validateActors();
        this.validateBusinessData();
    }

    protected void validateBusinessData() {
        org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition processContainer = this.process.getProcessContainer();
        List<BusinessDataDefinition> businessDataDefinitions = processContainer.getBusinessDataDefinitions();
        if (!businessDataDefinitions.isEmpty()) {
            this.addError("It is not possible to use business data in the process");
        }
        for (ActivityDefinition activity : processContainer.getActivities()) {
            List<BusinessDataDefinition> dataDefinitions = activity.getBusinessDataDefinitions();
            if (dataDefinitions.isEmpty()) continue;
            this.addError("It is not possible to use business data in the activity " + activity.getName());
        }
    }

    private void validateConnectors(List<ConnectorDefinition> connectorDefinitions) {
        ArrayList<String> names = new ArrayList<String>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (names.contains(connectorDefinition.getName())) {
                this.designErrors.add("More than one connector are named '" + connectorDefinition.getName() + "'. All names must be unique.");
                continue;
            }
            names.add(connectorDefinition.getName());
        }
    }

    private void validateActors() {
        String actorInitiatorName;
        ActorDefinition actor;
        ActorDefinition actorInitiator = this.process.getActorInitiator();
        if (actorInitiator != null && (actor = this.process.getActor(actorInitiatorName = actorInitiator.getName())) == null) {
            this.designErrors.add("No actor is found for initiator '" + actorInitiatorName + "'.");
        }
    }

    private void validateProcess(FlowElementContainerDefinition flowElementContainer, boolean isRootContainer) {
        this.validateConnectors(flowElementContainer.getConnectors());
        this.validateGateways(flowElementContainer);
        this.validateDocuments(flowElementContainer);
        this.validateMultiInstances(flowElementContainer);
        this.validateEvents(flowElementContainer, isRootContainer);
        this.validateActivities(flowElementContainer);
    }

    private void validateFlowNodeUnique(FlowElementContainerDefinition flowElementContainer, List<String> names) {
        this.validateFlowNodeName(names, flowElementContainer.getActivities());
        this.validateFlowNodeName(names, flowElementContainer.getEndEvents());
        this.validateFlowNodeName(names, flowElementContainer.getGatewaysList());
        this.validateFlowNodeName(names, flowElementContainer.getIntermediateCatchEvents());
        this.validateFlowNodeName(names, flowElementContainer.getIntermediateThrowEvents());
        this.validateFlowNodeName(names, flowElementContainer.getStartEvents());
    }

    private void validateFlowNodeName(List<String> names, Collection<? extends FlowNodeDefinition> flowNodes) {
        for (FlowNodeDefinition flowNodeDefinition : flowNodes) {
            this.validateConnectors(flowNodeDefinition.getConnectors());
            if (names.contains(flowNodeDefinition.getName())) {
                this.designErrors.add("More than one elements are named '" + flowNodeDefinition.getName() + "'. All names must be unique.");
            } else {
                names.add(flowNodeDefinition.getName());
            }
            if (!(flowNodeDefinition instanceof SubProcessDefinition)) continue;
            SubProcessDefinition subProcess = (SubProcessDefinition)flowNodeDefinition;
            this.validateFlowNodeUnique(subProcess.getSubProcessContainer(), names);
        }
    }

    private void validateProcessAttributes() {
        if (this.process.getName() != null && this.process.getName().indexOf(DOUBLE_HYPHEN) != -1) {
            this.addError("'--' is fordidden in the process name");
        }
    }

    private void validateActivities(FlowElementContainerDefinition processContainer) {
        for (ActivityDefinition activity : processContainer.getActivities()) {
            if (activity instanceof CallActivityDefinition && ((CallActivityDefinition)activity).getCallableElement() == null) {
                this.addError("The call activity " + activity.getName() + " has a null callable element");
            }
            if (activity instanceof SendTaskDefinition && ((SendTaskDefinition)activity).getMessageTrigger().getTargetProcess() == null) {
                this.addError("The send task " + activity.getName() + " hasn't target");
            }
            List<Operation> operations = activity.getOperations();
            HashMap<String, Boolean> leftOperandUpdates = new HashMap<String, Boolean>();
            for (Operation operation : operations) {
                LeftOperand leftOperand = operation.getLeftOperand();
                Boolean update = (Boolean)leftOperandUpdates.get(leftOperand.getName());
                Boolean updateOperator = operation.getType() != OperatorType.DELETION;
                if (update == null) {
                    leftOperandUpdates.put(leftOperand.getName(), updateOperator);
                    continue;
                }
                if (!update.booleanValue() || updateOperator.booleanValue()) continue;
                this.addError("In activity " + activity.getName() + ". It is not possible to modify and delete the leftOperand " + leftOperand.getName() + " through the same activty");
            }
        }
    }

    private void validateGateways(FlowElementContainerDefinition processContainer) {
        for (GatewayDefinition gateway : processContainer.getGatewaysList()) {
            for (TransitionDefinition transition : gateway.getOutgoingTransitions()) {
                switch (gateway.getGatewayType()) {
                    case PARALLEL: {
                        if (transition.getCondition() == null) break;
                        this.designErrors.add("The parallel gateway can't have conditional outgoing transitions : " + gateway);
                        break;
                    }
                }
            }
        }
    }

    private void validateEventsSubProcess() {
        org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition processContainer = this.process.getProcessContainer();
        for (ActivityDefinition activity : processContainer.getActivities()) {
            if (!(activity instanceof SubProcessDefinition)) continue;
            org.bonitasoft.engine.bpm.flownode.impl.FlowElementContainerDefinition subProcessContainer = ((SubProcessDefinition)activity).getSubProcessContainer();
            if (((SubProcessDefinition)activity).isTriggeredByEvent()) {
                if (subProcessContainer.getStartEvents().size() != 1) {
                    this.designErrors.add("An event sub process must have one and only one start events, but " + subProcessContainer.getStartEvents().size() + " were found : " + activity);
                }
                if (!subProcessContainer.getStartEvents().isEmpty() && subProcessContainer.getStartEvents().get(0).getEventTriggers().isEmpty()) {
                    this.designErrors.add("The event sub process have no start event with a not NONE trigger : " + activity);
                }
                if (activity.getIncomingTransitions().size() > 0) {
                    this.designErrors.add("An event sub process cannot have incoming transitions : " + activity);
                }
                if (activity.getOutgoingTransitions().size() > 0) {
                    this.designErrors.add("An event sub process cannot have outgoing transitions : " + activity);
                }
            }
            this.validateProcess(subProcessContainer, false);
        }
    }

    private void validateEvents(FlowElementContainerDefinition flowElementContainer, boolean isRootContainer) {
        this.validateStartEvents(flowElementContainer, isRootContainer);
        this.validateEndEvents(flowElementContainer);
        this.validateBoundaryEvents(flowElementContainer);
    }

    private void validateEndEvents(FlowElementContainerDefinition processContainer) {
        for (EndEventDefinition endEvent : processContainer.getEndEvents()) {
            if (endEvent.getOutgoingTransitions().isEmpty()) continue;
            this.designErrors.add("An end event can't have outgoing transitions: on end event" + endEvent);
        }
    }

    private void validateStartEvents(FlowElementContainerDefinition processContainer, boolean isRootContainer) {
        for (StartEventDefinition startEvent : processContainer.getStartEvents()) {
            if (!startEvent.getIncomingTransitions().isEmpty()) {
                this.designErrors.add("A start event can't have incoming transitions: on start event" + startEvent);
            }
            this.validateMessageStartEvent(startEvent, isRootContainer);
        }
    }

    private void validateMessageStartEvent(StartEventDefinition startEvent, boolean isRootContainer) {
        if (isRootContainer) {
            List<CatchMessageEventTriggerDefinition> messageEventTriggers = startEvent.getMessageEventTriggerDefinitions();
            for (CatchMessageEventTriggerDefinition messageEventTrigger : messageEventTriggers) {
                if (messageEventTrigger.getCorrelations().isEmpty()) continue;
                this.designErrors.add("A message start event cannot have correlations. On start event:" + startEvent);
            }
        }
    }

    private void validateMultiInstances(FlowElementContainerDefinition processContainer) {
        for (ActivityDefinition activity : processContainer.getActivities()) {
            if (activity.getLoopCharacteristics() == null || !(activity.getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics)) continue;
            MultiInstanceLoopCharacteristics loopCharacteristics = (MultiInstanceLoopCharacteristics)activity.getLoopCharacteristics();
            if (loopCharacteristics.getLoopDataInputRef() != null && !loopCharacteristics.getLoopDataInputRef().isEmpty() && (loopCharacteristics.getLoopDataInputRef() == null || loopCharacteristics.getLoopDataInputRef().isEmpty())) {
                this.designErrors.add("The multi instance has got a data input reference but does not have a loop data input on activity" + activity.getName());
            }
            if (loopCharacteristics.getDataOutputItemRef() == null || loopCharacteristics.getDataOutputItemRef().isEmpty() || loopCharacteristics.getLoopDataOutputRef() != null && !loopCharacteristics.getLoopDataOutputRef().isEmpty()) continue;
            this.designErrors.add("The multi instance has got a data output reference but does not have a loop data output on activity" + activity.getName());
        }
    }

    private void validateDocuments(FlowElementContainerDefinition processContainer) {
        for (DocumentDefinition document : processContainer.getDocumentDefinitions()) {
            if (document.getUrl() != null && document.getUrl().length() > 1024) {
                this.designErrors.add("An url can't have more than 1024 characters.");
            }
            if (document.getFileName() == null || document.getFileName().length() <= 255) continue;
            this.designErrors.add("A file name can't have more than 255 characters.");
        }
    }

    private void validateBoundaryEvents(FlowElementContainerDefinition processContainer) {
        for (ActivityDefinition activity : processContainer.getActivities()) {
            if (!activity.getBoundaryEventDefinitions().isEmpty() && !this.supportAllBoundaryEvents(activity)) {
                for (BoundaryEventDefinition boundary : activity.getBoundaryEventDefinitions()) {
                    if (!boundary.getTimerEventTriggerDefinitions().isEmpty()) {
                        this.designErrors.add("Timer boundary events are not supported in automatic, receive and send tasks: " + activity.getName());
                    }
                    if (!boundary.getSignalEventTriggerDefinitions().isEmpty()) {
                        this.designErrors.add("Signal boundary events are not supported in automatic, receive and send tasks: " + activity.getName());
                    }
                    if (boundary.getMessageEventTriggerDefinitions().isEmpty()) continue;
                    this.designErrors.add("Message boundary events are not supported in automatic, receive and send tasks: " + activity.getName());
                }
            }
            for (BoundaryEventDefinition boundaryEvent : activity.getBoundaryEventDefinitions()) {
                if (boundaryEvent.getOutgoingTransitions().isEmpty()) {
                    this.designErrors.add("A boundary event must have outgoing transitions: " + boundaryEvent.getName());
                } else {
                    this.validateBoundaryOutgoingTransitions(boundaryEvent);
                }
                if (!boundaryEvent.getIncomingTransitions().isEmpty()) {
                    this.designErrors.add("A boundary event must not have incoming transitions: " + boundaryEvent.getName());
                }
                if (boundaryEvent.getEventTriggers().isEmpty()) {
                    this.designErrors.add("A boundary event must have a trigger (it cannot be a NONE event): " + boundaryEvent.getName());
                }
                for (TimerEventTriggerDefinition timerTigger : boundaryEvent.getTimerEventTriggerDefinitions()) {
                    if (!TimerType.CYCLE.equals((Object)timerTigger.getTimerType())) continue;
                    this.designErrors.add("Invalid timer type in boundary event " + boundaryEvent.getName() + ": CYCLE is not supported for boundary events.");
                }
                this.validateNonInterruptingBoundaryEvent(boundaryEvent);
            }
        }
    }

    private boolean supportAllBoundaryEvents(ActivityDefinition activity) {
        return !(activity instanceof AutomaticTaskDefinition) && !(activity instanceof ReceiveTaskDefinition) && !(activity instanceof SendTaskDefinition);
    }

    private void validateNonInterruptingBoundaryEvent(BoundaryEventDefinition boundaryEvent) {
        if (!boundaryEvent.isInterrupting()) {
            if (!boundaryEvent.getSignalEventTriggerDefinitions().isEmpty()) {
                this.designErrors.add("Non-interrupting boundary events are not supported for SIGNAL events: " + boundaryEvent.getName());
            }
            if (!boundaryEvent.getMessageEventTriggerDefinitions().isEmpty()) {
                this.designErrors.add("Non-interrupting boundary events are not supported for MESSAGE events: " + boundaryEvent.getName());
            }
            if (!boundaryEvent.getErrorEventTriggerDefinitions().isEmpty()) {
                this.designErrors.add("An error event must be INTERRUPTING: " + boundaryEvent.getName());
            }
        }
    }

    private void validateBoundaryOutgoingTransitions(BoundaryEventDefinition boundaryEvent) {
        for (TransitionDefinition transition : boundaryEvent.getOutgoingTransitions()) {
            if (transition.getCondition() == null) continue;
            this.designErrors.add("A boundary event must have not inconditional transitions: " + transition.getSource() + "->" + transition.getTarget());
        }
    }

    protected void addError(String error) {
        this.designErrors.add(error);
    }

    @Override
    public DocumentDefinitionBuilder addDocumentDefinition(String name) {
        return new DocumentDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public DocumentListDefinitionBuilder addDocumentListDefinition(String name) {
        return new DocumentListDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public ProcessDefinitionBuilder addDescription(String description) {
        this.process.setDescription(description);
        return this;
    }

    public ProcessDefinitionBuilder addDisplayName(String name) {
        this.process.setDisplayName(name);
        return this;
    }

    public ProcessDefinitionBuilder addDisplayDescription(String description) {
        this.process.setDisplayDescription(description);
        return this;
    }

    void checkExpression(String context, Expression e) {
        if (e != null && (e.getContent() == null || e.getContent().isEmpty())) {
            this.addError("the expression " + e + " in " + context + " has got a null or empty content");
        }
    }

    public void checkName(String name) {
        if (!this.isValidName(name)) {
            this.addError(name + " is not a valid name (it musts respect rules for java identifiers)");
        }
    }

    private boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] c = name.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ConnectorDefinitionBuilder addConnector(String name, String connectorId, String version, ConnectorEvent activationEvent) {
        return new ConnectorDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, connectorId, version, activationEvent);
    }

    @Override
    public UserTaskDefinitionBuilder addUserTask(String taskName, String actorName) {
        return new UserTaskDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), taskName, actorName);
    }

    @Override
    public AutomaticTaskDefinitionBuilder addAutomaticTask(String taskName) {
        return new AutomaticTaskDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), taskName);
    }

    @Override
    public ReceiveTaskDefinitionBuilder addReceiveTask(String taskName, String messageName) {
        return new ReceiveTaskDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), taskName, messageName);
    }

    @Override
    public SendTaskDefinitionBuilder addSendTask(String taskName, String messageName, Expression targetProcess) {
        return new SendTaskDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), taskName, messageName, targetProcess);
    }

    @Override
    public ManualTaskDefinitionBuilder addManualTask(String name, String actorName) {
        return new ManualTaskDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, actorName);
    }

    @Override
    public TransitionDefinitionBuilder addTransition(String source, String target) {
        return new TransitionDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), source, target, false);
    }

    @Override
    public TransitionDefinitionBuilder addTransition(String source, String target, Expression condition) {
        return new TransitionDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), source, target, condition, false);
    }

    @Override
    public GatewayDefinitionBuilder addGateway(String name, GatewayType gatewayType) {
        return new GatewayDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, gatewayType);
    }

    @Override
    public StartEventDefinitionBuilder addStartEvent(String name) {
        return new StartEventDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public EndEventDefinitionBuilder addEndEvent(String name) {
        return new EndEventDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public IntermediateCatchEventDefinitionBuilder addIntermediateCatchEvent(String name) {
        return new IntermediateCatchEventDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public IntermediateThrowEventDefinitionBuilder addIntermediateThrowEvent(String name) {
        return new IntermediateThrowEventDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name);
    }

    @Override
    public CallActivityBuilder addCallActivity(String name, Expression callableElement, Expression callableElementVersion) {
        return new CallActivityBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, callableElement, callableElementVersion);
    }

    @Override
    public SubProcessActivityDefinitionBuilder addSubProcess(String name, boolean triggeredByEvent) {
        return new SubProcessActivityDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, triggeredByEvent);
    }

    @Override
    public DataDefinitionBuilder addIntegerData(String name, Expression defaultValue) {
        String className = Integer.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addLongData(String name, Expression defaultValue) {
        String className = Long.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addShortTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public TextDataDefinitionBuilder addLongTextData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new TextDataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue).isLongText();
    }

    @Override
    public DataDefinitionBuilder addDoubleData(String name, Expression defaultValue) {
        String className = Double.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addFloatData(String name, Expression defaultValue) {
        String className = Float.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addDateData(String name, Expression defaultValue) {
        String className = Date.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public XMLDataDefinitionBuilder addXMLData(String name, Expression defaultValue) {
        String className = String.class.getName();
        return new XMLDataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBlobData(String name, Expression defaultValue) {
        String className = Serializable.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addBooleanData(String name, Expression defaultValue) {
        String className = Boolean.class.getName();
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    @Override
    public DataDefinitionBuilder addData(String name, String className, Expression defaultValue) {
        return new DataDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), name, className, defaultValue);
    }

    public ActorDefinitionBuilder addActor(String actorName) {
        return new ActorDefinitionBuilder(this, this.process, actorName, false);
    }

    public ActorDefinitionBuilder addActor(String name, boolean initiator) {
        return new ActorDefinitionBuilder(this, this.process, name, initiator);
    }

    public ActorDefinitionBuilder setActorInitiator(String actorName) {
        return new ActorDefinitionBuilder(this, this.process, actorName, true);
    }

    @Override
    public TransitionDefinitionBuilder addDefaultTransition(String source, String target) {
        return new TransitionDefinitionBuilder(this, (FlowElementContainerDefinitionImpl)this.process.getProcessContainer(), source, target, null, true);
    }

    public DesignProcessDefinition getProcess() throws InvalidProcessDefinitionException {
        return this.done();
    }
}

