/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.ThrowMessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.MessageEventTriggerDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

public class ThrowMessageEventTriggerDefinitionImpl
extends MessageEventTriggerDefinitionImpl
implements ThrowMessageEventTriggerDefinition {
    private static final long serialVersionUID = -1678256136944568540L;
    private Expression targetProcess;
    private Expression targetFlowNode;
    private final List<DataDefinition> dataDefinitions;

    public ThrowMessageEventTriggerDefinitionImpl(String messageName) {
        super(messageName);
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess, Expression targetFlowNode) {
        super(name);
        this.targetProcess = targetProcess;
        this.targetFlowNode = targetFlowNode;
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess) {
        super(name);
        this.targetProcess = targetProcess;
        this.targetFlowNode = null;
        this.dataDefinitions = new ArrayList<DataDefinition>();
    }

    public ThrowMessageEventTriggerDefinitionImpl(String name, Expression targetProcess, Expression targetFlowNode, List<DataDefinition> dataDefinitions, List<CorrelationDefinition> correlations) {
        super(name, correlations);
        this.targetProcess = targetProcess;
        this.targetFlowNode = targetFlowNode;
        this.dataDefinitions = dataDefinitions;
    }

    public ThrowMessageEventTriggerDefinitionImpl(ThrowMessageEventTriggerDefinition trigger) {
        super(trigger);
        this.targetFlowNode = trigger.getTargetFlowNode();
        this.targetProcess = trigger.getTargetProcess();
        this.dataDefinitions = trigger.getDataDefinitions();
    }

    @Override
    public Expression getTargetProcess() {
        return this.targetProcess;
    }

    @Override
    public Expression getTargetFlowNode() {
        return this.targetFlowNode;
    }

    @Override
    public List<DataDefinition> getDataDefinitions() {
        return Collections.unmodifiableList(this.dataDefinitions);
    }

    public void setTargetProcess(Expression targetProcess) {
        this.targetProcess = targetProcess;
    }

    public void setTargetFlowNode(Expression targetFlowNode) {
        this.targetFlowNode = targetFlowNode;
    }

    public void addDataDefinition(DataDefinition datadefiniton) {
        this.dataDefinitions.add(datadefiniton);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataDefinitions == null ? 0 : this.dataDefinitions.hashCode());
        result = 31 * result + (this.targetFlowNode == null ? 0 : this.targetFlowNode.hashCode());
        result = 31 * result + (this.targetProcess == null ? 0 : this.targetProcess.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowMessageEventTriggerDefinitionImpl other = (ThrowMessageEventTriggerDefinitionImpl)obj;
        if (this.dataDefinitions == null ? other.dataDefinitions != null : !this.dataDefinitions.equals(other.dataDefinitions)) {
            return false;
        }
        if (this.targetFlowNode == null ? other.targetFlowNode != null : !this.targetFlowNode.equals(other.targetFlowNode)) {
            return false;
        }
        return !(this.targetProcess == null ? other.targetProcess != null : !this.targetProcess.equals(other.targetProcess));
    }
}

