/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.flownode.impl.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.bpm.flownode.CorrelationDefinition;
import org.bonitasoft.engine.bpm.flownode.MessageEventTriggerDefinition;
import org.bonitasoft.engine.bpm.flownode.impl.internal.CorrelationDefinitionImpl;
import org.bonitasoft.engine.expression.Expression;

public abstract class MessageEventTriggerDefinitionImpl
implements MessageEventTriggerDefinition {
    private static final long serialVersionUID = -190616505159460399L;
    private final String messageName;
    private final List<CorrelationDefinition> correlations;

    public MessageEventTriggerDefinitionImpl(String name) {
        this.messageName = name;
        this.correlations = new ArrayList<CorrelationDefinition>(1);
    }

    public MessageEventTriggerDefinitionImpl(String name, List<CorrelationDefinition> correlations) {
        this.messageName = name;
        this.correlations = correlations;
    }

    public MessageEventTriggerDefinitionImpl(MessageEventTriggerDefinition trigger) {
        this.messageName = trigger.getMessageName();
        this.correlations = trigger.getCorrelations();
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public List<CorrelationDefinition> getCorrelations() {
        return Collections.unmodifiableList(this.correlations);
    }

    public void addCorrelation(Expression key, Expression value) {
        this.correlations.add(new CorrelationDefinitionImpl(key, value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlations == null ? 0 : this.correlations.hashCode());
        result = 31 * result + (this.messageName == null ? 0 : this.messageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageEventTriggerDefinitionImpl other = (MessageEventTriggerDefinitionImpl)obj;
        if (this.correlations == null ? other.correlations != null : !this.correlations.equals(other.correlations)) {
            return false;
        }
        return !(this.messageName == null ? other.messageName != null : !this.messageName.equals(other.messageName));
    }
}

