/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.connector.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.bpm.internal.NamedElementImpl;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.operation.Operation;

public class ConnectorDefinitionImpl
extends NamedElementImpl
implements ConnectorDefinition {
    private static final long serialVersionUID = 1892648036453422626L;
    private final String connectorId;
    private final Map<String, Expression> inputs = new HashMap<String, Expression>();
    private final List<Operation> outputs = new ArrayList<Operation>();
    private final ConnectorEvent actiationEvent;
    private final String version;
    private FailAction failAction = FailAction.FAIL;
    private String errorCode;

    public ConnectorDefinitionImpl(String name, String connectorId, String version, ConnectorEvent actiationEvent) {
        super(name);
        this.connectorId = connectorId;
        this.version = version;
        this.actiationEvent = actiationEvent;
    }

    @Override
    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Map<String, Expression> getInputs() {
        return this.inputs;
    }

    @Override
    public List<Operation> getOutputs() {
        return this.outputs;
    }

    public void addInput(String name, Expression expression) {
        this.inputs.put(name, expression);
    }

    public void addOutput(Operation operation) {
        this.outputs.add(operation);
    }

    @Override
    public ConnectorEvent getActivationEvent() {
        return this.actiationEvent;
    }

    @Override
    public FailAction getFailAction() {
        return this.failAction;
    }

    public void setFailAction(FailAction failAction) {
        this.failAction = failAction;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return "ConnectorDefinitionImpl [connectorId=" + this.connectorId + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", actiationEvent=" + (Object)((Object)this.actiationEvent) + ", version=" + this.version + ", failAction=" + (Object)((Object)this.failAction) + ", errorCode=" + this.errorCode + ", getName()=" + this.getName() + ", getId()=" + this.getId() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actiationEvent == null ? 0 : this.actiationEvent.hashCode());
        result = 31 * result + (this.connectorId == null ? 0 : this.connectorId.hashCode());
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.failAction == null ? 0 : this.failAction.hashCode());
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + (this.outputs == null ? 0 : this.outputs.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorDefinitionImpl other = (ConnectorDefinitionImpl)obj;
        if (this.actiationEvent != other.actiationEvent) {
            return false;
        }
        if (this.connectorId == null ? other.connectorId != null : !this.connectorId.equals(other.connectorId)) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals(other.errorCode)) {
            return false;
        }
        if (this.failAction != other.failAction) {
            return false;
        }
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        if (this.outputs == null ? other.outputs != null : !this.outputs.equals(other.outputs)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

