/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.bar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.bonitasoft.engine.bpm.bar.BusinessArchive;
import org.bonitasoft.engine.bpm.bar.BusinessArchiveContribution;
import org.bonitasoft.engine.io.IOUtil;

public class ExternalResourceContribution
implements BusinessArchiveContribution {
    public static final String EXTERNAL_RESOURCE_FOLDER = "resources";

    @Override
    public boolean readFromBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        if (externalResourceFolder.exists() && !externalResourceFolder.isFile()) {
            return this.readFromFileOrFolder(businessArchive, externalResourceFolder, null) > 0;
        }
        return false;
    }

    private int readFromFileOrFolder(BusinessArchive businessArchive, File fileOrFolder, String parentFolder) throws FileNotFoundException, IOException {
        if (fileOrFolder.isFile()) {
            byte[] content = IOUtil.getContent(fileOrFolder);
            businessArchive.addResource(parentFolder + "/" + fileOrFolder.getName(), content);
            return 1;
        }
        if (fileOrFolder.isDirectory()) {
            int nb = 0;
            for (File file : fileOrFolder.listFiles()) {
                String parentFolder2 = fileOrFolder.getName();
                if (parentFolder != null) {
                    parentFolder2 = parentFolder + "/" + fileOrFolder.getName();
                }
                nb += this.readFromFileOrFolder(businessArchive, file, parentFolder2);
            }
            return nb;
        }
        return 0;
    }

    @Override
    public void saveToBarFolder(BusinessArchive businessArchive, File barFolder) throws IOException {
        File externalResourceFolder = new File(barFolder, EXTERNAL_RESOURCE_FOLDER);
        externalResourceFolder.mkdir();
        int beginIndex = EXTERNAL_RESOURCE_FOLDER.length();
        Map<String, byte[]> resources = businessArchive.getResources("^resources/.*$");
        for (Map.Entry<String, byte[]> entry : resources.entrySet()) {
            File fullPathFile = new File(externalResourceFolder, entry.getKey().substring(beginIndex));
            fullPathFile.getParentFile().mkdirs();
            IOUtil.write(fullPathFile, entry);
        }
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public String getName() {
        return EXTERNAL_RESOURCE_FOLDER;
    }
}

