/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.permission;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class APICallContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILTER_KEY = "f";
    public static final String SEARCH_TERM_KEY = "s";
    public static final String DELIMITER = "&";
    private String method;
    private String apiName;
    private String resourceName;
    private String resourceId;
    private String queryString;
    private String body;
    private Map<String, String> filters = new HashMap<String, String>();
    private String searchTerm;

    public APICallContext(String method, String apiName, String resourceName, String resourceId) {
        this(method, apiName, resourceName, resourceId, null, null);
    }

    public APICallContext(String method, String apiName, String resourceName, String resourceId, String queryString, String body) {
        this.method = method;
        this.apiName = apiName;
        this.resourceName = resourceName;
        this.resourceId = resourceId;
        this.queryString = queryString;
        this.parseQueryString(queryString);
        this.body = body;
    }

    private void parseQueryString(String queryString) {
        this.filters = new HashMap<String, String>();
        if (queryString == null) {
            return;
        }
        for (String element : queryString.split(DELIMITER)) {
            int indexOfEquals = element.indexOf("=");
            if (indexOfEquals <= 0 || indexOfEquals + 1 >= element.length()) continue;
            String key = element.substring(0, indexOfEquals);
            String value = element.substring(indexOfEquals + 1, element.length());
            if (FILTER_KEY.equals(key)) {
                this.addFilter(value);
                continue;
            }
            if (!SEARCH_TERM_KEY.equals(key)) continue;
            this.searchTerm = value;
        }
    }

    private void addFilter(String value) {
        int indexOfEncodedEquals = Math.max(value.indexOf("%3d"), value.indexOf("%3D"));
        if (indexOfEncodedEquals > 0 && indexOfEncodedEquals + 3 < value.length()) {
            this.filters.put(value.substring(0, indexOfEncodedEquals), value.substring(indexOfEncodedEquals + 3, value.length()));
        }
    }

    public APICallContext() {
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isGET() {
        return "GET".equals(this.method);
    }

    public boolean isPUT() {
        return "PUT".equals(this.method);
    }

    public boolean isPOST() {
        return "POST".equals(this.method);
    }

    public boolean isDELETE() {
        return "DELETE".equals(this.method);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public List<String> getCompoundResourceId() {
        return this.resourceId == null ? Collections.emptyList() : Arrays.asList(this.resourceId.split("/"));
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
        this.parseQueryString(queryString);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String toString() {
        return "APICallContext{method='" + this.method + '\'' + ", apiName='" + this.apiName + '\'' + ", resourceName='" + this.resourceName + '\'' + ", resourceId='" + this.resourceId + '\'' + ", queryString='" + this.queryString + '\'' + ", body='" + this.body + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APICallContext that = (APICallContext)o;
        if (this.apiName != null ? !this.apiName.equals(that.apiName) : that.apiName != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) {
            return false;
        }
        if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) {
            return false;
        }
        if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) {
            return false;
        }
        return !(this.searchTerm != null ? !this.searchTerm.equals(that.searchTerm) : that.searchTerm != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.apiName != null ? this.apiName.hashCode() : 0);
        result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
        result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
        result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
        result = 31 * result + (this.searchTerm != null ? this.searchTerm.hashCode() : 0);
        return result;
    }
}

