/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning.kmeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.neuroph.nnet.learning.kmeans.KVector;

public class Cluster {
    KVector centroid;
    List<KVector> vectors = new ArrayList<KVector>();

    public KVector getCentroid() {
        return this.centroid;
    }

    public void setCentroid(KVector centroid) {
        this.centroid = centroid;
    }

    public void removePoint(KVector point) {
        this.vectors.remove(point);
    }

    public List<KVector> getPoints() {
        return this.vectors;
    }

    public double[] getAvgSum() {
        double size = this.vectors.size();
        double[] avg = new double[this.vectors.get(0).size()];
        for (KVector item : this.vectors) {
            double[] values = item.getValues();
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                avg[n] = avg[n] + values[i] / size;
            }
        }
        return avg;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        double[] otherValues = other.getCentroid().getValues();
        double[] values = other.getCentroid().getValues();
        for (int i = 0; i < this.centroid.size(); ++i) {
            if (otherValues[i] == values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.centroid);
        hash = 97 * hash + Objects.hashCode(this.vectors);
        return hash;
    }

    public void assignVector(KVector vector) {
        if (vector.getCluster() != this) {
            vector.setCluster(this);
            this.vectors.add(vector);
        }
    }

    public int size() {
        return this.vectors.size();
    }
}

