/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import java.util.Iterator;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.learning.SupervisedLearning;
import org.neuroph.util.NeuralNetworkCODEC;

public class SimulatedAnnealingLearning
extends SupervisedLearning {
    private static final long serialVersionUID = 1L;
    protected NeuralNetwork network;
    private double startTemperature;
    private double stopTemperature;
    private int cycles;
    protected double temperature;
    private double[] weights;
    private double[] bestWeights;

    public SimulatedAnnealingLearning(NeuralNetwork network, double startTemp, double stopTemp, int cycles) {
        this.network = network;
        this.temperature = startTemp;
        this.startTemperature = startTemp;
        this.stopTemperature = stopTemp;
        this.cycles = cycles;
        this.weights = new double[NeuralNetworkCODEC.determineArraySize(network)];
        this.bestWeights = new double[NeuralNetworkCODEC.determineArraySize(network)];
        NeuralNetworkCODEC.network2array(network, this.weights);
        NeuralNetworkCODEC.network2array(network, this.bestWeights);
    }

    public SimulatedAnnealingLearning(NeuralNetwork network) {
        this(network, 10.0, 2.0, 1000);
    }

    public NeuralNetwork getNetwork() {
        return this.network;
    }

    public void randomize() {
        for (int i = 0; i < this.weights.length; ++i) {
            double add = 0.5 - Math.random();
            add /= this.startTemperature;
            this.weights[i] = this.weights[i] + (add *= this.temperature);
        }
        NeuralNetworkCODEC.array2network(this.weights, this.network);
    }

    private double determineError(DataSet trainingSet) {
        double result = 0.0;
        Iterator<DataSetRow> iterator = trainingSet.iterator();
        while (iterator.hasNext() && !this.isStopped()) {
            DataSetRow trainingSetRow = iterator.next();
            double[] input = trainingSetRow.getInput();
            this.neuralNetwork.setInput(input);
            this.neuralNetwork.calculate();
            double[] output = this.neuralNetwork.getOutput();
            double[] desiredOutput = trainingSetRow.getDesiredOutput();
            Object patternError = null;
            double sqrErrorSum = 0.0;
            for (void error : patternError) {
                sqrErrorSum += error * error;
            }
            result += sqrErrorSum / (double)(2 * (patternError).length);
        }
        return result;
    }

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        System.arraycopy(this.weights, 0, this.bestWeights, 0, this.weights.length);
        double bestError = this.determineError(trainingSet);
        this.temperature = this.startTemperature;
        for (int i = 0; i < this.cycles; ++i) {
            this.randomize();
            double currentError = this.determineError(trainingSet);
            if (currentError < bestError) {
                System.arraycopy(this.weights, 0, this.bestWeights, 0, this.weights.length);
                bestError = currentError;
            } else {
                System.arraycopy(this.bestWeights, 0, this.weights, 0, this.weights.length);
            }
            NeuralNetworkCODEC.array2network(this.bestWeights, this.network);
            double ratio = Math.exp(Math.log(this.stopTemperature / this.startTemperature) / (double)(this.cycles - 1));
            this.temperature *= ratio;
        }
        this.previousEpochError = this.getErrorFunction().getTotalError();
        if (this.hasReachedStopCondition()) {
            this.stopLearning();
        }
    }

    @Override
    protected void updateNetworkWeights(double[] patternError) {
    }
}

