/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Connection;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.UnsupervisedLearning;
import org.neuroph.nnet.comp.layer.CompetitiveLayer;
import org.neuroph.nnet.comp.neuron.CompetitiveNeuron;

public class CompetitiveLearning
extends UnsupervisedLearning {
    private static final long serialVersionUID = 1L;

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        super.doLearningEpoch(trainingSet);
        this.stopLearning();
    }

    @Override
    protected void updateNetworkWeights() {
        Connection[] inputConnections;
        CompetitiveNeuron winningNeuron = ((CompetitiveLayer)this.neuralNetwork.getLayerAt(1)).getWinner();
        for (Connection connection : inputConnections = winningNeuron.getConnectionsFromOtherLayers()) {
            double weight = connection.getWeight().getValue();
            double input = connection.getInput();
            double deltaWeight = this.learningRate * (input - weight);
            connection.getWeight().inc(deltaWeight);
        }
    }
}

