/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning;

import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.neuron.ThresholdNeuron;
import org.neuroph.nnet.learning.PerceptronLearning;

public class BinaryDeltaRule
extends PerceptronLearning {
    private static final long serialVersionUID = 1L;
    private double errorCorrection = 0.1;

    @Override
    protected void updateNetworkWeights(double[] patternError) {
        int i = 0;
        for (Neuron outputNeuron : this.neuralNetwork.getOutputNeurons()) {
            ThresholdNeuron neuron = (ThresholdNeuron)outputNeuron;
            double outErr = patternError[i];
            double thresh = neuron.getThresh();
            double netInput = neuron.getNetInput();
            double threshError = thresh - netInput;
            double neuronError = outErr * (Math.abs(threshError) + this.errorCorrection);
            neuron.setError(neuronError);
            this.updateNeuronWeights(neuron);
            ++i;
        }
    }

    public double getErrorCorrection() {
        return this.errorCorrection;
    }

    public void setErrorCorrection(double errorCorrection) {
        this.errorCorrection = errorCorrection;
    }
}

