/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.neuron;

import java.util.Arrays;
import org.neuroph.core.Connection;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.nnet.comp.neuron.DelayedNeuron;

public class CompetitiveNeuron
extends DelayedNeuron {
    private static final long serialVersionUID = 1L;
    private boolean isCompeting = false;
    private Connection[] connectionsFromOtherLayers = new Connection[0];
    private Connection[] connectionsFromThisLayer = new Connection[0];

    public CompetitiveNeuron(InputFunction inputFunction, TransferFunction transferFunction) {
        super(inputFunction, transferFunction);
        this.addInputConnection(this, 1.0);
    }

    @Override
    public void calculate() {
        if (this.isCompeting) {
            this.netInput = this.inputFunction.getOutput(this.connectionsFromThisLayer);
        } else {
            this.netInput = this.inputFunction.getOutput(this.connectionsFromOtherLayers);
            this.isCompeting = true;
        }
        this.output = this.transferFunction.getOutput(this.netInput);
        this.outputHistory.add(0, new Double(this.output));
    }

    @Override
    public void addInputConnection(Connection connection) {
        super.addInputConnection(connection);
        if (connection.getFromNeuron().getParentLayer() == this.getParentLayer()) {
            this.connectionsFromThisLayer = Arrays.copyOf(this.connectionsFromThisLayer, this.connectionsFromThisLayer.length + 1);
            this.connectionsFromThisLayer[this.connectionsFromThisLayer.length - 1] = connection;
        } else {
            this.connectionsFromOtherLayers = Arrays.copyOf(this.connectionsFromOtherLayers, this.connectionsFromOtherLayers.length + 1);
            this.connectionsFromOtherLayers[this.connectionsFromOtherLayers.length - 1] = connection;
        }
    }

    public Connection[] getConnectionsFromOtherLayers() {
        return this.connectionsFromOtherLayers;
    }

    @Override
    public void reset() {
        super.reset();
        this.isCompeting = false;
    }

    public boolean isCompeting() {
        return this.isCompeting;
    }

    public void setIsCompeting(boolean isCompeting) {
        this.isCompeting = isCompeting;
    }
}

