/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.util.NeuronFactory;
import org.neuroph.util.NeuronProperties;

public class Layer2D
extends Layer
implements Callable<Void> {
    private static final long serialVersionUID = 2498669699995172395L;
    private Dimensions dimensions;

    public Layer2D(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Layer2D(Dimensions dimensions, NeuronProperties neuronProperties) {
        this(dimensions);
        for (int i = 0; i < dimensions.getHeight() * dimensions.getWidth(); ++i) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            this.addNeuron(neuron);
        }
    }

    public int getWidth() {
        return this.dimensions.getWidth();
    }

    public int getHeight() {
        return this.dimensions.getHeight();
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public Neuron getNeuronAt(int x, int y) {
        return this.getNeuronAt(x + y * this.dimensions.getWidth());
    }

    @Override
    public Void call() throws Exception {
        this.calculate();
        return null;
    }

    public static class Dimensions
    implements Serializable {
        private static final long serialVersionUID = -4491706467345191108L;
        private int width;
        private int height;

        public Dimensions(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String toString() {
            String dimensions = "Width = " + this.width + "; Height = " + this.height;
            return dimensions;
        }
    }
}

