/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.comp.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.nnet.comp.Kernel;
import org.neuroph.nnet.comp.layer.Layer2D;
import org.neuroph.util.NeuronProperties;

public class FeatureMapsLayer
extends Layer {
    static final ForkJoinPool mainPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
    private static final long serialVersionUID = -6706741997689639209L;
    protected Kernel kernel;
    protected Layer2D.Dimensions mapDimensions;
    private List<Layer2D> featureMaps;

    public List<Layer2D> getFeatureMaps() {
        return this.featureMaps;
    }

    public FeatureMapsLayer(Kernel kernel) {
        this.kernel = kernel;
        this.featureMaps = new ArrayList<Layer2D>();
    }

    public FeatureMapsLayer(Kernel kernel, Layer2D.Dimensions mapDimensions) {
        this.kernel = kernel;
        this.mapDimensions = mapDimensions;
        this.featureMaps = new ArrayList<Layer2D>();
    }

    public FeatureMapsLayer(Kernel kernel, Layer2D.Dimensions mapDimensions, int mapCount, NeuronProperties neuronProp) {
        this.kernel = kernel;
        this.mapDimensions = mapDimensions;
        this.featureMaps = new ArrayList<Layer2D>();
        this.createFeatureMaps(mapCount, this.mapDimensions, neuronProp);
    }

    public void addFeatureMap(Layer2D featureMap) {
        if (featureMap == null) {
            throw new IllegalArgumentException("FeatureMap cant be null!");
        }
        this.featureMaps.add(featureMap);
        this.neurons.addAll(Arrays.asList(featureMap.getNeurons()));
    }

    protected final void createFeatureMaps(int mapCount, Layer2D.Dimensions dimensions, NeuronProperties neuronProperties) {
        for (int i = 0; i < mapCount; ++i) {
            this.addFeatureMap(new Layer2D(dimensions, neuronProperties));
        }
    }

    public Layer2D getFeatureMap(int index) {
        return this.featureMaps.get(index);
    }

    public int getNumberOfMaps() {
        return this.featureMaps.size();
    }

    public Neuron getNeuronAt(int x, int y, int mapIndex) {
        Layer2D map = this.featureMaps.get(mapIndex);
        return map.getNeuronAt(x, y);
    }

    @Override
    public int getNeuronsCount() {
        int neuronCount = 0;
        for (Layer2D map : this.featureMaps) {
            neuronCount += map.getNeuronsCount();
        }
        return neuronCount;
    }

    @Override
    public void calculate() {
        mainPool.invokeAll(this.featureMaps);
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public Layer2D.Dimensions getMapDimensions() {
        return this.mapDimensions;
    }

    public void connectMaps(Layer2D fromMap, Layer2D toMap) {
    }
}

